/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sheridan.gunscraft.container.NewAttachmentMenu;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.attachments.util.newSys.Result;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.IPacket;
import sheridan.gunscraft.network.packets.UpdateClientAttachmentsScreenPacket;

public class NewSetAttachmentPacket
implements IPacket<NewSetAttachmentPacket> {
    public String attachmentId;
    public String slotName;
    public int itemSlotIndex;

    public NewSetAttachmentPacket() {
    }

    public NewSetAttachmentPacket(String attachmentId, String slotName, int itemSlotIndex) {
        this.attachmentId = attachmentId;
        this.slotName = slotName;
        this.itemSlotIndex = itemSlotIndex;
    }

    @Override
    public void encode(NewSetAttachmentPacket message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.attachmentId);
        buffer.m_130070_(message.slotName);
        buffer.writeInt(message.itemSlotIndex);
    }

    @Override
    public NewSetAttachmentPacket decode(FriendlyByteBuf buffer) {
        NewSetAttachmentPacket packetNew = new NewSetAttachmentPacket();
        packetNew.attachmentId = buffer.m_130277_();
        packetNew.slotName = buffer.m_130277_();
        packetNew.itemSlotIndex = buffer.readInt();
        return packetNew;
    }

    @Override
    public void handle(NewSetAttachmentPacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (stack = player.m_21205_()).m_41720_() instanceof IGenericGun) {
                AbstractContainerMenu patt3243$temp;
                SlotTag slotTag = AttachmentsHandler.INSTANCE.searchUniqueSlot(stack, message.slotName);
                if (AttachmentsHandler.EMPTY_ID.equals(message.attachmentId)) {
                    ItemStack itemStack;
                    Result result = slotTag.unInstall((Player)player, stack);
                    if (result.success && !player.m_36356_(itemStack = new ItemStack((ItemLike)result.attachment.getAttachment()))) {
                        ItemEntity entity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), itemStack);
                        player.m_9236_().m_7967_((Entity)entity);
                    }
                } else if (slotTag.install((Player)player, (ItemStack)stack, (String)message.attachmentId).success && (patt3243$temp = player.f_36096_) instanceof NewAttachmentMenu) {
                    NewAttachmentMenu menu = (NewAttachmentMenu)patt3243$temp;
                    ((Slot)menu.f_38839_.get(message.itemSlotIndex)).m_5852_(ItemStack.f_41583_);
                }
                PacketHandler.simpleChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateClientAttachmentsScreenPacket(AttachmentsHandler.INSTANCE.checkAndGet(stack)));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

