/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.network.packets.IPacket;

public class ParticlePacket
implements IPacket<ParticlePacket> {
    public BlockPos blockPos;
    public Vec3 pos;
    public int directionIndex = -1;
    public int force;

    public ParticlePacket() {
    }

    public ParticlePacket(BlockPos blockPos, Vec3 pos, Direction direction, int force) {
        this.blockPos = blockPos;
        this.pos = pos;
        this.directionIndex = this.getIndex(direction);
        this.force = force;
    }

    private int getIndex(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> 0;
            case Direction.DOWN -> 1;
            case Direction.SOUTH -> 2;
            case Direction.NORTH -> 3;
            case Direction.WEST -> 4;
            case Direction.EAST -> 5;
        };
    }

    @Override
    public void encode(ParticlePacket message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.blockPos);
        buffer.writeDouble(message.pos.f_82479_);
        buffer.writeDouble(message.pos.f_82480_);
        buffer.writeDouble(message.pos.f_82481_);
        buffer.writeInt(message.directionIndex);
        buffer.writeInt(message.force);
    }

    @Override
    public ParticlePacket decode(FriendlyByteBuf buffer) {
        ParticlePacket particlePacket = new ParticlePacket();
        particlePacket.blockPos = buffer.m_130135_();
        particlePacket.pos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        particlePacket.directionIndex = buffer.readInt();
        particlePacket.force = buffer.readInt();
        return particlePacket;
    }

    @Override
    public void handle(ParticlePacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Clients.testPlayParticle(message.blockPos, message.pos, message.directionIndex, message.force)));
        supplier.get().setPacketHandled(true);
    }
}

