/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.items.guns.GenericGun;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.packets.IPacket;
import sheridan.gunscraft.sounds.SoundEvents;

public class ReloadGunPacket
implements IPacket<ReloadGunPacket> {
    public boolean isMainHand;
    public boolean succeed;
    public boolean start;

    public ReloadGunPacket() {
    }

    public ReloadGunPacket(boolean isMainHand) {
        this.isMainHand = isMainHand;
    }

    public ReloadGunPacket(boolean isMainHand, boolean succeed, boolean start) {
        this.isMainHand = isMainHand;
        this.succeed = succeed;
        this.start = start;
    }

    @Override
    public void encode(ReloadGunPacket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.isMainHand);
        buffer.writeBoolean(message.succeed);
        buffer.writeBoolean(message.start);
    }

    @Override
    public ReloadGunPacket decode(FriendlyByteBuf buffer) {
        ReloadGunPacket packet = new ReloadGunPacket();
        packet.isMainHand = buffer.readBoolean();
        packet.succeed = buffer.readBoolean();
        packet.start = buffer.readBoolean();
        return packet;
    }

    @Override
    public void handle(ReloadGunPacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                ItemStack heldStack;
                boolean start = message.start;
                boolean isMainHand = message.isMainHand;
                ItemStack itemStack = heldStack = isMainHand ? player.m_21205_() : player.m_21206_();
                if (start) {
                    player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                        cap.reloading = true;
                        cap.dataChanged = true;
                    });
                    SoundEvents.playSound(((GenericGun)heldStack.m_41720_()).normalReloadSound, (LivingEntity)player, 1.0f, 1.0f);
                } else {
                    boolean succeed = message.succeed;
                    if (succeed) {
                        IGenericGun gun = (IGenericGun)heldStack.m_41720_();
                        gun.reload(heldStack, (LivingEntity)player, isMainHand);
                    }
                    player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                        cap.reloading = false;
                        cap.dataChanged = true;
                    });
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

