/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.items.guns.GenericGun;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.packets.IPacket;
import sheridan.gunscraft.sounds.SoundEvents;

public class ShotGunReloadPacket
implements IPacket<ShotGunReloadPacket> {
    public boolean isMainHand;
    public boolean stopReload;
    public boolean increaseAmmo;
    public boolean start;

    public ShotGunReloadPacket() {
    }

    public ShotGunReloadPacket(boolean isMainHand, boolean stopReload, boolean start, boolean increaseAmmo) {
        this.isMainHand = isMainHand;
        this.stopReload = stopReload;
        this.start = start;
        this.increaseAmmo = increaseAmmo;
    }

    @Override
    public void encode(ShotGunReloadPacket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.isMainHand);
        buffer.writeBoolean(message.stopReload);
        buffer.writeBoolean(message.start);
        buffer.writeBoolean(message.increaseAmmo);
    }

    @Override
    public ShotGunReloadPacket decode(FriendlyByteBuf buffer) {
        ShotGunReloadPacket packet = new ShotGunReloadPacket();
        packet.isMainHand = buffer.readBoolean();
        packet.stopReload = buffer.readBoolean();
        packet.start = buffer.readBoolean();
        packet.increaseAmmo = buffer.readBoolean();
        return packet;
    }

    @Override
    public void handle(ShotGunReloadPacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                ItemStack heldStack;
                boolean start = message.start;
                boolean isMainHand = message.isMainHand;
                ItemStack itemStack = heldStack = isMainHand ? player.m_21205_() : player.m_21206_();
                if (start) {
                    player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                        cap.reloading = true;
                        cap.dataChanged = true;
                    });
                    SoundEvents.playSound(((GenericGun)heldStack.m_41720_()).normalReloadSound, (LivingEntity)player, 1.0f, 1.0f);
                } else {
                    if (message.stopReload) {
                        player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                            cap.reloading = false;
                            cap.dataChanged = true;
                        });
                    }
                    if (message.increaseAmmo) {
                        IGenericGun gun = (IGenericGun)heldStack.m_41720_();
                        gun.reload(heldStack, (LivingEntity)player, isMainHand);
                    }
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

