/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.packets.IPacket;

public class SwitchFireModePacket
implements IPacket<SwitchFireModePacket> {
    public boolean isMainHand;

    public SwitchFireModePacket() {
    }

    public SwitchFireModePacket(boolean isMainHand) {
        this.isMainHand = isMainHand;
    }

    @Override
    public void encode(SwitchFireModePacket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.isMainHand);
    }

    @Override
    public SwitchFireModePacket decode(FriendlyByteBuf buffer) {
        SwitchFireModePacket packet = new SwitchFireModePacket();
        packet.isMainHand = buffer.readBoolean();
        return packet;
    }

    @Override
    public void handle(SwitchFireModePacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                boolean isMainHand = message.isMainHand;
                ItemStack heldStack = isMainHand ? player.m_21205_() : player.m_21206_();
                IGenericGun gun = (IGenericGun)heldStack.m_41720_();
                gun.switchFireMode(heldStack);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

