/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.network.packets.IPacket;

public class SyncPlayerStatusPacket
implements IPacket<SyncPlayerStatusPacket> {
    public int id;
    public long lastShootRight;
    public long lastShootLeft;
    public long lastChamber;
    public boolean reloading;
    public boolean aiming;

    public SyncPlayerStatusPacket() {
    }

    public SyncPlayerStatusPacket(int id, long lastShootRight, long lastShootLeft, long lastChamber, boolean reloading, boolean aiming) {
        this.id = id;
        this.lastShootRight = lastShootRight;
        this.lastShootLeft = lastShootLeft;
        this.lastChamber = lastChamber;
        this.reloading = reloading;
        this.aiming = aiming;
    }

    @Override
    public void encode(SyncPlayerStatusPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.id);
        buffer.writeLong(message.lastShootRight);
        buffer.writeLong(message.lastShootLeft);
        buffer.writeLong(message.lastChamber);
        buffer.writeBoolean(message.reloading);
        buffer.writeBoolean(message.aiming);
    }

    @Override
    public SyncPlayerStatusPacket decode(FriendlyByteBuf buffer) {
        SyncPlayerStatusPacket setPlayerStatusPacket = new SyncPlayerStatusPacket();
        setPlayerStatusPacket.id = buffer.readInt();
        setPlayerStatusPacket.lastShootRight = buffer.readLong();
        setPlayerStatusPacket.lastShootLeft = buffer.readLong();
        setPlayerStatusPacket.lastChamber = buffer.readLong();
        setPlayerStatusPacket.reloading = buffer.readBoolean();
        setPlayerStatusPacket.aiming = buffer.readBoolean();
        return setPlayerStatusPacket;
    }

    @Override
    public void handle(SyncPlayerStatusPacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Clients.updateClientPlayerStatus(message.id, message.lastShootRight, message.lastShootLeft, message.lastChamber, message.aiming, message.reloading)));
        supplier.get().setPacketHandled(true);
    }
}

