/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.blocks.VendingMachine;
import sheridan.gunscraft.network.packets.IPacket;

public class VendingMachineDealPacket
implements IPacket<VendingMachineDealPacket> {
    public List<ItemStack> products;
    public int totalAsset;
    public int len;

    public VendingMachineDealPacket(List<ItemStack> products, int totalAsset) {
        this.products = products;
        this.totalAsset = totalAsset;
        this.len = products.size();
    }

    public VendingMachineDealPacket() {
        this.products = new ArrayList<ItemStack>();
    }

    @Override
    public void encode(VendingMachineDealPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.len);
        buffer.writeInt(message.totalAsset);
        if (message.products != null && message.len > 0) {
            for (ItemStack stack : message.products) {
                buffer.writeItemStack(stack, false);
            }
        }
    }

    @Override
    public VendingMachineDealPacket decode(FriendlyByteBuf buffer) {
        int len;
        VendingMachineDealPacket packet = new VendingMachineDealPacket();
        packet.len = len = buffer.readInt();
        packet.totalAsset = buffer.readInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ItemStack stack = buffer.m_130267_();
                if (stack == ItemStack.f_41583_) continue;
                packet.products.add(stack);
            }
        }
        return packet;
    }

    @Override
    public void handle(VendingMachineDealPacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                VendingMachine.deal((Player)player, message.products, message.totalAsset);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

