/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.items.Cash;
import sheridan.gunscraft.network.packets.IPacket;

public class VendingMachineExchangePacket
implements IPacket<VendingMachineExchangePacket> {
    public int exchangeVal;
    public int minExchangeVal;
    public int itemId;

    public VendingMachineExchangePacket(int exchangeVal, int minExchangeVal, int itemId) {
        this.exchangeVal = exchangeVal;
        this.minExchangeVal = minExchangeVal;
        this.itemId = itemId;
    }

    public VendingMachineExchangePacket() {
    }

    @Override
    public void encode(VendingMachineExchangePacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.exchangeVal);
        buffer.writeInt(message.minExchangeVal);
        buffer.writeInt(message.itemId);
    }

    @Override
    public VendingMachineExchangePacket decode(FriendlyByteBuf buffer) {
        VendingMachineExchangePacket packet = new VendingMachineExchangePacket();
        packet.exchangeVal = buffer.readInt();
        packet.minExchangeVal = buffer.readInt();
        packet.itemId = buffer.readInt();
        return packet;
    }

    @Override
    public void handle(VendingMachineExchangePacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                Cash.exchange(message.exchangeVal, (Player)player, message.minExchangeVal, message.itemId);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

