/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.network.packets.IPacket;

public class VendingMachineUpdateAssetPacket
implements IPacket<VendingMachineUpdateAssetPacket> {
    public int asset;

    public VendingMachineUpdateAssetPacket() {
    }

    public VendingMachineUpdateAssetPacket(int asset) {
        this.asset = asset;
    }

    @Override
    public void encode(VendingMachineUpdateAssetPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.asset);
    }

    @Override
    public VendingMachineUpdateAssetPacket decode(FriendlyByteBuf buffer) {
        return new VendingMachineUpdateAssetPacket(buffer.readInt());
    }

    @Override
    public void handle(VendingMachineUpdateAssetPacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Clients.setVendingMachineAssetChange(message.asset)));
        supplier.get().setPacketHandled(true);
    }
}

