/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.animation.keyFrame.FrameAnimation;
import sheridan.gunscraft.animation.keyFrame.copyAniamtion.AnimationDefinition;
import sheridan.gunscraft.animation.keyFrame.copyAniamtion.HierarchicalModel;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRenderContext;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.guns.BoltActionGun;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.render.GunRenderer;
import sheridan.gunscraft.render.TransformData;

public class GunRenderContext {
    public Runnable muzzleFlashTask;
    public AttachmentRenderContext attachmentRenderContext;
    public TransformData transformData = null;
    public boolean isFirstPerson;
    public ItemDisplayContext fixedTransformType;
    public ItemDisplayContext transformType;
    public MultiBufferSource bufferSource;
    public int bulletLeft;
    public long lastFireTime = 0L;
    public long lastChamberTime = 0L;
    public boolean mainHand = false;
    public int fireDis;
    public int fireMode;
    public IGenericGun gun;
    public ItemStack itemStack;
    public long lastReload;
    public PoseStack poseStack;
    public int packedLight;
    public int packedOverlay;
    public ResourceLocation texture;
    public float r = 1.0f;
    public float g = 1.0f;
    public float b = 1.0f;
    public float a = 1.0f;
    boolean doFPMuzzleFlash;

    public GunRenderContext(Runnable muzzleFlashTask, AttachmentRenderContext attachmentRenderContext, TransformData transformData, boolean isFirstPerson, ItemDisplayContext fixedTransformType, ItemDisplayContext transformType, int bulletLeft, long lastFireTime, long lastChamberTime, boolean mainHand, int fireDis, int fireMode, IGenericGun gun, ItemStack itemStack, long lastReload, PoseStack poseStack, int packedLight, int packedOverlay, ResourceLocation texture, float r, float g, float b, float a, MultiBufferSource bufferSource) {
        this.muzzleFlashTask = muzzleFlashTask;
        this.attachmentRenderContext = attachmentRenderContext;
        this.transformData = transformData;
        this.isFirstPerson = isFirstPerson;
        this.fixedTransformType = fixedTransformType;
        this.transformType = transformType;
        this.bulletLeft = bulletLeft;
        this.lastFireTime = lastFireTime;
        this.lastChamberTime = lastChamberTime;
        this.mainHand = mainHand;
        this.fireDis = fireDis;
        this.fireMode = fireMode;
        this.gun = gun;
        this.itemStack = itemStack;
        this.lastReload = lastReload;
        this.poseStack = poseStack;
        this.packedLight = packedLight;
        this.packedOverlay = packedOverlay;
        this.texture = texture;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.bufferSource = bufferSource;
    }

    protected GunRenderContext(AttachmentRenderContext attachmentRenderContext, ItemDisplayContext transformType, int bulletLeft, int fireDis, int fireMode, IGenericGun gun, ItemStack itemStack, PoseStack poseStack, int packedLight, int packedOverlay, ResourceLocation texture, MultiBufferSource bufferSource) {
        this.attachmentRenderContext = attachmentRenderContext;
        this.bulletLeft = bulletLeft;
        this.fireDis = fireDis;
        this.fireMode = fireMode;
        this.gun = gun;
        this.itemStack = itemStack;
        this.poseStack = poseStack;
        this.packedLight = packedLight;
        this.packedOverlay = packedOverlay;
        this.texture = texture;
        this.transformType = transformType;
        this.bufferSource = bufferSource;
    }

    protected GunRenderContext(Runnable muzzleFlashTask, AttachmentRenderContext attachmentRenderContext, TransformData transformData, boolean isFirstPerson, ItemDisplayContext fixedTransformType, ItemDisplayContext transformType, int bulletLeft, long lastFireTime, long lastChamberTime, boolean mainHand, int fireDis, int fireMode, IGenericGun gun, ItemStack itemStack, long lastReload, PoseStack poseStack, int packedLight, int packedOverlay, ResourceLocation texture, MultiBufferSource bufferSource, boolean doFPMuzzleFlash) {
        this.muzzleFlashTask = muzzleFlashTask;
        this.attachmentRenderContext = attachmentRenderContext;
        this.transformData = transformData;
        this.isFirstPerson = isFirstPerson;
        this.fixedTransformType = fixedTransformType;
        this.transformType = transformType;
        this.bulletLeft = bulletLeft;
        this.lastFireTime = lastFireTime;
        this.lastChamberTime = lastChamberTime;
        this.mainHand = mainHand;
        this.fireDis = fireDis;
        this.fireMode = fireMode;
        this.gun = gun;
        this.itemStack = itemStack;
        this.lastReload = lastReload;
        this.poseStack = poseStack;
        this.packedLight = packedLight;
        this.packedOverlay = packedOverlay;
        this.texture = texture;
        this.bufferSource = bufferSource;
        this.doFPMuzzleFlash = doFPMuzzleFlash;
    }

    public static GunRenderContext createStaticModel(PoseStack poseStack, ItemDisplayContext transformType, int light, int overlay, IGenericGun gun, ItemStack itemStack, MultiBufferSource bufferSource) {
        AttachmentRenderContext context = AttachmentsHandler.INSTANCE.getContextWhenRender(itemStack);
        return new GunRenderContext(context, transformType, gun.getAmmoLeft(itemStack), (int)((long)(gun.getShootDelay() - 1) * 10L), gun.getFireMode(itemStack), gun, itemStack, poseStack, light, overlay, gun.getTexture(gun.getCurrentTextureIndex(itemStack)), bufferSource);
    }

    public static GunRenderContext createThirdPersonView(PoseStack poseStack, ItemDisplayContext transformType, int light, int overlay, IGenericGun gun, ItemStack itemStack, long lastFireTime, long lastChamberTime, boolean mainHand, MultiBufferSource bufferSource) {
        AttachmentRenderContext context = AttachmentsHandler.INSTANCE.getContextWhenRender(itemStack);
        GunRenderContext gunRenderContext = new GunRenderContext(context, transformType, gun.getAmmoLeft(itemStack), (int)((long)(gun.getShootDelay() - 1) * 10L), gun.getFireMode(itemStack), gun, itemStack, poseStack, light, overlay, gun.getTexture(gun.getCurrentTextureIndex(itemStack)), bufferSource);
        gunRenderContext.lastFireTime = lastFireTime;
        gunRenderContext.lastChamberTime = lastChamberTime;
        gunRenderContext.mainHand = mainHand;
        return gunRenderContext;
    }

    public static GunRenderContext createFirstPersonView(PoseStack poseStack, ItemDisplayContext transformType, int light, int overlay, long lastFireTime, long lastChamberTime, boolean mainHand, IGenericGun gun, ItemStack itemStack, TransformData transformData, MultiBufferSource finalBufferIn) {
        return new GunRenderContext(() -> GunRenderer.renderMuzzleFlash(gun, itemStack, transformData, lastFireTime, finalBufferIn, poseStack, true), AttachmentsHandler.INSTANCE.getContextWhenRender(itemStack), transformData, true, mainHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, transformType, gun.getAmmoLeft(itemStack), lastFireTime, lastChamberTime, mainHand, (int)((long)(gun.getShootDelay() - 1) * 10L), gun.getFireMode(itemStack), gun, itemStack, ReloadingHandler.INSTANCE.getLastStartReloadTime(mainHand), poseStack, light, overlay, gun.getTexture(gun.getCurrentTextureIndex(itemStack)), finalBufferIn, true);
    }

    public void playMuzzleFlash() {
        if (this.muzzleFlashTask != null) {
            this.muzzleFlashTask.run();
        }
    }

    public void renderMuzzleFlashFP() {
        if (this.doFPMuzzleFlash) {
            GunRenderer.renderMuzzleFlash(this.gun, this.itemStack, this.transformData, this.lastFireTime, this.bufferSource, this.poseStack, true);
        }
    }

    public boolean isThirdPerson() {
        return this.transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || this.transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
    }

    public VertexConsumer getVertexConsumer(RenderType renderType) {
        return this.bufferSource.m_6299_(renderType);
    }

    public void handlePistolArmRenderFP(ModelPart right_arm, ModelPart left_arm_right_side, ModelPart left_arm_left_side) {
        if (this.isFirstPerson) {
            int armPose = Clients.armPose;
            if (armPose == 0) {
                GunRenderer.INSTANCE.renderArm(false, left_arm_right_side, this.poseStack, this.packedLight, this.packedOverlay, this.bufferSource);
                GunRenderer.INSTANCE.renderArm(true, right_arm, this.poseStack, this.packedLight, this.packedOverlay, this.bufferSource);
            } else if (armPose == 2) {
                GunRenderer.INSTANCE.renderArm(false, left_arm_left_side, this.poseStack, this.packedLight, this.packedOverlay, this.bufferSource);
            } else if (armPose == 1) {
                GunRenderer.INSTANCE.renderArm(true, right_arm, this.poseStack, this.packedLight, this.packedOverlay, this.bufferSource);
            } else if (armPose == 3) {
                if (this.mainHand) {
                    GunRenderer.INSTANCE.renderArm(true, right_arm, this.poseStack, this.packedLight, this.packedOverlay, this.bufferSource);
                } else {
                    GunRenderer.INSTANCE.renderArm(false, left_arm_left_side, this.poseStack, this.packedLight, this.packedOverlay, this.bufferSource);
                }
            }
        }
    }

    public boolean shouldPlayReloadAnimation() {
        return Clients.shouldHandleAnimation && this.lastReload != 0L && this.isFirstPerson;
    }

    public boolean shouldPlayChamberAnimation() {
        return Clients.shouldHandleAnimation && this.lastChamberTime != 0L && this.isFirstPerson && !ReloadingHandler.INSTANCE.isReloading();
    }

    public boolean shouldPlayFPAnimation() {
        return Clients.shouldHandleAnimation && this.isFirstPerson;
    }

    public boolean renderReloadArm(int delay) {
        return this.lastReload != 0L && System.currentTimeMillis() - this.lastReload > (long)delay;
    }

    public void chooseAndPlayReloadAnimation(AnimationDefinition justChangeMag, AnimationDefinition fullReload, HierarchicalModel<?> root) {
        if (this.shouldPlayReloadAnimation()) {
            IGenericGun iGenericGun = this.gun;
            if (iGenericGun instanceof BoltActionGun) {
                BoltActionGun boltActionGun = (BoltActionGun)iGenericGun;
                animationDefinition = this.bulletLeft > 0 && !boltActionGun.getNeedChamber(this.itemStack) ? justChangeMag : fullReload;
                FrameAnimation.animate(root, animationDefinition, this.lastReload, 0L, 1.0f, FrameAnimation.DEFAULT_DIRECTION);
            } else {
                animationDefinition = this.bulletLeft > 0 ? justChangeMag : fullReload;
                FrameAnimation.animate(root, animationDefinition, this.lastReload, 0L, 1.0f, FrameAnimation.DEFAULT_DIRECTION);
            }
        }
    }

    public void chooseAndPlayReloadAnimationPistol(AnimationDefinition justChangeMag, AnimationDefinition fullReload, HierarchicalModel<?> root) {
        boolean showReloadAnimation;
        int armPose = Clients.armPose;
        boolean bl = showReloadAnimation = Clients.shouldHandleAnimation && this.lastReload != 0L && this.isFirstPerson;
        if (showReloadAnimation) {
            boolean hasBullet;
            boolean bl2 = hasBullet = this.bulletLeft > 0;
            if (armPose == 0) {
                AnimationDefinition animationDefinition = hasBullet ? justChangeMag : fullReload;
                FrameAnimation.animate(root, animationDefinition, this.lastReload, 0L, 1.0f, FrameAnimation.DEFAULT_DIRECTION);
            }
        }
    }

    private void renderArm(ModelPart posePart, boolean mainHand) {
        GunRenderer.INSTANCE.renderArm(mainHand, posePart, this.poseStack, this.packedLight, this.packedOverlay, this.bufferSource);
    }

    public void renderArm(ModelPart posePart, boolean mainHand, float scale) {
        GunRenderer.INSTANCE.renderArm(mainHand, posePart, this.poseStack, this.packedLight, this.packedOverlay, scale, this.bufferSource);
    }

    public void renderLeftArm(ModelPart posePart) {
        if (this.isFirstPerson) {
            this.renderArm(posePart, false);
        }
    }

    public void renderRightArm(ModelPart posePart) {
        if (this.isFirstPerson) {
            this.renderArm(posePart, true);
        }
    }

    public void renderIf(ModelPart part, VertexConsumer vertexConsumer, boolean render) {
        if (render) {
            part.render(this.poseStack, vertexConsumer, this.packedLight, this.packedOverlay, this.r, this.g, this.b, this.a);
        }
    }

    public void cancel(String slotName) {
        if (this.attachmentRenderContext != null) {
            this.attachmentRenderContext.cancel(slotName);
        }
    }

    public void render(ModelPart part, VertexConsumer vertexConsumer) {
        part.render(this.poseStack, vertexConsumer, this.packedLight, this.packedOverlay, this.r, this.g, this.b, this.a);
    }

    public void handleReloadAnimation(AnimationDefinition justChangeMag, AnimationDefinition fullReload, HierarchicalModel<?> model) {
        if (Clients.shouldHandleAnimation && this.lastReload != 0L && this.isFirstPerson) {
            AnimationDefinition animationDefinition = this.bulletLeft > 0 ? justChangeMag : fullReload;
            FrameAnimation.animate(model, animationDefinition, this.lastReload, 0L, 1.0f, FrameAnimation.DEFAULT_DIRECTION);
        }
    }

    public float getAimingAnimationScale(float trim) {
        return 1.0f - Clients.mainHandStatus.getLerpAimingProgress() * trim;
    }

    public boolean hasStock() {
        return this.attachmentRenderContext != null && this.attachmentRenderContext.hasStock();
    }

    public boolean hasSight() {
        return this.attachmentRenderContext != null && this.attachmentRenderContext.hasSight();
    }

    public boolean hasMag() {
        return this.attachmentRenderContext != null && this.attachmentRenderContext.hasMag();
    }

    public boolean hasMuzzle() {
        return this.attachmentRenderContext != null && this.attachmentRenderContext.hasMuzzle();
    }

    public boolean hasHandguard() {
        return this.attachmentRenderContext != null && this.attachmentRenderContext.hasHandguard();
    }

    public boolean has(String slotName) {
        return this.attachmentRenderContext != null && this.attachmentRenderContext.has(slotName);
    }

    public AttachmentRenderContext getAttachmentRenderContext() {
        return this.attachmentRenderContext;
    }

    public void renderAttachmentAhead(String slotName) {
        if (this.attachmentRenderContext != null) {
            this.attachmentRenderContext.renderAhead(slotName, this);
        }
    }

    public void renderAttachmentAhead(String slotName, ModelPart posePart) {
        if (this.attachmentRenderContext != null) {
            this.attachmentRenderContext.renderAhead(slotName, this, posePart);
        }
    }

    public void renderSight(ModelPart posePart) {
        if (this.attachmentRenderContext != null) {
            this.attachmentRenderContext.renderSight(this, posePart);
        }
    }

    public float getShootProgress() {
        float shootProgress = (float)(System.currentTimeMillis() - this.lastFireTime) / (float)this.fireDis;
        if (shootProgress > 1.0f) {
            shootProgress = 0.0f;
        }
        return shootProgress;
    }

    public int getReloadLength() {
        return this.gun.getReloadLength(this.itemStack);
    }

    public float getReloadProgress() {
        float reloadProgress = 0.0f;
        if (this.shouldPlayReloadAnimation()) {
            reloadProgress = Math.min((float)(System.currentTimeMillis() - this.lastReload) * 0.001f / ((float)this.getReloadLength() * 0.05f), 1.0f);
        }
        return reloadProgress;
    }

    public void renderAttachmentAheadIf(String slotName, boolean render, ModelPart posePart) {
        if (render) {
            this.renderAttachmentAhead(slotName, posePart);
        }
    }

    public void renderAttachmentAheadIf(String slotName, boolean render) {
        if (render) {
            this.renderAttachmentAhead(slotName);
        }
    }

    public void renderAllAttachmentsIgnoreSight() {
        if (this.attachmentRenderContext != null) {
            this.attachmentRenderContext.renderAllIgnoredSight(this);
        }
    }

    public void renderAllAttachments() {
        if (this.attachmentRenderContext != null) {
            this.attachmentRenderContext.renderAll(this);
        }
    }
}

