/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.ClientGlobalWeaponTranslator;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.animation.recoil.RecoilAnimationHandler;
import sheridan.gunscraft.capability.PlayerStatus;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.events.RenderEvents;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsGuiContext;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.model.IGunModelRenderer;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.model.playerOriginal.ModelPlayerArms;
import sheridan.gunscraft.render.GunRenderContext;
import sheridan.gunscraft.render.IGunRender;
import sheridan.gunscraft.render.TransformData;
import sheridan.gunscraft.render.bulletShell.BulletShellRenderer;
import sheridan.gunscraft.render.fx.muzzleFlash.CommonMuzzleFlash;
import sheridan.gunscraft.render.fx.muzzleFlash.MuzzleFlash;
import sheridan.gunscraft.render.fx.muzzleFlash.MuzzleFlashTrans;

@OnlyIn(value=Dist.CLIENT)
public class GunRenderer
implements IGunRender {
    public static final float DEFAULT_FIRST_PERSON_FOV = 60.0f;
    public static GunRenderer INSTANCE;
    private long tempLastShootMainClient;
    private long tempLastShootOffClient;
    public static float muzzleFlashScaleFP;
    int delay = 0;

    @Override
    public void justRenderModel(ItemStack itemStackIn, ItemDisplayContext transformTypeIn, PoseStack poseStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, IGenericGun gun, IGunModelRenderer model, TransformData transformData) {
        if (model != null && transformData != null) {
            poseStackIn.m_85836_();
            transformData.applyTransform(transformTypeIn, poseStackIn, false, 0.0f);
            GunRenderContext gunRenderContext = GunRenderContext.createStaticModel(poseStackIn, transformTypeIn, combinedLightIn, combinedOverlayIn, gun, itemStackIn, bufferIn);
            model.render(gunRenderContext);
            poseStackIn.m_85849_();
        }
    }

    @Override
    public void renderWithLivingEntity(LivingEntity entityIn, PoseStack stackIn, ItemStack itemStackIn, ItemDisplayContext type, MultiBufferSource bufferIn, IGenericGun gun, int combinedLightIn, int combinedOverlayIn, boolean leftHand, IGunModelRenderer model, TransformData transformData) {
        if (!Clients.INSTANCE.shouldRenderCustom(itemStackIn, gun, entityIn, !leftHand)) {
            return;
        }
        if (entityIn == null) {
            this.justRenderModel(itemStackIn, type, stackIn, bufferIn, combinedLightIn, combinedOverlayIn, gun, model, transformData);
            return;
        }
        if (model != null && transformData != null) {
            boolean isClientPlayer;
            stackIn.m_85836_();
            Clients.mainHandStatus.handleAiming(RenderEvents.delta);
            boolean isFirstPerson = type.m_269069_();
            boolean transAiming = entityIn instanceof Player && !leftHand && (Clients.mainHandStatus.aiming.get() || Clients.mainHandStatus.aimingProgress != 0.0f) && isFirstPerson;
            float aimingProgress = Clients.mainHandStatus.getLerpAimingProgress();
            boolean renderInFirstPerson = isFirstPerson;
            boolean bl = isClientPlayer = entityIn.m_19879_() == Clients.clientPlayerId;
            if (!Clients.strictDisplayType.get()) {
                boolean inFirstPersonGunView = Clients.isInFirstPersonGunView;
                renderInFirstPerson = isClientPlayer && inFirstPersonGunView || isFirstPerson;
            }
            PoseStack poseStack = new PoseStack();
            if (((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue()) {
                ClientGlobalWeaponTranslator.INSTANCE.handleTransform(poseStack, gun, !leftHand);
            } else if (!leftHand) {
                poseStack.m_252880_(0.56f, -0.52f, -0.71f);
            } else {
                poseStack.m_252880_(-0.56f, -0.52f, -0.71f);
            }
            if (isFirstPerson) {
                transformData.applyTransform(type, poseStack, transAiming, aimingProgress);
            } else {
                transformData.applyTransform(type, stackIn, false, aimingProgress);
            }
            if (isFirstPerson) {
                long lastShootTime = leftHand ? Clients.offHandStatus.lastShoot : Clients.mainHandStatus.lastShoot;
                long lastChamberTime = Clients.mainHandStatus.lastChamber;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                boolean shot = this.shot(lastShootTime, !leftHand);
                try {
                    TransformData.BulletShellAniData bulletShellAniData;
                    RenderEvents.checkStencilSetUp();
                    if (transformData.recoilAniData != null) {
                        RecoilAnimationHandler.INSTANCE.handleTransform(poseStack, transformData.recoilAniData.id, Clients.mainHandStatus.aiming.get(), !leftHand);
                    }
                    if (gun.shootCreateBulletShell() && shot && (bulletShellAniData = transformData.bulletShellAniData) != null && player != null && player.m_19879_() == Clients.clientPlayerId) {
                        BulletShellRenderer.push(bulletShellAniData.xSpeed, bulletShellAniData.ySpeed, bulletShellAniData.zSpeed, bulletShellAniData.rSpeed, bulletShellAniData.drop, bulletShellAniData.random, bulletShellAniData.length, gun.getBulletType(), !leftHand);
                    }
                    poseStack.m_85836_();
                    transformData.applyBulletShellTrans(poseStack);
                    BulletShellRenderer.play(combinedLightIn, combinedOverlayIn, poseStack, !leftHand, bufferIn);
                    poseStack.m_85849_();
                    poseStack.m_85836_();
                    GunRenderContext gunRenderContext = GunRenderContext.createFirstPersonView(poseStack, type, combinedLightIn, combinedOverlayIn, lastShootTime, lastChamberTime, !leftHand, gun, itemStackIn, transformData, bufferIn);
                    model.render(gunRenderContext);
                    poseStack.m_85849_();
                }
                catch (Exception gunRenderContext) {}
            } else if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                long lastShoot = 0L;
                long lastChamber = 0L;
                boolean clientSide = false;
                PlayerStatus status = PlayerStatusProvider.getStatus(player);
                if (isClientPlayer) {
                    lastShoot = leftHand ? Clients.offHandStatus.lastShoot : Clients.mainHandStatus.lastShoot;
                    lastChamber = Clients.mainHandStatus.lastChamber;
                    if (!renderInFirstPerson && (RecoilAnimationHandler.INSTANCE.isEnable(true) || RecoilAnimationHandler.INSTANCE.isEnable(false))) {
                        RecoilAnimationHandler.INSTANCE.clearAll(true);
                    }
                    clientSide = true;
                } else if (status != PlayerStatus.EMPTY) {
                    lastShoot = leftHand ? status.lastShootLeft : status.lastShootRight;
                    lastChamber = status.lastChamber + 20L;
                }
                stackIn.m_85836_();
                GunRenderContext gunRenderContext = GunRenderContext.createThirdPersonView(stackIn, type, combinedLightIn, combinedOverlayIn, gun, itemStackIn, lastShoot += 10L, lastChamber, !leftHand, bufferIn);
                model.render(gunRenderContext);
                stackIn.m_85849_();
                model.handleRootTranslate(stackIn);
                GunRenderer.renderMuzzleFlash(gun, itemStackIn, transformData, lastShoot, bufferIn, stackIn, false);
                if (clientSide && !renderInFirstPerson) {
                    BulletShellRenderer.clear();
                }
            }
            stackIn.m_85849_();
        }
    }

    private boolean shot(long lastShoot, boolean mainHand) {
        boolean shot = false;
        if (lastShoot != 0L) {
            if (mainHand) {
                shot = this.tempLastShootMainClient != lastShoot;
            } else {
                boolean bl = shot = this.tempLastShootOffClient != lastShoot;
            }
            if (mainHand) {
                this.tempLastShootMainClient = lastShoot;
            } else {
                this.tempLastShootOffClient = lastShoot;
            }
        }
        return shot;
    }

    @Override
    public void renderInGuiScreen(ItemStack itemStack, GuiGraphics guiGraphics, IGenericGun gun, IGunModelRenderer model, AttachmentsGuiContext attachmentsGuiContext) {
        PoseStack poseStack = guiGraphics.m_280168_();
        TransformData transformData = Clients.transformDataMap.get(itemStack.m_41720_());
        transformData.applyTransform(ItemDisplayContext.GROUND, poseStack, false, 0.0f);
        GunRenderContext gunRenderContext = GunRenderContext.createStaticModel(poseStack, ItemDisplayContext.GROUND, 0xF000F0, 655360, gun, itemStack, (MultiBufferSource)guiGraphics.m_280091_());
        poseStack.m_85836_();
        model.render(gunRenderContext);
        poseStack.m_85849_();
        guiGraphics.m_280091_().m_109911_();
        if (attachmentsGuiContext != null) {
            attachmentsGuiContext.renderIcons(guiGraphics);
        }
    }

    public static void renderMuzzleFlash(IGenericGun gun, ItemStack itemStack, TransformData transformData, long startTime, MultiBufferSource buffer, PoseStack stack, boolean firstPerson) {
        String state = gun.getMuzzleFlashState(itemStack);
        if (state != null) {
            MuzzleFlash flash;
            String flashName = transformData.getMuzzleFlashName(state);
            MuzzleFlashTrans trans = transformData.getMuzzleFlashTrans(state);
            if (flashName != null && trans != null && (flash = CommonMuzzleFlash.flashMap.get(flashName)) != null) {
                stack.m_85836_();
                float scale = firstPerson ? muzzleFlashScaleFP : 1.0f;
                flash.play(startTime, buffer, stack, trans, firstPerson, scale);
                stack.m_85849_();
            }
        }
    }

    public void renderArm(boolean mainHand, ModelPart posePart, PoseStack poseStack, int light, int overlay, float scale, MultiBufferSource bufferSource) {
        LocalPlayer abstractClientPlayer = Minecraft.m_91087_().f_91074_;
        if (abstractClientPlayer != null) {
            Object name;
            boolean isPlayerModelSlim = "slim".equals(abstractClientPlayer.m_108564_());
            ResourceLocation playerTexture = abstractClientPlayer.m_108560_();
            Object object = name = mainHand ? "right_arm" : "left_arm";
            if (isPlayerModelSlim) {
                name = (String)name + "_slim";
            }
            ModelPlayerArms.INSTANCE.render((String)name, posePart, poseStack, playerTexture, light, overlay, scale, bufferSource);
        }
    }

    public void renderArm(boolean mainHand, ModelPart posePart, PoseStack poseStack, int light, int overlay, MultiBufferSource bufferSource) {
        this.renderArm(mainHand, posePart, poseStack, light, overlay, 1.0f, bufferSource);
    }

    static {
        muzzleFlashScaleFP = 1.0f;
        INSTANCE = new GunRenderer();
    }
}

