/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.animation.recoil.RecoilAnimationHandler;
import sheridan.gunscraft.render.fx.muzzleFlash.MuzzleFlashTrans;
import sheridan.gunscraft.render.utils.Quaternions;

@OnlyIn(value=Dist.CLIENT)
public class TransformData {
    public static final float BASE_SIZE = 0.09f;
    public static final float BASE_ARM_SIZE = 6.0f;
    public float[][][] FPTrans;
    public float[][][] TPTrans;
    public float[][] GUITrans;
    public float[][] FrameTrans;
    public float[][] GroundTrans;
    public float[][][] FPHandPoseTrans;
    public float[] aimingTrans;
    public float[] bulletShellTrans;
    public MuzzleFlashFransEntry muzzleFlashTransEntry = new MuzzleFlashFransEntry();
    public BulletShellAniData bulletShellAniData;
    public RecoilAnimationHandler.RecoilAnimationData recoilAniData;

    public TransformData setRecoilAniData(RecoilAnimationHandler.RecoilAnimationData recoilAniData) {
        this.recoilAniData = recoilAniData;
        return this;
    }

    public TransformData setBulletShellAniData(BulletShellAniData bulletShellAniData) {
        this.bulletShellAniData = bulletShellAniData;
        return this;
    }

    public TransformData setBulletShellTrans(float[] bulletShellTrans) {
        this.bulletShellTrans = bulletShellTrans;
        return this;
    }

    public TransformData registerMuzzleFlash(String name, TransPair pair) {
        this.muzzleFlashTransEntry.register(name, pair);
        return this;
    }

    public TransformData setAimingTrans(float[] trans) {
        this.aimingTrans = trans;
        return this;
    }

    public MuzzleFlashTrans getMuzzleFlashTrans(String name) {
        return this.muzzleFlashTransEntry.getTrans(name);
    }

    public String getMuzzleFlashName(String name) {
        return this.muzzleFlashTransEntry.getName(name);
    }

    public TransformData() {
        this.FPTrans = new float[][][]{new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.09f, 0.09f, 0.09f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.09f, 0.09f, 0.09f}}};
        this.TPTrans = new float[][][]{new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.09f, 0.09f, 0.09f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.09f, 0.09f, 0.09f}}};
        this.GUITrans = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.09f, 0.09f, 0.09f}};
        this.FrameTrans = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.09f, 0.09f, 0.09f}};
        this.GroundTrans = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.09f, 0.09f, 0.09f}};
        this.FPHandPoseTrans = new float[][][]{new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {6.0f, 6.0f, 6.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {6.0f, 6.0f, 6.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {6.0f, 6.0f, 6.0f}}};
    }

    public TransformData setFPRightHand(float[][] trans) {
        this.FPTrans[0] = trans;
        return this;
    }

    public TransformData setFPLeftHand(float[][] trans) {
        this.FPTrans[1] = trans;
        return this;
    }

    public TransformData setTPRightHand(float[][] trans) {
        this.TPTrans[0] = trans;
        return this;
    }

    public TransformData setTPLeftHand(float[][] trans) {
        this.TPTrans[1] = trans;
        return this;
    }

    public TransformData setGUITrans(float[][] trans) {
        this.GUITrans = trans;
        return this;
    }

    public TransformData setFrameTrans(float[][] trans) {
        this.FrameTrans = trans;
        return this;
    }

    public TransformData setGroundTrans(float[][] trans) {
        this.GroundTrans = trans;
        return this;
    }

    public void applyBulletShellTrans(PoseStack poseStack) {
        if (this.bulletShellTrans != null) {
            poseStack.m_252880_(this.bulletShellTrans[0], this.bulletShellTrans[1], this.bulletShellTrans[2]);
            poseStack.m_252781_(Quaternions.rotateDeg(this.bulletShellTrans[3], this.bulletShellTrans[4], this.bulletShellTrans[5]));
            poseStack.m_85841_(this.bulletShellTrans[6], this.bulletShellTrans[7], this.bulletShellTrans[8]);
        }
    }

    private float lerp(float x) {
        return -2.0f * (x - 0.5f) * (x - 0.5f) + 0.5f;
    }

    public void applyTransform(ItemDisplayContext type, PoseStack stackIn, boolean transAiming, float aimingProgress) {
        stackIn.m_85841_(0.09f, 0.09f, 0.09f);
        stackIn.m_252781_(Quaternions.rotateDeg(0.0f, 0.0f, 180.0f));
        switch (type) {
            case FIRST_PERSON_RIGHT_HAND: {
                if (transAiming) {
                    aimingProgress = Math.min(1.0f, aimingProgress);
                    float[] aimingTrans = Clients.mainHandStatus.aimingTrans != null ? Clients.mainHandStatus.aimingTrans : this.aimingTrans;
                    stackIn.m_252880_(Mth.m_14179_((float)aimingProgress, (float)this.FPTrans[0][0][0], (float)aimingTrans[0]), Mth.m_14179_((float)aimingProgress, (float)this.FPTrans[0][0][1], (float)aimingTrans[1]), Mth.m_14179_((float)aimingProgress, (float)this.FPTrans[0][0][2], (float)aimingTrans[2]));
                    float lerp = this.lerp(aimingProgress);
                    stackIn.m_252781_(Quaternions.rotateDeg(this.FPTrans[0][1][0], this.FPTrans[0][1][1], this.FPTrans[0][1][2] + lerp * 15.0f));
                } else {
                    stackIn.m_252880_(this.FPTrans[0][0][0], this.FPTrans[0][0][1], this.FPTrans[0][0][2] + 0.48f);
                    stackIn.m_252781_(Quaternions.rotateDeg(this.FPTrans[0][1][0], this.FPTrans[0][1][1], this.FPTrans[0][1][2]));
                }
                stackIn.m_85841_(this.FPTrans[0][2][0], this.FPTrans[0][2][1], this.FPTrans[0][2][2]);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                stackIn.m_252880_(this.FPTrans[1][0][0], this.FPTrans[1][0][1], this.FPTrans[1][0][2]);
                stackIn.m_252781_(Quaternions.rotateDeg(this.FPTrans[1][1][0], this.FPTrans[1][1][1], this.FPTrans[1][1][2]));
                stackIn.m_85841_(this.FPTrans[1][2][0], this.FPTrans[1][2][1], this.FPTrans[1][2][2]);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                stackIn.m_252880_(this.TPTrans[0][0][0], this.TPTrans[0][0][1], this.TPTrans[0][0][2]);
                stackIn.m_252781_(Quaternions.rotateDeg(this.TPTrans[0][1][0], this.TPTrans[0][1][1], this.TPTrans[0][1][2]));
                stackIn.m_85841_(this.TPTrans[0][2][0], this.TPTrans[0][2][1], this.TPTrans[0][2][2]);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                stackIn.m_252880_(this.TPTrans[1][0][0], this.TPTrans[1][0][1], this.TPTrans[1][0][2]);
                stackIn.m_252781_(Quaternions.rotateDeg(this.TPTrans[1][1][0], this.TPTrans[1][1][1], this.TPTrans[1][1][2]));
                stackIn.m_85841_(this.TPTrans[1][2][0], this.TPTrans[1][2][1], this.TPTrans[1][2][2]);
                break;
            }
            case GUI: {
                stackIn.m_252880_(this.GUITrans[0][0], this.GUITrans[0][1], this.GUITrans[0][2]);
                stackIn.m_252781_(Quaternions.rotateDeg(this.GUITrans[1][0], this.GUITrans[1][1], this.GUITrans[1][2]));
                stackIn.m_85841_(this.GUITrans[2][0], this.GUITrans[2][1], this.GUITrans[2][2]);
                break;
            }
            case GROUND: {
                stackIn.m_252880_(this.GroundTrans[0][0], this.GroundTrans[0][1], this.GroundTrans[0][2]);
                stackIn.m_252781_(Quaternions.rotateDeg(this.GroundTrans[1][0], this.GroundTrans[1][1], this.GroundTrans[1][2]));
                stackIn.m_85841_(this.GroundTrans[2][0], this.GroundTrans[2][1], this.GroundTrans[2][2]);
                break;
            }
            case FIXED: {
                stackIn.m_252880_(this.FrameTrans[0][0], this.FrameTrans[0][1], this.FrameTrans[0][2]);
                stackIn.m_252781_(Quaternions.rotateDeg(this.FrameTrans[1][0], this.FrameTrans[1][1], this.FrameTrans[1][2]));
                stackIn.m_85841_(this.FrameTrans[2][0], this.FrameTrans[2][1], this.FrameTrans[2][2]);
            }
        }
    }

    public static class BulletShellAniData {
        public float xSpeed;
        public float ySpeed;
        public float zSpeed;
        public int rSpeed;
        public float random;
        public float drop;
        public float length;

        public BulletShellAniData(float xSpeed, float ySpeed, float zSpeed, int rSpeed, float random, float drop, float length) {
            this.xSpeed = xSpeed;
            this.ySpeed = ySpeed;
            this.zSpeed = zSpeed;
            this.rSpeed = rSpeed;
            this.random = random;
            this.length = length;
            this.drop = drop;
        }
    }

    public static class MuzzleFlashFransEntry {
        private Map<String, TransPair> transMap = new HashMap<String, TransPair>();

        public MuzzleFlashFransEntry register(String key, TransPair trans) {
            if (!this.transMap.containsKey(key)) {
                this.transMap.put(key, trans);
            }
            return this;
        }

        public MuzzleFlashTrans getTrans(String key) {
            if (!this.transMap.containsKey(key)) {
                return null;
            }
            return this.transMap.get((Object)key).trans;
        }

        public String getName(String key) {
            if (!this.transMap.containsKey(key)) {
                return null;
            }
            return this.transMap.get((Object)key).name;
        }
    }

    public static class TransPair {
        public MuzzleFlashTrans trans;
        public String name;

        public TransPair setTrans(MuzzleFlashTrans trans) {
            this.trans = trans;
            return this;
        }

        public TransPair setName(String name) {
            this.name = name;
            return this;
        }
    }
}

