/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.render.bulletShell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.animation.IAnimation;
import sheridan.gunscraft.animation.curve.Curve;
import sheridan.gunscraft.animation.curve.CurveAnimation;
import sheridan.gunscraft.render.bulletShell.ModelBulletShell;

@OnlyIn(value=Dist.CLIENT)
public class BulletShellRenderer {
    private static final ModelBulletShell<?> MODEL_BASIC = new ModelBulletShell(ModelBulletShell.createBodyLayer().m_171564_());
    public static final int MAX_BULLET_MUN = 5;
    private static Deque<AnimationContext> animations = new LinkedList<AnimationContext>();

    public static void push(final float xSpeed, final float ySpeed, final float zSpeed, final int rSpeed, final float drop, float random, float length, String modelType, boolean mainHand) {
        final float seed = (float)((double)random * Math.random());
        CurveAnimation animation = new CurveAnimation(new Curve[]{new Curve(){

            @Override
            public float getVal(float xVal) {
                return -xVal * xSpeed * (1.0f + seed);
            }
        }.setBound(0.0f, 1.0f), new Curve(){

            @Override
            public float getVal(float xVal) {
                return (drop * xVal * xVal - xVal) * ySpeed;
            }
        }.setBound(0.0f, 1.0f), new Curve(){

            @Override
            public float getVal(float xVal) {
                return xVal * zSpeed;
            }
        }, new Curve(){

            @Override
            public float getVal(float xVal) {
                return seed * 2.5f;
            }
        }, new Curve(){

            @Override
            public float getVal(float xVal) {
                return xVal * 360.0f * (float)rSpeed;
            }
        }.setBound(0.0f, 1.0f)}, length);
        AnimationContext context = new AnimationContext(System.currentTimeMillis(), animation, mainHand, modelType);
        if (animations.size() + 1 > 5) {
            animations.pollLast();
        }
        animations.offerFirst(context);
    }

    public static void play(int light, int overlay, PoseStack poseStack, boolean mainHand, MultiBufferSource bufferSource) {
        if (!animations.isEmpty()) {
            VertexConsumer builder = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)ModelBulletShell.TEXTURE));
            animations.removeIf(context -> context.handle(light, overlay, builder, poseStack, mainHand));
        }
    }

    public static void clear() {
        animations.clear();
    }

    private static class AnimationContext {
        public long startTime;
        IAnimation animation;
        boolean mainHand;
        public String modelType;

        public AnimationContext(long startTime, IAnimation animation, boolean mainHand, String modelType) {
            this.startTime = startTime;
            this.animation = animation;
            this.mainHand = mainHand;
            this.modelType = modelType;
        }

        public boolean handle(int light, int overlay, VertexConsumer builder, PoseStack poseStack, boolean mainHand) {
            if (mainHand == this.mainHand) {
                poseStack.m_85836_();
                this.animation.play(this.startTime, poseStack, mainHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
                MODEL_BASIC.chooseToRender(poseStack, light, overlay, this.modelType, builder);
                poseStack.m_85849_();
            }
            return this.animation.isCompleted();
        }
    }
}

