/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.render.crosshair;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BasicCrossHairRenderer {
    public static final ResourceLocation BLANK = new ResourceLocation("gunscraft", "textures/gui/crosshair/blank.png");
    public static final int WHITE = 0;
    public static final int GREEN = 1;
    public static final int RED = 2;
    private static final float SPREAD_FACTOR = 5.75f;
    private static final float CROSS_STICK_LEN = 5.0f;
    private float[][] rgbs = new float[][]{{1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};

    public void render(PoseStack poseStackIn, float spread, Window window, int color) {
        poseStackIn.m_85836_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        poseStackIn.m_85837_((double)(0.5f * (float)window.m_85445_()), (double)(0.5f * (float)window.m_85446_()), 0.0);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f matrix = poseStackIn.m_85850_().m_252922_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BLANK);
        this.renderCross(matrix, color, spread);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStackIn.m_85849_();
    }

    private void renderCross(Matrix4f matrix, int color, float spread) {
        this.renderColorRect(matrix, color, -0.5f, 0.0f, 0.5f, 1.0f);
        this.renderColorRect(matrix, color, -0.5f, 1.0f + spread * 5.75f, 0.5f, 1.0f + spread * 5.75f + 5.0f);
        this.renderColorRect(matrix, color, -0.5f, -spread * 5.75f - 5.0f, 0.5f, -spread * 5.75f);
        this.renderColorRect(matrix, color, 0.5f + spread * 5.75f, 0.0f, 0.5f + spread * 5.75f + 5.0f, 1.0f);
        this.renderColorRect(matrix, color, -0.5f - spread * 5.75f - 5.0f, 0.0f, -0.5f - spread * 5.75f, 1.0f);
    }

    private void renderColorRect(Matrix4f matrix, int color, float xStart, float yStart, float xEnd, float yEnd) {
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, xStart, yEnd, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(this.rgbs[color][0], this.rgbs[color][1], this.rgbs[color][2], 1.0f).m_5752_();
        buffer.m_252986_(matrix, xEnd, yEnd, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(this.rgbs[color][0], this.rgbs[color][1], this.rgbs[color][2], 1.0f).m_5752_();
        buffer.m_252986_(matrix, xEnd, yStart, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(this.rgbs[color][0], this.rgbs[color][1], this.rgbs[color][2], 1.0f).m_5752_();
        buffer.m_252986_(matrix, xStart, yStart, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(this.rgbs[color][0], this.rgbs[color][1], this.rgbs[color][2], 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }
}

