/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.render.fx.muzzleFlash;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.render.fx.muzzleFlash.MuzzleFlashTexture;
import sheridan.gunscraft.render.fx.muzzleFlash.MuzzleFlashTrans;
import sheridan.gunscraft.render.utils.Quaternions;

@OnlyIn(value=Dist.CLIENT)
public class MuzzleFlash {
    private final List<MuzzleFlashTexture> textures = new ArrayList<MuzzleFlashTexture>();
    public long length;
    public float size;
    public boolean randomRotate;
    public int randomSeed;
    private static final Random RANDOM = new Random();

    public MuzzleFlash setSize(float size) {
        this.size = size;
        return this;
    }

    public MuzzleFlash setLength(long length) {
        this.length = length;
        return this;
    }

    public MuzzleFlash setRandomSeed(int seed) {
        this.randomSeed = seed;
        this.randomRotate = true;
        return this;
    }

    public List<MuzzleFlashTexture> getTextures() {
        return this.textures;
    }

    public MuzzleFlash addTexture(MuzzleFlashTexture texture) {
        this.textures.add(texture);
        return this;
    }

    public void play(long startTime, MultiBufferSource buffer, PoseStack stack, MuzzleFlashTrans trans, boolean firstPerson, float scale) {
        if (!this.textures.isEmpty()) {
            int texNum = this.textures.size();
            int texIndex = texNum > 1 ? Math.max(RANDOM.nextInt(), 0) % texNum : 0;
            MuzzleFlashTexture muzzleFlashTexture = this.textures.get(texIndex);
            long dis = System.currentTimeMillis() - startTime;
            float progress = (float)dis / (float)this.length;
            if (progress <= 1.0f) {
                if (trans != null) {
                    trans.applyTrans(stack, scale);
                }
                if (this.randomRotate) {
                    int seed = Math.max(0, RANDOM.nextInt()) % this.randomSeed;
                    stack.m_252781_(Quaternions.rotateDeg(0.0f, 0.0f, (float)seed * (360.0f / (float)this.randomSeed)));
                }
                muzzleFlashTexture.draw(progress, this.size, buffer, stack, firstPerson);
            }
        }
    }
}

