/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.render.fx.muzzleFlash;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import sheridan.gunscraft.render.fx.RenderTypes;
import sheridan.gunscraft.render.utils.Quaternions;

@OnlyIn(value=Dist.CLIENT)
public class MuzzleFlashTexture {
    public ResourceLocation texture;
    public int frameCount;
    private final float quadSize;
    private static final float BASE_ALPHA = 0.65f;

    public MuzzleFlashTexture(ResourceLocation texture, int frameCount) {
        this.texture = texture;
        this.frameCount = frameCount;
        this.quadSize = 1.0f / (float)frameCount;
    }

    public void draw(float progress, float size, MultiBufferSource buffer, PoseStack poseStack, boolean firstPerson) {
        int index = (int)(progress * (float)this.frameCount);
        RenderSystem.enableBlend();
        VertexConsumer builder = buffer.m_6299_(RenderTypes.getMuzzleFlash(this.texture));
        if (!firstPerson) {
            this.draw(poseStack, 0, 0.0f, 0.0f, 0.0f, size, builder, index);
        }
        this.draw(poseStack, 2, 90.0f, 0.0f, -0.5f * size, size, builder, index);
        this.draw(poseStack, 1, 90.0f, -90.0f, -0.5f * size, size, builder, index);
        if (firstPerson) {
            this.draw(poseStack, 0, 0.0f, 0.0f, 0.0f, size, builder, index);
        }
        RenderSystem.disableBlend();
    }

    private void draw(PoseStack poseStack, int axis, float rx, float ry, float tz, float size, VertexConsumer vertexConsumer, int index) {
        poseStack.m_85836_();
        if (tz != 0.0f) {
            poseStack.m_252880_(0.0f, 0.0f, tz);
        }
        if (rx != 0.0f || ry != 0.0f) {
            poseStack.m_252781_(Quaternions.rotateDeg(rx, ry, 0.0f));
        }
        this.drawQuad(axis, index, size, poseStack, vertexConsumer);
        poseStack.m_85849_();
    }

    private void drawQuad(int axis, int index, float size, PoseStack stack, VertexConsumer builder) {
        float[] uv = this.getUV(index, axis);
        if (uv != null) {
            this.drawQuad(builder, stack.m_85850_().m_252922_(), uv[0], uv[1], uv[2], uv[3], size);
        }
    }

    private float[] getUV(int index, int axis) {
        float[] fArray;
        switch (axis) {
            case 0: {
                float[] fArray2 = new float[4];
                fArray2[0] = this.quadSize * (float)index;
                fArray2[1] = 0.0f;
                fArray2[2] = this.quadSize * (float)(index + 1);
                fArray = fArray2;
                fArray2[3] = this.quadSize;
                break;
            }
            case 1: {
                float[] fArray3 = new float[4];
                fArray3[0] = this.quadSize * (float)index;
                fArray3[1] = this.quadSize;
                fArray3[2] = this.quadSize * (float)(index + 1);
                fArray = fArray3;
                fArray3[3] = this.quadSize * 2.0f;
                break;
            }
            case 2: {
                float[] fArray4 = new float[4];
                fArray4[0] = this.quadSize * (float)index;
                fArray4[1] = this.quadSize * 2.0f;
                fArray4[2] = this.quadSize * (float)(index + 1);
                fArray = fArray4;
                fArray4[3] = this.quadSize * 3.0f;
                break;
            }
            default: {
                fArray = null;
            }
        }
        return fArray;
    }

    private void drawQuad(VertexConsumer builder, Matrix4f matrix, float u1, float v1, float u2, float v2, float size) {
        builder.m_252986_(matrix, -0.5f * size, 0.5f * size, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_7421_(u2, v2).m_85969_(157288880).m_86008_(655360).m_5752_();
        builder.m_252986_(matrix, 0.5f * size, 0.5f * size, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_7421_(u1, v2).m_85969_(157288880).m_86008_(655360).m_5752_();
        builder.m_252986_(matrix, 0.5f * size, -0.5f * size, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_7421_(u1, v1).m_85969_(157288880).m_86008_(655360).m_5752_();
        builder.m_252986_(matrix, -0.5f * size, -0.5f * size, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_7421_(u2, v1).m_85969_(157288880).m_86008_(655360).m_5752_();
    }
}

