/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.container.NewAttachmentMenu;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsGuiContext;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.attachments.util.newSys.GuiSlot;
import sheridan.gunscraft.items.attachments.util.newSys.Result;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.NewSetAttachmentPacket;
import sheridan.gunscraft.render.GunRenderer;
import sheridan.gunscraft.render.utils.Quaternions;
import sheridan.gunscraft.screen.utils.EasyButton;

@OnlyIn(value=Dist.CLIENT)
public class NewAttachmentScreen
extends AbstractContainerScreen<NewAttachmentMenu> {
    private final NewAttachmentMenu menu;
    private AttachmentsGuiContext attachmentsGuiContext;
    private Slot selectedItemSlot;
    private float modelRX = 10.0f;
    private float modelRY = 10.0f;
    private float tempModelRX = 10.0f;
    private float tempModelRY = 10.0f;
    private float dragX = 0.0f;
    private float dragY = 0.0f;
    private float dragStartX;
    private float scaleZoom = 0.0f;
    private final float zoomMax = 200.0f;
    private final float zoomMin = -200.0f;
    private float dragStartY;
    private float tempDragX;
    private float tempDragY;
    public static final ResourceLocation BACK_GROUND = new ResourceLocation("gunscraft", "textures/gui/screen/attachment_screen_new.png");
    public static final ResourceLocation RESET_BTN = new ResourceLocation("gunscraft", "textures/gui/screen/reset_btn.png");
    public static final ResourceLocation DRAG_BTN = new ResourceLocation("gunscraft", "textures/gui/screen/drag_btn.png");
    private static final ResourceLocation INSTALL_ATTACHMENT = new ResourceLocation("gunscraft", "textures/gui/screen/install_attachment_btn.png");
    private static final ResourceLocation UNINSTALL_ATTACHMENT = new ResourceLocation("gunscraft", "textures/gui/screen/uninstall_attachment_btn.png");
    private static final ResourceLocation SUITABLE_SLOT_MARK = new ResourceLocation("gunscraft", "textures/gui/screen/suitable_slot_mark.png");
    private static final ResourceLocation SELECTED_SLOT = new ResourceLocation("gunscraft", "textures/gui/screen/selected_slot.png");
    private final EasyButton resetBtn;
    private final EasyButton dragBtn;
    private final EasyButton installSlotBtn;
    private final EasyButton uninstallSlotBtn;
    private final List<EasyButton> buttons = new ArrayList<EasyButton>();
    private boolean firstTick = true;
    private boolean mouseRollingModel = false;
    private final List<Slot> suitableSlots = new LinkedList<Slot>();
    float delta = 0.0f;
    float cyclingDelta = 0.0f;
    long lastRender = 0L;
    private String tempSelectedSlotName = null;

    public NewAttachmentScreen(NewAttachmentMenu newAttachmentMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)newAttachmentMenu, inventory, component);
        this.menu = newAttachmentMenu;
        this.f_96543_ = 328;
        this.f_96544_ = 220;
        this.f_97726_ = 328;
        this.f_97727_ = 220;
        this.resetBtn = (EasyButton)this.m_7787_((GuiEventListener)EasyButton.button(RESET_BTN, 16, 16, "tooltip.gunscraft.reset", b -> {
            this.dragStartY = 0.0f;
            this.dragStartX = 0.0f;
            this.modelRY = 10.0f;
            this.modelRX = 10.0f;
            this.scaleZoom = 0.0f;
            this.tempModelRX = 10.0f;
            this.tempModelRY = 10.0f;
            this.tempDragY = 0.0f;
            this.tempDragX = 0.0f;
            this.dragY = 0.0f;
            this.dragX = 0.0f;
        }));
        this.dragBtn = (EasyButton)this.m_7787_((GuiEventListener)EasyButton.button(DRAG_BTN, 16, 16, "tooltip.gunscraft.drag", b -> {}).setOnDrag((mouseX, mouseY, button, dragX, dragY) -> {
            this.dragX = this.tempDragX + (float)(mouseX - (double)this.dragStartX) * 0.5f;
            this.dragY = this.tempDragY + (float)(mouseY - (double)this.dragStartY) * 0.5f;
        }).setOnDragStart((mouseX, mouseY, button) -> {
            this.dragStartX = (float)mouseX;
            this.dragStartY = (float)mouseY;
        }).setOnDragEnd((mouseX, mouseY) -> {
            this.tempDragX = this.dragX;
            this.tempDragY = this.dragY;
        }));
        this.dragBtn.mode = EasyButton.Mode.DRAG;
        this.installSlotBtn = (EasyButton)this.m_7787_((GuiEventListener)EasyButton.button(INSTALL_ATTACHMENT, 16, 16, "tooltip.gunscraft.set_attachment", b -> this.installAttachment()));
        this.uninstallSlotBtn = (EasyButton)this.m_7787_((GuiEventListener)EasyButton.button(UNINSTALL_ATTACHMENT, 16, 16, "tooltip.gunscraft.unload_attachment", b -> this.uninstallAttachment()));
        this.buttons.addAll(List.of(this.resetBtn, this.dragBtn, this.installSlotBtn, this.uninstallSlotBtn));
    }

    public void updateAttachmentGuiContext(CompoundTag tag) {
        this.attachmentsGuiContext = AttachmentsHandler.INSTANCE.getGuiContext(tag);
        if (this.tempSelectedSlotName != null) {
            this.attachmentsGuiContext.selectBySlotName(this.tempSelectedSlotName);
        }
    }

    private void updateAttachmentGuiContext() {
        LocalPlayer player;
        if (this.f_96541_ != null && (player = this.f_96541_.f_91074_) != null) {
            this.updateAttachmentGuiContext(AttachmentsHandler.INSTANCE.checkAndGet(player.m_21205_()));
        }
    }

    private void updateBtnPos() {
        this.resetBtn.setPos(this.f_97735_ + 305, this.f_97736_ + 15);
        this.dragBtn.setPos(this.f_97735_ + 305, this.f_97736_ + 40);
        if (this.installSlotBtn.willRender() && this.uninstallSlotBtn.willRender()) {
            this.installSlotBtn.m_264152_(this.f_97735_ + this.getXSize() / 2 - 20, this.f_97736_ + 107);
            this.uninstallSlotBtn.m_264152_(this.f_97735_ + this.getXSize() / 2 + 4, this.f_97736_ + 107);
        } else {
            this.installSlotBtn.m_264152_(this.f_97735_ + this.getXSize() / 2 - 8, this.f_97736_ + 107);
            this.uninstallSlotBtn.m_264152_(this.f_97735_ + this.getXSize() / 2 - 8, this.f_97736_ + 107);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        this.updateBtnPos();
        if (this.attachmentsGuiContext == null) {
            this.updateAttachmentGuiContext();
            try {
                this.updateSuitableSlots(this.attachmentsGuiContext.selectGuiSlot);
                this.updateSuitableContainer(this.attachmentsGuiContext.selectGuiSlot);
            }
            catch (Exception exception) {}
        } else if (this.attachmentsGuiContext.selectGuiSlot != null) {
            this.updateBtnStatus();
        }
        this.firstTick = false;
    }

    private void updateBtnStatus() {
        if (this.canOperateData()) {
            LocalPlayer player = this.f_96541_.f_91074_;
            Result result = this.attachmentsGuiContext.selectGuiSlot.slotTag.canUnInstall((Player)player, player.m_21205_());
            if (result.success) {
                this.uninstallSlotBtn.f_93623_ = true;
                this.uninstallSlotBtn.prevented = false;
                this.uninstallSlotBtn.setTooltip("tooltip.gunscraft.unload_attachment");
            } else {
                if (!"".equals(result.descId)) {
                    this.uninstallSlotBtn.prevented = true;
                    this.uninstallSlotBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)result.descId)));
                } else {
                    this.uninstallSlotBtn.prevented = false;
                    this.uninstallSlotBtn.setTooltip("tooltip.gunscraft.unload_attachment");
                }
                this.uninstallSlotBtn.f_93623_ = false;
            }
            if (this.selectedItemSlot != null) {
                ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)this.selectedItemSlot.m_7993_().m_41720_());
                if (id != null) {
                    Result installResult = this.attachmentsGuiContext.selectGuiSlot.slotTag.canInstall((Player)player, player.m_21205_(), id.toString());
                    if (installResult.success) {
                        this.installSlotBtn.f_93623_ = true;
                        this.installSlotBtn.prevented = false;
                        this.installSlotBtn.setTooltip("tooltip.gunscraft.set_attachment");
                    } else {
                        if ("".equals(installResult.descId)) {
                            this.installSlotBtn.prevented = false;
                        } else {
                            this.installSlotBtn.prevented = true;
                            this.installSlotBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)installResult.descId)));
                        }
                        this.installSlotBtn.f_93623_ = false;
                    }
                } else {
                    this.installSlotBtn.f_93623_ = false;
                    this.installSlotBtn.prevented = false;
                }
            } else {
                this.installSlotBtn.f_93623_ = false;
                this.installSlotBtn.prevented = false;
            }
        } else {
            this.installSlotBtn.f_93623_ = false;
            this.installSlotBtn.prevented = false;
            this.uninstallSlotBtn.f_93623_ = false;
            this.uninstallSlotBtn.prevented = false;
        }
    }

    private void updateSuitableSlots(GuiSlot slot) {
        if (slot == null) {
            return;
        }
        this.suitableSlots.clear();
        SlotTag slotTag = slot.slotTag;
        if (slotTag != null) {
            Set<String> ids = slotTag.getAcceptableAttachmentId();
            for (Slot itemSlot : this.menu.f_38839_) {
                ResourceLocation id;
                if (itemSlot instanceof NewAttachmentMenu.JustLookSlot || (id = ForgeRegistries.ITEMS.getKey((Object)itemSlot.m_7993_().m_41720_())) == null || !ids.contains(id.toString())) continue;
                this.suitableSlots.add(itemSlot);
            }
            if (!this.suitableSlots.contains(this.selectedItemSlot)) {
                this.selectedItemSlot = null;
            }
        }
    }

    private void updateDelta() {
        if (this.lastRender == 0L) {
            this.lastRender = System.currentTimeMillis();
        } else {
            long now = System.currentTimeMillis();
            float timeDis = (float)(now - this.lastRender) * 0.001f;
            this.lastRender = now;
            this.delta += timeDis;
            if (this.delta >= 1.0f) {
                this.delta = 0.0f;
            }
            this.cyclingDelta = Mth.m_14031_((float)(this.delta * (float)Math.PI));
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int p_283661_, int p_281248_, float p_281886_) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, p_283661_, p_281248_, p_281886_);
        this.m_280072_(guiGraphics, p_283661_, p_281248_);
        this.renderSuitableSlotMark(guiGraphics);
        this.highLightSlot(guiGraphics);
        this.updateDelta();
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tooltip.gunscraft.suitable_attachments"), this.f_97735_ + 253, this.f_97736_ + 132, -1);
    }

    private void renderSuitableSlotMark(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.25f + 0.75f * this.cyclingDelta));
        for (Slot slot : this.suitableSlots) {
            if (slot instanceof NewAttachmentMenu.JustLookSlot) continue;
            guiGraphics.m_280163_(SUITABLE_SLOT_MARK, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void highLightSlot(GuiGraphics guiGraphics) {
        if (this.selectedItemSlot != null) {
            guiGraphics.m_280163_(SELECTED_SLOT, this.f_97735_ + this.selectedItemSlot.f_40220_ - 3, this.f_97736_ + this.selectedItemSlot.f_40221_ - 3, 0.0f, 0.0f, 22, 22, 22, 22);
        }
    }

    protected void m_6597_(Slot slot, int p_97779_, int p_97780_, ClickType p_97781_) {
        if (slot instanceof NewAttachmentMenu.JustLookSlot) {
            return;
        }
        if (slot == this.selectedItemSlot) {
            this.selectedItemSlot = null;
            return;
        }
        if (this.suitableSlots != null && this.suitableSlots.contains(slot)) {
            this.selectedItemSlot = slot;
            return;
        }
        super.m_6597_(slot, p_97779_, p_97780_, p_97781_);
    }

    private boolean isMouseInModelArea(double mx, double my) {
        return mx >= (double)(this.f_97735_ + 5) && mx <= (double)(this.f_97735_ + 323) && my >= (double)(this.f_97736_ + 5) && my <= (double)(this.f_97736_ + 123);
    }

    private void installAttachment() {
        ResourceLocation key;
        if (this.canOperateData() && this.selectedItemSlot != null && this.suitableSlots.contains(this.selectedItemSlot) && (key = ForgeRegistries.ITEMS.getKey((Object)this.selectedItemSlot.m_7993_().m_41720_())) != null) {
            ItemStack gunStack = this.f_96541_.f_91074_.m_21205_();
            String attachmentId = key.toString();
            GuiSlot guiSlot = this.attachmentsGuiContext.selectGuiSlot;
            String slotName = guiSlot.slotTag.getSlotName();
            Result result = guiSlot.slotTag.install((Player)this.f_96541_.f_91074_, gunStack, attachmentId);
            if (result.success) {
                NewSetAttachmentPacket packet = new NewSetAttachmentPacket(attachmentId, slotName, this.selectedItemSlot.f_40219_);
                PacketHandler.simpleChannel.sendToServer((Object)packet);
                this.selectedItemSlot.m_5852_(ItemStack.f_41583_);
                this.suitableSlots.remove(this.selectedItemSlot);
                this.selectedItemSlot = null;
                this.tempSelectedSlotName = this.attachmentsGuiContext.selectGuiSlot.slotTag.getSlotName();
            }
        }
    }

    private boolean canOperateData() {
        return this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.attachmentsGuiContext.selectGuiSlot != null;
    }

    private void uninstallAttachment() {
        if (!this.canOperateData()) {
            return;
        }
        GuiSlot guiSlot = this.attachmentsGuiContext.selectGuiSlot;
        LocalPlayer player = this.f_96541_.f_91074_;
        ItemStack gunStack = this.f_96541_.f_91074_.m_21205_();
        Result result = this.attachmentsGuiContext.selectGuiSlot.slotTag.unInstall((Player)player, gunStack);
        if (result.success) {
            NewSetAttachmentPacket packet = new NewSetAttachmentPacket(AttachmentsHandler.EMPTY_ID, guiSlot.slotTag.getSlotName(), -1);
            PacketHandler.simpleChannel.sendToServer((Object)packet);
            this.tempSelectedSlotName = this.attachmentsGuiContext.selectGuiSlot.slotTag.getSlotName();
        }
    }

    public boolean m_7933_(int p_97765_, int p_97766_, int p_97767_) {
        switch (p_97765_) {
            case 87: {
                this.installAttachment();
                break;
            }
            case 83: {
                this.uninstallAttachment();
            }
        }
        return super.m_7933_(p_97765_, p_97766_, p_97767_);
    }

    private void updateSuitableContainer(GuiSlot guiSlot) {
        if (this.canOperateData() && guiSlot != null) {
            this.menu.suitableAttachmentsShow.m_6211_();
            Set<String> ids = guiSlot.slotTag.getAcceptableAttachmentId();
            for (String id : ids) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
                if (item == null) continue;
                this.menu.suitableAttachmentsShow.m_19173_(new ItemStack((ItemLike)item));
            }
        }
    }

    public boolean m_6375_(double x, double y, int p_97750_) {
        for (EasyButton button : this.buttons) {
            boolean click = button.click(x, y, p_97750_);
            if (!click) continue;
            return false;
        }
        if (this.isMouseInModelArea(x, y)) {
            boolean selected;
            if (this.attachmentsGuiContext != null && (selected = this.attachmentsGuiContext.selectByMouse(x, y, false))) {
                this.updateSuitableSlots(this.attachmentsGuiContext.selectGuiSlot);
                this.updateSuitableContainer(this.attachmentsGuiContext.selectGuiSlot);
                this.updateBtnStatus();
                return false;
            }
            this.mouseRollingModel = true;
            this.dragStartX = (float)x;
            this.dragStartY = (float)y;
            return false;
        }
        return super.m_6375_(x, y, p_97750_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isMouseInModelArea(mouseX, mouseY)) {
            this.scaleZoom = (float)((double)this.scaleZoom + delta * 2.5);
            if (this.scaleZoom > 200.0f) {
                this.scaleZoom = 200.0f;
            }
            if (this.scaleZoom < -200.0f) {
                this.scaleZoom = -200.0f;
            }
            return false;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragBtn.dragging) {
            this.dragBtn.drag(mouseX, mouseY, button, dragX, dragY);
            return false;
        }
        if (this.mouseRollingModel) {
            this.modelRY = this.tempModelRY + (float)(mouseX - (double)this.dragStartX);
            this.modelRX = this.tempModelRX + (float)(mouseY - (double)this.dragStartY);
            return false;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mx, double my, int p_97814_) {
        if (this.dragBtn.dragging) {
            this.dragBtn.mouseUp(mx, my);
            return false;
        }
        if (this.mouseRollingModel) {
            this.mouseRollingModel = false;
            this.tempModelRY = this.modelRY % 360.0f;
            this.tempModelRX = this.modelRX % 360.0f;
            return false;
        }
        return super.m_6348_(mx, my, p_97814_);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int p_282681_, int p_283686_) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float tick, int x, int y) {
        if (this.f_96541_ != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int startX = (this.f_96543_ - this.getXSize()) / 2;
            int startY = (this.f_96544_ - this.getYSize()) / 2;
            guiGraphics.m_280163_(BACK_GROUND, startX, startY, 0.0f, 0.0f, this.getXSize(), this.getYSize(), this.getXSize(), this.getYSize());
            LocalPlayer player = this.f_96541_.f_91074_;
            if (player != null) {
                this.renderGun(guiGraphics, (float)this.f_97735_ + 155.0f, this.f_97736_ + 65, 150.0f, (LivingEntity)this.f_96541_.f_91074_);
            }
            if (!this.firstTick) {
                for (EasyButton button : this.buttons) {
                    button.m_88315_(guiGraphics, x, y, tick);
                }
            }
        }
    }

    private void renderGun(GuiGraphics graphics, float posX, float posY, float scale, LivingEntity livingEntity) {
        Player player;
        ItemStack stack;
        Item item;
        if (livingEntity instanceof Player && (item = (stack = (player = (Player)livingEntity).m_21205_()).m_41720_()) instanceof IGenericGun) {
            IGenericGun gun = (IGenericGun)item;
            PoseStack poseStackView = graphics.m_280168_();
            poseStackView.m_85836_();
            poseStackView.m_252880_(posX + this.dragX, posY + this.dragY, 300.0f);
            poseStackView.m_252781_(Quaternions.rotateDeg(-this.modelRX, 90.0f + this.modelRY, -180.0f));
            poseStackView.m_85841_(-1.0f, 1.0f, 1.0f);
            float scaleFactor = gun.isPistol() || gun.canHoldInOneHand() ? 1.5f : 1.0f;
            poseStackView.m_85841_((scale + this.scaleZoom) * scaleFactor, (scale + this.scaleZoom) * scaleFactor, (scale + this.scaleZoom) * scaleFactor);
            GL11.glEnable((int)3089);
            NewAttachmentScreen.setupScissor((this.f_96543_ - this.getXSize()) / 2 + 5, (this.f_96544_ - this.getYSize()) / 2 + 5, 318, 118);
            Lighting.m_166384_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GunRenderer.INSTANCE.renderInGuiScreen(stack, graphics, gun, Clients.gunModelMap.get(stack.m_41720_()), this.attachmentsGuiContext);
            Lighting.m_84931_();
            GL11.glDisable((int)3089);
            poseStackView.m_85849_();
        }
    }

    public static void setupScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        int scale = (int)mc.m_91268_().m_85449_();
        GL11.glScissor((int)(x * scale), (int)(mc.m_91268_().m_85442_() - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
    }
}

