/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.blocks.VendingMachine;
import sheridan.gunscraft.container.VendingMachineMenu;
import sheridan.gunscraft.items.Cash;
import sheridan.gunscraft.items.ModItems;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.VendingMachineDealPacket;
import sheridan.gunscraft.network.packets.VendingMachineExchangePacket;
import sheridan.gunscraft.screen.utils.EasyButton;
import sheridan.gunscraft.sounds.SoundEvents;

public class VendingMachineScreen
extends AbstractContainerScreen<VendingMachineMenu> {
    public static final ResourceLocation EXCHANGE = new ResourceLocation("gunscraft", "textures/gui/screen/exchange.png");
    public static final ResourceLocation ADD = new ResourceLocation("gunscraft", "textures/gui/screen/add.png");
    public static final ResourceLocation DEC = new ResourceLocation("gunscraft", "textures/gui/screen/dec.png");
    public static final ResourceLocation SCROLL_BUTTON = new ResourceLocation("gunscraft", "textures/gui/screen/scroll_button.png");
    public static final ResourceLocation TAB = new ResourceLocation("gunscraft", "textures/gui/screen/tab.png");
    public static final ResourceLocation TAB_SELECTED = new ResourceLocation("gunscraft", "textures/gui/screen/tab_selected.png");
    public static final ResourceLocation BACK_GROUND = new ResourceLocation("gunscraft", "textures/gui/screen/vending_machine_screen.png");
    public static final ResourceLocation BACK_GROUND_ECONOMY = new ResourceLocation("gunscraft", "textures/gui/screen/vending_machine_screen_economy.png");
    public static final ResourceLocation DEAL = new ResourceLocation("gunscraft", "textures/gui/screen/deal.png");
    public static final ResourceLocation CLEAR_CART = new ResourceLocation("gunscraft", "textures/gui/screen/clear_cart.png");
    public SimpleContainer shoppingCart;
    public SimpleContainer productsList;
    public SimpleContainer economyProducts;
    private final EasyButton scrollButton;
    private int pageStart = 0;
    private int prevPageSize = 5;
    private final int[] priceList = new int[]{0, 0, 0, 0, 0};
    private String page;
    private List<VendingMachine.Product> pageProducts;
    private final Map<String, EasyButton> tabButtons = new HashMap<String, EasyButton>();
    private final List<EasyButton> addButtons = new ArrayList<EasyButton>();
    private final List<EasyButton> decButtons = new ArrayList<EasyButton>();
    private boolean firstTick = true;
    private boolean scrollBtnDown = false;
    private double pageLen;
    private static final double SCROLL_LEN = 128.0;
    private EasyButton dealBtn;
    private EasyButton exchangeBtn;
    private EasyButton clearShoppingCartBtn;
    private EasyEditBox editBox;
    private VendingMachine.Product selectedEconomyProduct;
    private double mx;
    private double my;
    private int exchangeVal;
    private int MAX_EXCHANGE_VAL = this.exchangeVal * 1000;
    private int MIN_EXCHANGE_VAL = this.exchangeVal;
    private int tick = 0;
    private int playerTotalAsset = -1;
    private int shoppingCartTotalAsset = 0;
    private final Map<String, List<VendingMachine.Product>> products = VendingMachine.products;

    public VendingMachineScreen(VendingMachineMenu vendingMachineMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)vendingMachineMenu, inventory, component);
        this.shoppingCart = vendingMachineMenu.shoppingCart;
        this.productsList = vendingMachineMenu.productsList;
        this.economyProducts = vendingMachineMenu.economyProducts;
        this.page = "weapons";
        this.pageProducts = this.products.get(this.page);
        int pages = this.pageProducts.size() / 5;
        this.pageLen = pages > 0 ? 128.0 / (double)(this.pageProducts.size() / 5) : 128.0;
        this.f_97726_ = 176;
        this.f_97727_ = 201;
        this.tabButtons.put("economy", (EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 30, 28, 0, 0, 0, TAB, 32, 28, button -> this.changePage("economy"))));
        this.tabButtons.put("weapons", (EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 30, 28, 0, 0, 0, TAB, 32, 28, button -> this.changePage("weapons"))));
        this.tabButtons.put("attachments", (EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 30, 28, 0, 0, 0, TAB, 32, 28, button -> this.changePage("attachments"))));
        this.tabButtons.put("ammo", (EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 30, 28, 0, 0, 0, TAB, 32, 28, button -> this.changePage("ammo"))));
        this.scrollButton = (EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 12, 15, 0, 0, 0, SCROLL_BUTTON, 12, 15, button -> {
            this.scrollBtnDown = true;
        }));
        int i = 0;
        while (i < 5) {
            int finalI = i++;
            this.addButtons.add((EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 16, 16, 0, 0, 0, ADD, 16, 16, button -> this.updateShoppingCart(finalI, true))));
            this.decButtons.add((EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 16, 16, 0, 0, 0, DEC, 16, 16, button -> this.updateShoppingCart(finalI, false))));
        }
        this.dealBtn = (EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 32, 32, 0, 0, 0, DEAL, 32, 32, button -> this.deal()));
        this.exchangeBtn = (EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 24, 16, 0, 0, 0, EXCHANGE, 24, 16, button -> this.exchange()));
        this.clearShoppingCartBtn = (EasyButton)this.m_7787_((GuiEventListener)new EasyButton(0, 0, 32, 32, 0, 0, 0, CLEAR_CART, 32, 32, button -> {
            this.shoppingCart.m_6211_();
            this.shoppingCartTotalAsset = 0;
        }));
        this.tabButtons.get("economy").m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.economy")));
        this.tabButtons.get("weapons").m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.weapons")));
        this.tabButtons.get("ammo").m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.ammo")));
        this.tabButtons.get("attachments").m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.attachments")));
        this.dealBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.settlement")));
        this.clearShoppingCartBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.clear_cart")));
        this.exchangeBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.exchange")));
        for (EasyButton button2 : this.addButtons) {
            button2.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.add_product")));
        }
        for (EasyButton button3 : this.decButtons) {
            button3.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.dec_product")));
        }
        this.editBox = new EasyEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 50, 14, (Component)Component.m_237113_((String)("" + this.MIN_EXCHANGE_VAL)));
        this.editBox.m_94199_(10);
        this.editBox.m_94182_(true);
        this.editBox.m_94194_(true);
        this.editBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.exchange_amount")));
        this.editBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.max_exchange_amount").m_130946_(" " + this.MAX_EXCHANGE_VAL)));
        this.editBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.gunscraft.min_exchange_amount").m_130946_(" " + this.MIN_EXCHANGE_VAL)));
        this.editBox.m_94202_(0xFFFFFF);
        this.editBox = (EasyEditBox)this.m_7787_((GuiEventListener)this.editBox);
    }

    private void deal() {
        List itemStacks;
        if (this.f_96541_ == null) {
            return;
        }
        LocalPlayer player = this.f_96541_.f_91074_;
        if (player == null) {
            return;
        }
        if (this.playerTotalAsset < this.shoppingCartTotalAsset) {
            return;
        }
        if (!this.shoppingCart.m_7983_() && (itemStacks = this.shoppingCart.m_19195_()).size() > 0) {
            VendingMachineDealPacket packet = new VendingMachineDealPacket(itemStacks, this.shoppingCartTotalAsset);
            PacketHandler.simpleChannel.sendToServer((Object)packet);
            SoundEvents.playSound("item.vending_machine.deal_done", (LivingEntity)player, 1.0f, 1.0f);
            this.playerTotalAsset -= this.shoppingCartTotalAsset;
            this.shoppingCartTotalAsset = 0;
            this.shoppingCart.m_6211_();
        }
    }

    private void exchange() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.selectedEconomyProduct != null) {
            LocalPlayer player = this.f_96541_.f_91074_;
            Inventory inventory = player.m_150109_();
            int len = inventory.m_6643_();
            this.checkInput();
            int val = 0;
            for (int i = 0; i < len; ++i) {
                if (inventory.m_8020_(i).m_41720_() != this.selectedEconomyProduct.item || (val += this.MIN_EXCHANGE_VAL * inventory.m_8020_(i).m_41613_()) < this.exchangeVal) continue;
                val = this.exchangeVal;
                break;
            }
            if (val < this.MIN_EXCHANGE_VAL) {
                return;
            }
            PacketHandler.simpleChannel.sendToServer((Object)new VendingMachineExchangePacket(val, this.MIN_EXCHANGE_VAL, Item.m_41393_((Item)this.selectedEconomyProduct.item)));
            Cash.exchange(val, (Player)player, this.MIN_EXCHANGE_VAL, Item.m_41393_((Item)this.selectedEconomyProduct.item));
            this.editBox.m_94144_("" + val);
            this.exchangeVal = val;
        }
    }

    private void changePage(String pageName) {
        this.page = pageName;
        this.prevPageSize = 5;
        this.pageStart = 0;
        this.pageProducts = this.products.get(pageName);
        int pages = this.pageProducts.size() / 5;
        this.pageLen = pages > 0 ? 128.0 / (double)(this.pageProducts.size() / 5) : 128.0;
    }

    private boolean hasItem(Item item) {
        return this.shoppingCart.m_18947_(item) > 0;
    }

    private void updateShoppingCart(int roll, boolean add) {
        try {
            ItemStack stack;
            ItemStack itemStack = stack = this.inEconomyPage() ? new ItemStack((ItemLike)this.selectedEconomyProduct.item) : this.productsList.m_8020_(roll);
            if (add) {
                if (this.shoppingCart.m_19183_(stack)) {
                    this.shoppingCart.m_19173_(stack);
                    VendingMachine.Product product = this.inEconomyPage() ? this.selectedEconomyProduct : this.pageProducts.get(this.pageStart + roll);
                    this.shoppingCartTotalAsset += product.price;
                }
            } else {
                int len = this.shoppingCart.m_6643_();
                for (int i = len - 1; i >= 0; --i) {
                    ItemStack product = this.shoppingCart.m_8020_(i);
                    if (product.m_41720_() != stack.m_41720_() || product.m_41613_() <= 0) continue;
                    if (this.inEconomyPage()) {
                        this.shoppingCartTotalAsset -= this.selectedEconomyProduct.price;
                    } else {
                        for (VendingMachine.Product productType : this.pageProducts) {
                            if (productType.item != product.m_41720_()) continue;
                            this.shoppingCartTotalAsset -= productType.price;
                        }
                    }
                    product.m_41764_(product.m_41613_() - 1);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean inEconomyPage() {
        return "economy".equals(this.page);
    }

    protected void m_181908_() {
        LocalPlayer player;
        if (this.inEconomyPage()) {
            ((VendingMachineMenu)this.f_97732_).setupEconomyProductsSlotStatus();
        } else {
            ((VendingMachineMenu)this.f_97732_).setupNormalSlotStatus();
        }
        this.tabButtons.get("economy").m_264152_(this.f_97735_ - 29, this.f_97736_ + 53);
        this.tabButtons.get("weapons").m_264152_(this.f_97735_ - 29, this.f_97736_ + 107);
        this.tabButtons.get("attachments").m_264152_(this.f_97735_ - 29, this.f_97736_ + 134);
        this.tabButtons.get("ammo").m_264152_(this.f_97735_ - 29, this.f_97736_ + 161);
        this.updateScrollBtnPos();
        this.updatePageList();
        this.updateControllerBtn();
        this.dealBtn.m_264152_(this.f_97735_ + 178, this.f_97736_);
        this.clearShoppingCartBtn.m_264152_(this.f_97735_ + 178, this.f_97736_ + 35);
        this.editBox.m_264152_(this.f_97735_ + 50, this.f_97736_ + 60);
        this.exchangeBtn.m_264152_(this.f_97735_ + 110, this.f_97736_ + 59);
        this.updateEconomyPage();
        this.updateEditBox();
        this.firstTick = false;
        ++this.tick;
        if (this.tick >= 1000) {
            this.tick = 0;
        }
        if (this.playerTotalAsset == -1 && this.f_96541_ != null && (player = this.f_96541_.f_91074_) != null) {
            this.playerTotalAsset = Cash.getTotalAsset((Player)player);
        }
        if (Clients.vendingMachineAssetChange != 0) {
            this.playerTotalAsset = Clients.vendingMachineAssetChange;
            Clients.vendingMachineAssetChange = 0;
        }
        super.m_181908_();
    }

    private void updateEconomyPage() {
        if (this.inEconomyPage()) {
            this.hindAllControllerBtn();
            this.editBox.f_93624_ = true;
            this.editBox.f_93623_ = true;
            this.exchangeBtn.f_93623_ = true;
            this.updateControllerBtn(1, true);
            this.updateControllerBtn(1, false);
        }
    }

    private void hindAllControllerBtn() {
        for (EasyButton easyButton : this.addButtons) {
            easyButton.f_93623_ = false;
            easyButton.f_93624_ = false;
        }
        for (EasyButton easyButton : this.decButtons) {
            easyButton.f_93623_ = false;
            easyButton.f_93624_ = false;
        }
    }

    private void updateControllerBtn(int index, boolean addBtn) {
        boolean showBtn;
        boolean notEmpty;
        EasyButton button = addBtn ? this.addButtons.get(index) : this.decButtons.get(index);
        button.m_264152_(this.f_97735_ + 100 + (addBtn ? 0 : 20), this.f_97736_ + 59 + index * 27);
        Item item = this.productsList.m_8020_(index).m_41720_();
        int price = this.inEconomyPage() ? this.selectedEconomyProduct.price : this.priceList[index];
        boolean bl = notEmpty = this.productsList.m_8020_(index) != ItemStack.f_41583_;
        boolean bl2 = addBtn ? notEmpty && item != ModItems.CASH.get() && this.playerTotalAsset - this.shoppingCartTotalAsset >= price : (showBtn = notEmpty && item != ModItems.CASH.get() && this.hasItem(item));
        if (showBtn) {
            button.f_93623_ = true;
            button.f_93624_ = true;
        } else {
            button.f_93623_ = false;
            button.f_93624_ = false;
        }
    }

    private void updateControllerBtn() {
        int i;
        if (this.inEconomyPage()) {
            return;
        }
        this.editBox.f_93624_ = false;
        this.editBox.f_93623_ = false;
        this.exchangeBtn.f_93623_ = false;
        for (i = 0; i < 5; ++i) {
            this.updateControllerBtn(i, true);
        }
        for (i = 0; i < 5; ++i) {
            this.updateControllerBtn(i, false);
        }
    }

    private void updateEditBox() {
        this.editBox.m_94120_();
    }

    private void checkInput() {
        try {
            this.exchangeVal = Math.min(Integer.parseInt(this.editBox.m_94155_()), this.MAX_EXCHANGE_VAL);
            this.exchangeVal = Math.max(this.MIN_EXCHANGE_VAL, this.exchangeVal);
            if (this.exchangeVal % this.MIN_EXCHANGE_VAL != 0) {
                this.exchangeVal -= this.exchangeVal % this.MIN_EXCHANGE_VAL;
            }
            this.editBox.m_94144_("" + this.exchangeVal);
        }
        catch (Exception ignored) {
            this.editBox.m_94144_("" + this.MIN_EXCHANGE_VAL);
        }
    }

    private void updateScrollBtnPos() {
        int y = 0;
        if (this.checkList()) {
            y = this.pageStart / 5;
        }
        this.scrollButton.m_264152_(this.f_97735_ + 153, (int)((double)(this.f_97736_ + 50) + (double)y * this.pageLen));
    }

    public void m_7379_() {
        Clients.vendingMachineAssetChange = 0;
        super.m_7379_();
    }

    public void m_94757_(double p_94758_, double p_94759_) {
        this.mx = p_94758_;
        this.my = p_94759_;
        super.m_94757_(p_94758_, p_94759_);
    }

    private void updatePageList() {
        if (this.checkList()) {
            if (!this.inEconomyPage()) {
                int i;
                int endIndex = Math.min(this.pageStart + 5, this.pageProducts.size());
                this.prevPageSize = endIndex - this.pageStart;
                int j = 0;
                for (i = this.pageStart; i < endIndex; ++i) {
                    VendingMachine.Product product = this.pageProducts.get(i);
                    this.productsList.m_6836_(j, new ItemStack((ItemLike)product.item));
                    this.priceList[j] = product.price;
                    ++j;
                }
                if (this.prevPageSize > 0 && this.prevPageSize < 5) {
                    for (i = this.prevPageSize; i < 5; ++i) {
                        this.productsList.m_6836_(i, ItemStack.f_41583_);
                    }
                }
            } else {
                for (int i = 1; i < this.pageProducts.size(); ++i) {
                    this.economyProducts.m_6836_(i - 1, new ItemStack((ItemLike)this.pageProducts.get((int)i).item));
                }
                if (this.selectedEconomyProduct == null) {
                    this.selectedEconomyProduct = this.pageProducts.get(1);
                }
                this.productsList.m_6836_(0, new ItemStack((ItemLike)ModItems.CASH.get()));
                this.productsList.m_6836_(1, new ItemStack((ItemLike)this.selectedEconomyProduct.item));
                this.exchangeVal = this.selectedEconomyProduct.price;
                this.MAX_EXCHANGE_VAL = this.MIN_EXCHANGE_VAL * 1000;
                this.MIN_EXCHANGE_VAL = this.selectedEconomyProduct.price;
            }
        }
    }

    protected void m_280003_(GuiGraphics p_281635_, int p_282681_, int p_283686_) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int p_283661_, int p_281248_, float p_281886_) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, p_283661_, p_281248_, p_281886_);
        this.m_280072_(guiGraphics, p_283661_, p_281248_);
        RenderSystem.enableDepthTest();
        guiGraphics.m_280246_(0.83137256f, 0.9490196f, 0.90588236f, 1.0f);
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"label.gunscraft.shopping_cart"), this.f_97735_ + 5, this.f_97736_ + 3, -1);
        if (this.inEconomyPage()) {
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"label.gunscraft.registered_economy_products"), this.f_97735_ + 13, this.f_97736_ + 110, -1);
        }
        if (!this.firstTick) {
            this.renderImageButton(guiGraphics, p_283661_, p_281248_, p_281886_);
            this.renderPrice(guiGraphics);
            if (this.editBox.m_94213_() && this.editBox.f_93623_) {
                this.editBox.m_88315_(guiGraphics, p_283661_, p_281248_, p_281886_);
            }
        }
    }

    private void renderPrice(GuiGraphics guiGraphics) {
        if (this.priceList != null) {
            if (!this.inEconomyPage()) {
                for (int i = 0; i < 5; ++i) {
                    if (this.productsList.m_8020_(i) != ItemStack.f_41583_) {
                        if (this.priceList[i] <= 0) continue;
                        if (this.playerTotalAsset - this.shoppingCartTotalAsset >= this.priceList[i]) {
                            guiGraphics.m_280246_(0.0f, 1.0f, 0.0f, 1.0f);
                        } else {
                            guiGraphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
                        }
                        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"container.gunscraft.price").m_130946_(" " + this.priceList[i]), this.f_97735_ + 42, this.f_97736_ + 63 + i * 27, -1);
                        continue;
                    }
                    guiGraphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
                    guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)""), this.f_97735_ + 42, this.f_97736_ + 63 + i * 27, -1);
                }
            } else if (this.productsList.m_8020_(1) != ItemStack.f_41583_ && this.selectedEconomyProduct != null) {
                int price = this.selectedEconomyProduct.price;
                if (this.playerTotalAsset - this.shoppingCartTotalAsset >= price) {
                    guiGraphics.m_280246_(0.0f, 1.0f, 0.0f, 1.0f);
                } else {
                    guiGraphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
                }
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"container.gunscraft.price").m_130946_(" " + this.selectedEconomyProduct.price), this.f_97735_ + 42, this.f_97736_ + 63 + 27, -1);
            } else {
                guiGraphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)""), this.f_97735_ + 42, this.f_97736_ + 63 + 27, -1);
            }
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void renderAsset(GuiGraphics guiGraphics) {
        guiGraphics.m_280246_(0.0f, 1.0f, 0.0f, 1.0f);
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tooltip.gunscraft.asset"), this.f_97735_ + 178, this.f_97736_ + 80, -1);
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)(this.playerTotalAsset + " / " + this.shoppingCartTotalAsset)), this.f_97735_ + 178, this.f_97736_ + 88, -1);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderImageButton(GuiGraphics guiGraphics, int p_283661_, int p_281248_, float p_281886_) {
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        for (String key : this.tabButtons.keySet()) {
            List<VendingMachine.Product> productList;
            EasyButton button = this.tabButtons.get(key);
            if (button == null) continue;
            int x = 0;
            if (this.page.equals(key)) {
                button.renderTex(guiGraphics, TAB_SELECTED);
                x = 2;
            } else {
                button.m_88315_(guiGraphics, p_283661_, p_281248_, p_281886_);
            }
            if ((productList = this.products.get(key)) == null || productList.size() <= 0) continue;
            VendingMachine.Product product = productList.get(0);
            guiGraphics.m_280203_(new ItemStack((ItemLike)product.item), button.m_252754_() + 10 - x, button.m_252907_() + 5);
        }
        for (EasyButton button : this.addButtons) {
            this.renderButton(guiGraphics, p_283661_, p_281248_, p_281886_, button);
        }
        for (EasyButton button : this.decButtons) {
            this.renderButton(guiGraphics, p_283661_, p_281248_, p_281886_, button);
        }
        this.scrollButton.m_88315_(guiGraphics, p_283661_, p_281248_, p_281886_);
        this.renderButton(guiGraphics, p_283661_, p_281248_, p_281886_, this.dealBtn);
        this.renderButton(guiGraphics, p_283661_, p_281248_, p_281886_, this.clearShoppingCartBtn);
        if (this.exchangeBtn.f_93623_) {
            this.renderButton(guiGraphics, p_283661_, p_281248_, p_281886_, this.exchangeBtn);
        }
        RenderSystem.disableBlend();
    }

    void renderButton(GuiGraphics guiGraphics, int p_283661_, int p_281248_, float p_281886_, EasyButton button) {
        if (button.m_274382_() && button.f_93623_) {
            guiGraphics.m_280246_(0.0f, 1.0f, 1.0f, 0.5f);
        }
        button.m_88315_(guiGraphics, p_283661_, p_281248_, p_281886_);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        if (this.f_96541_ != null) {
            ResourceLocation currentBackground = "economy".equals(this.page) ? BACK_GROUND_ECONOMY : BACK_GROUND;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.f_96541_.m_91097_().m_174784_(currentBackground);
            int startX = (this.f_96543_ - this.getXSize()) / 2;
            int startY = (this.f_96544_ - this.getYSize()) / 2;
            guiGraphics.m_280218_(currentBackground, startX, startY, 0, 0, this.getXSize(), this.getYSize());
            this.renderAsset(guiGraphics);
        }
    }

    protected void m_6597_(Slot slot, int p_97779_, int p_97780_, ClickType clickType) {
        VendingMachineMenu.SimpleSlot simpleSlot;
        if (slot instanceof VendingMachineMenu.SimpleSlot && ((VendingMachineMenu)this.f_97732_).isEconomySlot(simpleSlot = (VendingMachineMenu.SimpleSlot)slot) && slot.m_7993_() != ItemStack.f_41583_ && slot.getSlotIndex() + 1 < this.pageProducts.size()) {
            this.selectedEconomyProduct = this.pageProducts.get(slot.getSlotIndex() + 1);
        }
    }

    protected boolean m_6774_(int p_97768_, int p_97769_, int p_97770_, int p_97771_, double p_97772_, double p_97773_) {
        return super.m_6774_(p_97768_, p_97769_, p_97770_, p_97771_, p_97772_, p_97773_);
    }

    public boolean m_6348_(double p_97812_, double p_97813_, int p_97814_) {
        this.scrollBtnDown = false;
        return super.m_6348_(p_97812_, p_97813_, p_97814_);
    }

    public boolean m_7979_(double mx, double my, int p_97754_, double xDis, double yDis) {
        if (this.scrollBtnDown && this.pageLen > 0.0) {
            double y = my - (double)(this.f_97736_ + 50);
            if (y >= 0.0 && y <= 143.0) {
                int index = (int)(y / this.pageLen);
                this.pageStart = index * 5;
            }
            return false;
        }
        return super.m_7979_(mx, my, p_97754_, xDis, yDis);
    }

    public boolean m_6375_(double p_97748_, double p_97749_, int p_97750_) {
        for (EasyButton button : this.tabButtons.values()) {
            boolean click = button.click(p_97748_, p_97749_, p_97750_);
            if (!click) continue;
            return false;
        }
        if (this.scrollButton.click(p_97748_, p_97749_, p_97750_)) {
            this.scrollButton.click(p_97748_, p_97749_, p_97750_);
            return false;
        }
        for (EasyButton button : this.addButtons) {
            if (!button.click(p_97748_, p_97749_, p_97750_)) continue;
            return false;
        }
        for (EasyButton button : this.decButtons) {
            if (!button.click(p_97748_, p_97749_, p_97750_)) continue;
            return false;
        }
        if (this.dealBtn.click(p_97748_, p_97749_, p_97750_)) {
            return false;
        }
        if (this.clearShoppingCartBtn.click(p_97748_, p_97749_, p_97750_)) {
            return false;
        }
        return super.m_6375_(p_97748_, p_97749_, p_97750_);
    }

    private void nextPage() {
        if (this.checkList() && this.pageProducts.size() > 5 && this.pageStart + 5 < this.pageProducts.size()) {
            this.pageStart += 5;
        }
    }

    private void prevPage() {
        if (this.checkList() && this.pageStart >= 5) {
            this.pageStart -= 5;
        }
    }

    private boolean checkList() {
        return this.pageProducts != null && this.pageProducts.size() > 0;
    }

    public boolean m_6050_(double mx, double my, double dis) {
        if (mx > (double)(this.f_97735_ + 12) && my < (double)(this.f_97735_ + 142) && my > (double)(this.f_97736_ + 51) && my < (double)(this.f_97736_ + 192)) {
            if (dis > 0.0) {
                this.prevPage();
                return false;
            }
            if (dis < 0.0) {
                this.nextPage();
                return false;
            }
        }
        return super.m_6050_(mx, my, dis);
    }

    private static class EasyEditBox
    extends EditBox {
        public EasyEditBox(Font p_94114_, int p_94115_, int p_94116_, int p_94117_, int p_94118_, Component p_94119_) {
            super(p_94114_, p_94115_, p_94116_, p_94117_, p_94118_, p_94119_);
        }

        public boolean m_5534_(char c, int p_94123_) {
            if (c >= '0' && c <= '9') {
                return super.m_5534_(c, p_94123_);
            }
            return false;
        }
    }
}

