/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.screen.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class EasyButton
extends ImageButton {
    public int f_93620_;
    public int f_93621_;
    public Mode mode = Mode.CLICK;
    public boolean dragging = false;
    private OnDrag onDrag;
    private OnDragStart onDragStart;
    private OnDragEnd onDragEnd;
    public boolean prevented;

    public boolean willRender() {
        return this.f_93623_ || this.prevented;
    }

    public EasyButton(int p_94256_, int p_94257_, int p_94258_, int p_94259_, int p_94260_, int p_94261_, int p_94262_, ResourceLocation p_94263_, int p_94264_, int p_94265_, Button.OnPress p_94266_) {
        super(p_94256_, p_94257_, p_94258_, p_94259_, p_94260_, p_94261_, p_94262_, p_94263_, p_94264_, p_94265_, p_94266_);
    }

    public static EasyButton button(ResourceLocation texture, int sizeX, int sizeY, Button.OnPress onPress) {
        return new EasyButton(0, 0, sizeX, sizeY, 0, 0, 0, texture, sizeX, sizeY, onPress);
    }

    public static EasyButton button(ResourceLocation texture, int sizeX, int sizeY, String tooltip, Button.OnPress onPress) {
        EasyButton button = EasyButton.button(texture, sizeX, sizeY, onPress);
        button.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)tooltip)));
        return button;
    }

    public void setTooltip(String name) {
        this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)name)));
    }

    public EasyButton setOnDrag(OnDrag onDrag) {
        this.onDrag = onDrag;
        return this;
    }

    public EasyButton setOnDragStart(OnDragStart onDragStart) {
        this.onDragStart = onDragStart;
        return this;
    }

    public EasyButton setOnDragEnd(OnDragEnd onDragEnd) {
        this.onDragEnd = onDragEnd;
        return this;
    }

    public void renderTex(GuiGraphics p_282421_, ResourceLocation resourceLocation) {
        this.m_280322_(p_282421_, resourceLocation, this.m_252754_(), this.m_252907_(), this.f_94224_, this.f_94225_, this.f_94226_, this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
    }

    public void drag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.f_93623_ && this.mode == Mode.DRAG && this.dragging && this.onDrag != null) {
            this.onDrag.drag(mouseX, mouseY, button, dragX, dragY);
        }
    }

    public void mouseUp(double mx, double my) {
        if (this.f_93623_ && this.mode == Mode.DRAG && this.dragging && this.onDragEnd != null) {
            this.onDragEnd.end(mx, my);
        }
        this.dragging = false;
    }

    public boolean click(double mx, double my, int button) {
        if (!this.f_93623_) {
            return false;
        }
        boolean clicked = this.inArea(mx, my);
        if (this.mode == Mode.CLICK) {
            if (button == 0) {
                if (clicked) {
                    try {
                        LocalPlayer player = Minecraft.m_91087_().f_91074_;
                        player.m_9236_().m_5594_((Player)player, player.m_20097_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.MUSIC, 1.0f, 1.0f);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_5691_();
                }
                return clicked;
            }
        } else if (this.mode == Mode.DRAG) {
            if (clicked) {
                this.dragging = true;
                if (this.onDragStart != null) {
                    this.onDragStart.start(mx, my, button);
                }
            }
            return clicked;
        }
        return false;
    }

    public boolean inArea(double mx, double my) {
        return mx > (double)this.m_252754_() && mx < (double)(this.m_252754_() + this.m_5711_()) && my > (double)this.m_252907_() && my < (double)(this.m_252907_() + this.m_93694_());
    }

    public EasyButton setPos(int x, int y) {
        super.m_264152_(x, y);
        return this;
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float p_281886_) {
        if (!this.f_93623_) {
            if (this.prevented) {
                guiGraphics.m_280246_(0.3f, 0.3f, 0.3f, 0.5f);
                super.m_88315_(guiGraphics, x, y, p_281886_);
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            return;
        }
        if (this.m_274382_() || this.dragging) {
            guiGraphics.m_280246_(0.0f, 1.0f, 1.0f, 0.5f);
        }
        super.m_88315_(guiGraphics, x, y, p_281886_);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static enum Mode {
        CLICK,
        DRAG;

    }

    public static interface OnDrag {
        public void drag(double var1, double var3, int var5, double var6, double var8);
    }

    public static interface OnDragStart {
        public void start(double var1, double var3, int var5);
    }

    public static interface OnDragEnd {
        public void end(double var1, double var3);
    }
}

