/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.utilsForShitOptifine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.shaders.Effect;
import com.mojang.blaze3d.shaders.EffectProgram;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class IOSafeEffectInstance
implements Effect,
AutoCloseable {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final AbstractUniform DUMMY_UNIFORM = new AbstractUniform();
    public static IOSafeEffectInstance lastAppliedEffect;
    public static int lastProgramId;
    public final Map<String, IntSupplier> samplerMap = Maps.newHashMap();
    public final List<String> samplerNames = Lists.newArrayList();
    public final List<Integer> samplerLocations = Lists.newArrayList();
    public final List<Uniform> uniforms = Lists.newArrayList();
    public final List<Integer> uniformLocations = Lists.newArrayList();
    public final Map<String, Uniform> uniformMap = Maps.newHashMap();
    public final int programId;
    public final String name;
    public boolean dirty;
    public final BlendMode blend;
    public final List<Integer> attributes;
    public final List<String> attributeNames;
    public final EffectProgram vertexProgram;
    public final EffectProgram fragmentProgram;

    public IOSafeEffectInstance(ResourceManager pResourceManager, String pName) throws IOException {
        ResourceLocation rl = ResourceLocation.m_135820_((String)pName);
        ResourceLocation resourcelocation = new ResourceLocation(rl.m_135827_(), "shaders/program/" + rl.m_135815_() + ".json");
        this.name = pName;
        Resource resource = pResourceManager.m_215593_(resourcelocation);
        try (BufferedReader reader = resource.m_215508_();){
            JsonArray jsonarray2;
            JsonArray jsonarray1;
            JsonObject jsonobject = GsonHelper.m_13859_((Reader)reader);
            String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"vertex");
            String s1 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"fragment");
            JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"samplers", (JsonArray)null);
            if (jsonarray != null) {
                int i = 0;
                for (Object jsonelement : jsonarray) {
                    try {
                        this.parseSamplerNode((JsonElement)jsonelement);
                    }
                    catch (Exception exception2) {
                        ChainedJsonException chainedjsonexception1 = ChainedJsonException.m_135906_((Exception)exception2);
                        chainedjsonexception1.m_135908_("samplers[" + i + "]");
                        throw chainedjsonexception1;
                    }
                    ++i;
                }
            }
            if ((jsonarray1 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"attributes", (JsonArray)null)) != null) {
                int j = 0;
                this.attributes = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                this.attributeNames = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                for (Iterator jsonelement1 : jsonarray1) {
                    try {
                        this.attributeNames.add(GsonHelper.m_13805_((JsonElement)jsonelement1, (String)"attribute"));
                    }
                    catch (Exception exception1) {
                        ChainedJsonException chainedjsonexception2 = ChainedJsonException.m_135906_((Exception)exception1);
                        chainedjsonexception2.m_135908_("attributes[" + j + "]");
                        throw chainedjsonexception2;
                    }
                    ++j;
                }
            } else {
                this.attributes = null;
                this.attributeNames = null;
            }
            if ((jsonarray2 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
                int k = 0;
                for (JsonElement jsonelement2 : jsonarray2) {
                    try {
                        this.parseUniformNode(jsonelement2);
                    }
                    catch (Exception exception) {
                        ChainedJsonException chainedjsonexception3 = ChainedJsonException.m_135906_((Exception)exception);
                        chainedjsonexception3.m_135908_("uniforms[" + k + "]");
                        throw chainedjsonexception3;
                    }
                    ++k;
                }
            }
            this.blend = IOSafeEffectInstance.parseBlendNode(GsonHelper.m_13841_((JsonObject)jsonobject, (String)"blend", (JsonObject)null));
            this.vertexProgram = IOSafeEffectInstance.getOrCreate(pResourceManager, Program.Type.VERTEX, s);
            this.fragmentProgram = IOSafeEffectInstance.getOrCreate(pResourceManager, Program.Type.FRAGMENT, s1);
            this.programId = ProgramManager.m_85577_();
            ProgramManager.m_166623_((Shader)this);
            this.updateLocations();
            if (this.attributeNames != null) {
                for (String s2 : this.attributeNames) {
                    int l = Uniform.m_85639_((int)this.programId, (CharSequence)s2);
                    this.attributes.add(l);
                }
            }
        }
        catch (Exception exception3) {
            ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception3);
            chainedjsonexception.m_135910_(resourcelocation.m_135815_() + " (" + resource.m_215506_() + ")");
            throw chainedjsonexception;
        }
        this.m_108957_();
    }

    public static EffectProgram getOrCreate(ResourceManager pResourceManager, Program.Type pProgramType, String pName) throws IOException {
        EffectProgram effectprogram;
        Program program = (Program)pProgramType.m_85570_().get(pName);
        if (program != null && !(program instanceof EffectProgram)) {
            throw new InvalidClassException("Program is not of type EffectProgram");
        }
        if (program == null) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)pName);
            ResourceLocation resourcelocation = new ResourceLocation(rl.m_135827_(), "shaders/program/" + rl.m_135815_() + pProgramType.m_85569_());
            Resource resource = pResourceManager.m_215593_(resourcelocation);
            try (InputStream inputstream = resource.m_215507_();){
                effectprogram = EffectProgram.m_166588_((Program.Type)pProgramType, (String)pName, (InputStream)inputstream, (String)resource.m_215506_());
            }
        } else {
            effectprogram = (EffectProgram)program;
        }
        return effectprogram;
    }

    public static BlendMode parseBlendNode(@Nullable JsonObject pJson) {
        if (pJson == null) {
            return new BlendMode();
        }
        int i = 32774;
        int j = 1;
        int k = 0;
        int l = 1;
        int i1 = 0;
        boolean flag = true;
        boolean flag1 = false;
        if (GsonHelper.m_13813_((JsonObject)pJson, (String)"func") && (i = BlendMode.m_85527_((String)pJson.get("func").getAsString())) != 32774) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)pJson, (String)"srcrgb") && (j = BlendMode.m_85530_((String)pJson.get("srcrgb").getAsString())) != 1) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)pJson, (String)"dstrgb") && (k = BlendMode.m_85530_((String)pJson.get("dstrgb").getAsString())) != 0) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)pJson, (String)"srcalpha")) {
            l = BlendMode.m_85530_((String)pJson.get("srcalpha").getAsString());
            if (l != 1) {
                flag = false;
            }
            flag1 = true;
        }
        if (GsonHelper.m_13813_((JsonObject)pJson, (String)"dstalpha")) {
            i1 = BlendMode.m_85530_((String)pJson.get("dstalpha").getAsString());
            if (i1 != 0) {
                flag = false;
            }
            flag1 = true;
        }
        if (flag) {
            return new BlendMode();
        }
        return flag1 ? new BlendMode(j, k, l, i1, i) : new BlendMode(j, k, i);
    }

    @Override
    public void close() {
        for (Uniform uniform : this.uniforms) {
            uniform.close();
        }
        ProgramManager.m_166621_((Shader)this);
    }

    public void clear() {
        RenderSystem.assertOnRenderThread();
        ProgramManager.m_85578_((int)0);
        lastProgramId = -1;
        lastAppliedEffect = null;
        for (int i = 0; i < this.samplerLocations.size(); ++i) {
            if (this.samplerMap.get(this.samplerNames.get(i)) == null) continue;
            GlStateManager._activeTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
        }
    }

    public void apply() {
        RenderSystem.assertOnGameThread();
        this.dirty = false;
        lastAppliedEffect = this;
        this.blend.m_85526_();
        if (this.programId != lastProgramId) {
            ProgramManager.m_85578_((int)this.programId);
            lastProgramId = this.programId;
        }
        for (int i = 0; i < this.samplerLocations.size(); ++i) {
            String s = this.samplerNames.get(i);
            IntSupplier intsupplier = this.samplerMap.get(s);
            if (intsupplier == null) continue;
            RenderSystem.activeTexture((int)(33984 + i));
            int j = intsupplier.getAsInt();
            if (j == -1) continue;
            RenderSystem.bindTexture((int)j);
            Uniform.m_85616_((int)this.samplerLocations.get(i), (int)i);
        }
        for (Uniform uniform : this.uniforms) {
            uniform.m_85633_();
        }
    }

    public void m_108957_() {
        this.dirty = true;
    }

    @Nullable
    public Uniform getUniform(String pName) {
        RenderSystem.assertOnRenderThread();
        return this.uniformMap.get(pName);
    }

    public AbstractUniform safeGetUniform(String pName) {
        RenderSystem.assertOnGameThread();
        Uniform uniform = this.getUniform(pName);
        return uniform == null ? DUMMY_UNIFORM : uniform;
    }

    private void updateLocations() {
        RenderSystem.assertOnRenderThread();
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < this.samplerNames.size(); ++i) {
            String s = this.samplerNames.get(i);
            int j = Uniform.m_85624_((int)this.programId, (CharSequence)s);
            if (j == -1) {
                LOGGER.warn("Shader {} could not find sampler named {} in the specified shader program.", (Object)this.name, (Object)s);
                this.samplerMap.remove(s);
                intlist.add(i);
                continue;
            }
            this.samplerLocations.add(j);
        }
        for (int l = intlist.size() - 1; l >= 0; --l) {
            this.samplerNames.remove(intlist.getInt(l));
        }
        for (Uniform uniform : this.uniforms) {
            String s1 = uniform.m_85599_();
            int k = Uniform.m_85624_((int)this.programId, (CharSequence)s1);
            if (k == -1) {
                LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.name, (Object)s1);
                continue;
            }
            this.uniformLocations.add(k);
            uniform.m_85614_(k);
            this.uniformMap.put(s1, uniform);
        }
    }

    private void parseSamplerNode(JsonElement pJson) {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"sampler");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        if (!GsonHelper.m_13813_((JsonObject)jsonobject, (String)"file")) {
            this.samplerMap.put(s, null);
            this.samplerNames.add(s);
        } else {
            this.samplerNames.add(s);
        }
    }

    public void setSampler(String pName, IntSupplier pTextureId) {
        if (this.samplerMap.containsKey(pName)) {
            this.samplerMap.remove(pName);
        }
        this.samplerMap.put(pName, pTextureId);
        this.m_108957_();
    }

    private void parseUniformNode(JsonElement pJson) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"uniform");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        int i = Uniform.m_85629_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type"));
        int j = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = GsonHelper.m_13888_((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception);
                chainedjsonexception.m_135908_("values[" + k + "]");
                throw chainedjsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        Uniform uniform = new Uniform(s, i + l, j, (Shader)this);
        if (i <= 3) {
            uniform.m_7401_((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i <= 7) {
            uniform.m_5808_(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            uniform.m_5941_(afloat);
        }
        this.uniforms.add(uniform);
    }

    public Program m_108962_() {
        return this.vertexProgram;
    }

    public Program m_108964_() {
        return this.fragmentProgram;
    }

    public void m_142662_() {
        this.fragmentProgram.m_166586_((Effect)this);
        this.vertexProgram.m_166586_((Effect)this);
    }

    public String getName() {
        return this.name;
    }

    public int m_108943_() {
        return this.programId;
    }

    static {
        lastProgramId = -1;
    }
}

