/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.utilsForShitOptifine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import sheridan.gunscraft.utilsForShitOptifine.PostPass;

@OnlyIn(value=Dist.CLIENT)
public class PostChain
implements AutoCloseable {
    public final RenderTarget screenTarget;
    public final ResourceManager resourceManager;
    public final String name;
    public final List<PostPass> passes = Lists.newArrayList();
    public final Map<String, RenderTarget> customRenderTargets = Maps.newHashMap();
    public final List<RenderTarget> fullSizedTargets = Lists.newArrayList();
    public Matrix4f shaderOrthoMatrix;
    public int screenWidth;
    public int screenHeight;
    public float time;
    public float lastStamp;

    public PostChain(TextureManager pTextureManager, ResourceManager pResourceManager, RenderTarget pScreenTarget, ResourceLocation pName) throws IOException, JsonSyntaxException {
        this.resourceManager = pResourceManager;
        this.screenTarget = pScreenTarget;
        this.time = 0.0f;
        this.lastStamp = 0.0f;
        this.screenWidth = pScreenTarget.f_83917_;
        this.screenHeight = pScreenTarget.f_83918_;
        this.name = pName.toString();
        this.updateOrthoMatrix();
        this.load(pTextureManager, pName);
    }

    private void load(TextureManager pTextureManager, ResourceLocation pResourceLocation) throws IOException, JsonSyntaxException {
        block15: {
            Resource resource = this.resourceManager.m_215593_(pResourceLocation);
            try (BufferedReader reader = resource.m_215508_();){
                JsonObject jsonobject = GsonHelper.m_13859_((Reader)reader);
                if (GsonHelper.m_13885_((JsonObject)jsonobject, (String)"targets")) {
                    JsonArray jsonarray = jsonobject.getAsJsonArray("targets");
                    int i = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        try {
                            this.parseTargetNode(jsonelement);
                        }
                        catch (Exception exception1) {
                            ChainedJsonException chainedjsonexception1 = ChainedJsonException.m_135906_((Exception)exception1);
                            chainedjsonexception1.m_135908_("targets[" + i + "]");
                            throw chainedjsonexception1;
                        }
                        ++i;
                    }
                }
                if (!GsonHelper.m_13885_((JsonObject)jsonobject, (String)"passes")) break block15;
                JsonArray jsonarray1 = jsonobject.getAsJsonArray("passes");
                int j = 0;
                for (JsonElement jsonelement1 : jsonarray1) {
                    try {
                        this.parsePassNode(pTextureManager, jsonelement1);
                    }
                    catch (Exception exception) {
                        ChainedJsonException chainedjsonexception2 = ChainedJsonException.m_135906_((Exception)exception);
                        chainedjsonexception2.m_135908_("passes[" + j + "]");
                        throw chainedjsonexception2;
                    }
                    ++j;
                }
            }
            catch (Exception exception2) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception2);
                chainedjsonexception.m_135910_(pResourceLocation.m_135815_() + " (" + resource.m_215506_() + ")");
                throw chainedjsonexception;
            }
        }
    }

    private void parseTargetNode(JsonElement pJson) throws ChainedJsonException {
        if (GsonHelper.m_13803_((JsonElement)pJson)) {
            this.addTempTarget(pJson.getAsString(), this.screenWidth, this.screenHeight);
        } else {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"target");
            String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
            int i = GsonHelper.m_13824_((JsonObject)jsonobject, (String)"width", (int)this.screenWidth);
            int j = GsonHelper.m_13824_((JsonObject)jsonobject, (String)"height", (int)this.screenHeight);
            if (this.customRenderTargets.containsKey(s)) {
                throw new ChainedJsonException(s + " is already defined");
            }
            this.addTempTarget(s, i, j);
        }
    }

    private void parsePassNode(TextureManager pTextureManager, JsonElement pJson) throws IOException {
        JsonArray jsonarray1;
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"pass");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        String s1 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"intarget");
        String s2 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"outtarget");
        RenderTarget rendertarget = this.getRenderTarget(s1);
        RenderTarget rendertarget1 = this.getRenderTarget(s2);
        if (rendertarget == null) {
            throw new ChainedJsonException("Input target '" + s1 + "' does not exist");
        }
        if (rendertarget1 == null) {
            throw new ChainedJsonException("Output target '" + s2 + "' does not exist");
        }
        PostPass postpass = this.addPass(s, rendertarget, rendertarget1);
        JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"auxtargets", (JsonArray)null);
        if (jsonarray != null) {
            int i = 0;
            for (JsonElement jsonelement : jsonarray) {
                try {
                    String s4;
                    boolean flag;
                    JsonObject jsonobject1 = GsonHelper.m_13918_((JsonElement)jsonelement, (String)"auxtarget");
                    String s5 = GsonHelper.m_13906_((JsonObject)jsonobject1, (String)"name");
                    String s3 = GsonHelper.m_13906_((JsonObject)jsonobject1, (String)"id");
                    if (s3.endsWith(":depth")) {
                        flag = true;
                        s4 = s3.substring(0, s3.lastIndexOf(58));
                    } else {
                        flag = false;
                        s4 = s3;
                    }
                    RenderTarget rendertarget2 = this.getRenderTarget(s4);
                    if (rendertarget2 == null) {
                        if (flag) {
                            throw new ChainedJsonException("Render target '" + s4 + "' can't be used as depth buffer");
                        }
                        ResourceLocation rl = ResourceLocation.m_135820_((String)s4);
                        ResourceLocation resourcelocation = new ResourceLocation(rl.m_135827_(), "textures/effect/" + rl.m_135815_() + ".png");
                        this.resourceManager.m_213713_(resourcelocation).orElseThrow(() -> new ChainedJsonException("Render target or texture '" + s4 + "' does not exist"));
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourcelocation);
                        pTextureManager.m_174784_(resourcelocation);
                        AbstractTexture abstracttexture = pTextureManager.m_118506_(resourcelocation);
                        int j = GsonHelper.m_13927_((JsonObject)jsonobject1, (String)"width");
                        int k = GsonHelper.m_13927_((JsonObject)jsonobject1, (String)"height");
                        boolean flag1 = GsonHelper.m_13912_((JsonObject)jsonobject1, (String)"bilinear");
                        if (flag1) {
                            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
                            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
                        } else {
                            RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
                            RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
                        }
                        postpass.addAuxAsset(s5, () -> ((AbstractTexture)abstracttexture).m_117963_(), j, k);
                    } else if (flag) {
                        postpass.addAuxAsset(s5, () -> ((RenderTarget)rendertarget2).m_83980_(), rendertarget2.f_83915_, rendertarget2.f_83916_);
                    } else {
                        postpass.addAuxAsset(s5, () -> ((RenderTarget)rendertarget2).m_83975_(), rendertarget2.f_83915_, rendertarget2.f_83916_);
                    }
                }
                catch (Exception exception1) {
                    ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception1);
                    chainedjsonexception.m_135908_("auxtargets[" + i + "]");
                    throw chainedjsonexception;
                }
                ++i;
            }
        }
        if ((jsonarray1 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
            int l = 0;
            for (JsonElement jsonelement1 : jsonarray1) {
                try {
                    this.parseUniformNode(jsonelement1);
                }
                catch (Exception exception) {
                    ChainedJsonException chainedjsonexception1 = ChainedJsonException.m_135906_((Exception)exception);
                    chainedjsonexception1.m_135908_("uniforms[" + l + "]");
                    throw chainedjsonexception1;
                }
                ++l;
            }
        }
    }

    private void parseUniformNode(JsonElement pJson) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"uniform");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        Uniform uniform = this.passes.get(this.passes.size() - 1).getEffect().getUniform(s);
        if (uniform == null) {
            throw new ChainedJsonException("Uniform '" + s + "' does not exist");
        }
        float[] afloat = new float[4];
        int i = 0;
        for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)jsonobject, (String)"values")) {
            try {
                afloat[i] = GsonHelper.m_13888_((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception);
                chainedjsonexception.m_135908_("values[" + i + "]");
                throw chainedjsonexception;
            }
            ++i;
        }
        switch (i) {
            case 0: 
            case 1: {
                uniform.m_5985_(afloat[0]);
                break;
            }
            case 2: {
                uniform.m_7971_(afloat[0], afloat[1]);
                break;
            }
            case 3: {
                uniform.m_5889_(afloat[0], afloat[1], afloat[2]);
                break;
            }
            case 4: {
                uniform.m_5805_(afloat[0], afloat[1], afloat[2], afloat[3]);
            }
        }
    }

    public RenderTarget getTempTarget(String pAttributeName) {
        return this.customRenderTargets.get(pAttributeName);
    }

    public void addTempTarget(String pName, int pWidth, int pHeight) {
        TextureTarget rendertarget = new TextureTarget(pWidth, pHeight, true, Minecraft.f_91002_);
        rendertarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        if (this.screenTarget.isStencilEnabled()) {
            rendertarget.enableStencil();
        }
        this.customRenderTargets.put(pName, (RenderTarget)rendertarget);
        if (pWidth == this.screenWidth && pHeight == this.screenHeight) {
            this.fullSizedTargets.add((RenderTarget)rendertarget);
        }
    }

    @Override
    public void close() {
        for (RenderTarget rendertarget : this.customRenderTargets.values()) {
            rendertarget.m_83930_();
        }
        for (PostPass postpass : this.passes) {
            postpass.close();
        }
        this.passes.clear();
    }

    public PostPass addPass(String pProgramName, RenderTarget pFramebuffer, RenderTarget pFramebufferOut) throws IOException {
        PostPass postpass = new PostPass(this.resourceManager, pProgramName, pFramebuffer, pFramebufferOut);
        this.passes.add(this.passes.size(), postpass);
        return postpass;
    }

    private void updateOrthoMatrix() {
        this.shaderOrthoMatrix = new Matrix4f().setOrtho(0.0f, (float)this.screenTarget.f_83915_, 0.0f, (float)this.screenTarget.f_83916_, 0.1f, 1000.0f);
    }

    public void resize(int pWidth, int pHeight) {
        this.screenWidth = this.screenTarget.f_83915_;
        this.screenHeight = this.screenTarget.f_83916_;
        this.updateOrthoMatrix();
        for (PostPass postpass : this.passes) {
            postpass.setOrthoMatrix(this.shaderOrthoMatrix);
        }
        for (RenderTarget rendertarget : this.fullSizedTargets) {
            rendertarget.m_83941_(pWidth, pHeight, Minecraft.f_91002_);
        }
    }

    public void process(float pPartialTicks) {
        if (pPartialTicks < this.lastStamp) {
            this.time += 1.0f - this.lastStamp;
            this.time += pPartialTicks;
        } else {
            this.time += pPartialTicks - this.lastStamp;
        }
        for (PostPass postpass : this.passes) {
            postpass.process(this.time / 20.0f);
        }
    }

    public final String getName() {
        return this.name;
    }

    @Nullable
    private RenderTarget getRenderTarget(@Nullable String pTarget) {
        if (pTarget == null) {
            return null;
        }
        return pTarget.equals("minecraft:main") ? this.screenTarget : this.customRenderTargets.get(pTarget);
    }
}

