#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D DiffuseDepthSampler;

uniform mat4 ProjMat;
uniform vec2 OutSize;
uniform float fov;
uniform float currentFov;
uniform float MaxDistance;
uniform float Strength;
uniform float MaxDistanceOff;
uniform float StrengthOff;
uniform float minDepth;
uniform float aspectRatio;
uniform float offsetX;
uniform float offsetY;
uniform float offsetXOff;
uniform float offsetYOff;
uniform int mainHandLight;
uniform int offHandLight;

in vec2 texCoord;
out vec4 fragColor;

float near = 0.1;
float far = 1000.0;

void main(){
    float originalDepth = texture(DiffuseDepthSampler, texCoord).r;
    float depth = (near * far) / (far + near - (originalDepth * 2.0 - 1.0) * (far - near));
    float distanceToCamera = length(vec3(1.0, (2.0 * texCoord - 1.0) * tan(radians(currentFov * 0.5))) * depth);
    float range = currentFov / fov;
    if (originalDepth < minDepth) {
        fragColor = vec4(texture(DiffuseSampler, texCoord).rgb, 1);
    } else {
        float d1 = 0;
        float d2 = 0;
        if (mainHandLight == 1) {
            vec2 uv = texCoord;
            uv.x += offsetX;
            uv.y += offsetY;
            float power = 5 * Strength;
            d1 = aspectRatio <= 1 ?
            sqrt(pow((uv.x - 0.5), 2.0) + pow((uv.y * aspectRatio - 0.5 * aspectRatio), 2.0)) :
            sqrt(pow((uv.x * aspectRatio  - 0.5 * aspectRatio), 2.0) + pow((uv.y - 0.5), 2.0));
            d1 = exp(-(d1 * 35 * range)) * power / (distanceToCamera * 0.05);
        }
        if (offHandLight == 1) {
            vec2 uv = texCoord;
            uv.x += offsetXOff;
            uv.y += offsetYOff;
            float power = 5 * StrengthOff;
            d2 = aspectRatio <= 1 ?
            sqrt(pow((uv.x - 0.5), 2.0) + pow((uv.y * aspectRatio - 0.5 * aspectRatio), 2.0)) :
            sqrt(pow((uv.x * aspectRatio  - 0.5 * aspectRatio), 2.0) + pow((uv.y - 0.5), 2.0));
            d2 = exp(-(d2 * 35 * range)) * power / (distanceToCamera * 0.05);
        }
        float maxRange = MaxDistance > MaxDistanceOff ? MaxDistance : MaxDistanceOff;
        float dis = clamp((maxRange - distanceToCamera) / maxRange, 0.0, 1.0);
        fragColor = vec4(texture(DiffuseSampler, texCoord).rgb * clamp(1 + (d1 + d2) * dis, 0.0, 7.5), 1);
    }
}