/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block;

import com.modernmissions.block.entity.LaunchControllerBlockEntity;
import com.modernmissions.block.entity.LaunchPadBlockEntity;
import com.modernmissions.explosion.NuclearExplosionManager;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModBlocks;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.S2COpenAuthScreenPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class LaunchControllerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty ACTIVATED = BooleanProperty.m_61465_((String)"activated");
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");

    public LaunchControllerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(5.0f).m_60999_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof LaunchControllerBlockEntity) {
            LaunchControllerBlockEntity controller = (LaunchControllerBlockEntity)blockEntity;
            if (!this.checkLaunchPadConnection(level, pos, state)) {
                player.m_213846_((Component)Component.m_237113_((String)"Controller not connected to launch pad!").m_130940_(ChatFormatting.RED));
                return InteractionResult.CONSUME;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!controller.hasPasscode()) {
                    if (controller.isOwner(player)) {
                        S2COpenAuthScreenPacket packet = new S2COpenAuthScreenPacket(pos, true, controller.getOwnerName(), 0, 0L);
                        ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)("Only the owner (" + controller.getOwnerName() + ") can set the passcode!")).m_130940_(ChatFormatting.RED));
                    }
                } else if (controller.isAuthenticated()) {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)controller, (BlockPos)pos);
                } else {
                    S2COpenAuthScreenPacket packet = new S2COpenAuthScreenPacket(pos, false, controller.getOwnerName(), controller.getFailedAttempts(), controller.getRemainingLockoutTime());
                    ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private boolean checkLaunchPadConnection(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction backDirection = facing.m_122424_();
        BlockPos checkPos = pos.m_121945_(backDirection);
        BlockState behindState = level.m_8055_(checkPos);
        boolean isConnected = behindState.m_60713_((Block)ModBlocks.LAUNCH_PAD.get());
        if (isConnected != (Boolean)state.m_61143_((Property)CONNECTED)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(isConnected)), 3);
        }
        return isConnected;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_ && placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof LaunchControllerBlockEntity) {
                LaunchControllerBlockEntity controller = (LaunchControllerBlockEntity)blockEntity;
                controller.setOwner(player);
            }
            this.checkLaunchPadConnection(level, pos, state);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_) {
            this.checkLaunchPadConnection(level, pos, state);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_) {
            this.checkLaunchPadConnection(level, pos, state);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ACTIVATED, CONNECTED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LaunchControllerBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : LaunchControllerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.LAUNCH_CONTROLLER.get()), (level1, pos, state1, blockEntity) -> blockEntity.tick());
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            if (NuclearExplosionManager.isNuclearExplosion(explosion)) {
                super.onBlockExploded(state, level, pos, explosion);
                return;
            }
            boolean hasActiveMissile = false;
            String missileType = "nuclear";
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            Direction backDirection = facing.m_122424_();
            BlockPos launchPadPos = pos.m_121945_(backDirection);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    LaunchPadBlockEntity launchPad;
                    BlockPos checkPos = launchPadPos.m_7918_(dx, 0, dz);
                    BlockEntity be = level.m_7702_(checkPos);
                    if (!(be instanceof LaunchPadBlockEntity) || !(launchPad = (LaunchPadBlockEntity)be).hasMissile()) continue;
                    hasActiveMissile = true;
                    missileType = launchPad.getMissileType();
                    break;
                }
                if (hasActiveMissile) break;
            }
            System.out.println("Launch controller hit by explosion at " + pos);
            System.out.println("Has connected missile: " + hasActiveMissile + " of type: " + missileType);
            if (hasActiveMissile) {
                if ("chemical".equals(missileType)) {
                    NuclearExplosionManager.triggerChemicalExplosion(level, launchPadPos);
                } else {
                    NuclearExplosionManager.triggerNuclearExplosion(level, launchPadPos, true);
                }
            }
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        LaunchControllerBlockEntity controller;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof LaunchControllerBlockEntity && !(controller = (LaunchControllerBlockEntity)blockEntity).isOwner(player) && !player.m_7500_()) {
            player.m_213846_((Component)Component.m_237113_((String)("Only the owner (" + controller.getOwnerName() + ") can break this Launch Controller!")).m_130940_(ChatFormatting.RED));
            return;
        }
        super.m_5707_(level, pos, state, player);
    }
}

