/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block;

import com.modernmissions.block.entity.LaunchPadBlockEntity;
import com.modernmissions.explosion.NuclearExplosionManager;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModBlocks;
import com.modernmissions.init.ModItems;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaunchPadBlock
extends BaseEntityBlock {
    public static final IntegerProperty PART = IntegerProperty.m_61631_((String)"part", (int)0, (int)8);
    public static final BooleanProperty HAS_MISSILE = BooleanProperty.m_61465_((String)"has_missile");
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private static final VoxelShape SHAPE_WITH_MISSILE = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125));

    public LaunchPadBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60999_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PART, (Comparable)Integer.valueOf(4))).m_61124_((Property)HAS_MISSILE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, HAS_MISSILE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)PART) == 4) {
            return new LaunchPadBlockEntity(pos, state);
        }
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return (Integer)state.m_61143_((Property)PART) == 4 ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)PART) == 4 && ((Boolean)state.m_61143_((Property)HAS_MISSILE)).booleanValue()) {
            return SHAPE_WITH_MISSILE;
        }
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            ItemStack heldItem = player.m_21120_(hand);
            BlockPos center = this.findPadCenter(level, pos);
            if (center != null) {
                BlockEntity centerEntity = level.m_7702_(center);
                if (heldItem.m_150930_((Item)ModItems.NUCLEAR_MISSILE.get()) || heldItem.m_150930_((Item)ModItems.CHEMICAL_GAS_BOMB.get())) {
                    if (centerEntity == null) {
                        player.m_5661_((Component)Component.m_237113_((String)"No block entity at center! Fixing...").m_130940_(ChatFormatting.YELLOW), false);
                        BlockState centerState = level.m_8055_(center);
                        if (centerState.m_60734_() instanceof LaunchPadBlock) {
                            BlockState newCenterState = (BlockState)centerState.m_61124_((Property)PART, (Comparable)Integer.valueOf(4));
                            level.m_7731_(center, newCenterState, 3);
                            centerEntity = level.m_7702_(center);
                            if (centerEntity != null) {
                                player.m_5661_((Component)Component.m_237113_((String)"Launch pad fixed! Try again.").m_130940_(ChatFormatting.GREEN), false);
                            } else {
                                player.m_5661_((Component)Component.m_237113_((String)"Failed to fix launch pad.").m_130940_(ChatFormatting.RED), false);
                                return InteractionResult.FAIL;
                            }
                        }
                    }
                    if (centerEntity instanceof LaunchPadBlockEntity) {
                        LaunchPadBlockEntity launchPad = (LaunchPadBlockEntity)centerEntity;
                        if (!launchPad.hasMissile()) {
                            BlockState currentState = level.m_8055_(center);
                            BlockState newState = (BlockState)currentState.m_61124_((Property)HAS_MISSILE, (Comparable)Boolean.valueOf(true));
                            level.m_7731_(center, newState, 3);
                            System.out.println("Setting missile state to true for launch pad at " + center);
                            launchPad.setHasMissile(true);
                            if (heldItem.m_150930_((Item)ModItems.CHEMICAL_GAS_BOMB.get())) {
                                launchPad.setMissileType("chemical");
                                player.m_5661_((Component)Component.m_237113_((String)"Chemical Gas Bomb Armed").m_130940_(ChatFormatting.GREEN), true);
                            } else {
                                launchPad.setMissileType("nuclear");
                                player.m_5661_((Component)Component.m_237113_((String)"Nuclear Missile Armed").m_130940_(ChatFormatting.RED), true);
                            }
                            System.out.println("Launch pad now has missile: " + launchPad.hasMissile() + " of type: " + launchPad.getMissileType());
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            level.m_5594_(null, center, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 0.8f);
                            level.m_5594_(null, center, SoundEvents.f_11739_, SoundSource.BLOCKS, 1.0f, 1.2f);
                            return InteractionResult.SUCCESS;
                        }
                        player.m_5661_((Component)Component.m_237113_((String)"Launch pad already has a missile").m_130940_(ChatFormatting.YELLOW), true);
                    }
                } else {
                    if (centerEntity instanceof LaunchPadBlockEntity) {
                        LaunchPadBlockEntity launchPad = (LaunchPadBlockEntity)centerEntity;
                        if (launchPad.hasMissile()) {
                            player.m_5661_((Component)Component.m_237113_((String)"Nuclear Launch Pad Armed").m_130940_(ChatFormatting.RED), true);
                        } else {
                            player.m_5661_((Component)Component.m_237113_((String)"Nuclear Launch Pad Ready").m_130940_(ChatFormatting.GREEN), true);
                        }
                    }
                    level.m_5594_(null, center, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private BlockPos findPadCenter(Level level, BlockPos pos) {
        for (int dx = -2; dx <= 0; ++dx) {
            for (int dz = -2; dz <= 0; ++dz) {
                BlockPos corner = pos.m_7918_(dx, 0, dz);
                if (!this.isComplete3x3Pad(level, corner)) continue;
                return corner.m_7918_(1, 0, 1);
            }
        }
        return null;
    }

    private boolean isComplete3x3Pad(Level level, BlockPos corner) {
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                BlockPos checkPos = corner.m_7918_(x, 0, z);
                if (level.m_8055_(checkPos).m_60734_() instanceof LaunchPadBlock) continue;
                return false;
            }
        }
        return true;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !level.m_5776_()) {
            BlockPos missilePos;
            BlockPos center = this.findPadCenter(level, pos);
            if (center != null && level.m_8055_(missilePos = center.m_7494_()).m_60713_((Block)ModBlocks.NUCLEAR_MISSILE.get())) {
                level.m_7471_(missilePos, true);
            }
            this.breakConnectedPads(level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private void breakConnectedPads(Level level, BlockPos pos) {
        BlockState centerState;
        BlockPos center = this.findPadCenter(level, pos);
        boolean shouldDrop = false;
        if (center != null && (centerState = level.m_8055_(center)).m_60734_() instanceof LaunchPadBlock && (shouldDrop = true) && !level.m_5776_()) {
            int amount = 3 + level.f_46441_.m_188503_(7);
            Block.m_49840_((Level)level, (BlockPos)center, (ItemStack)new ItemStack((ItemLike)Items.f_42151_, amount));
        }
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos checkPos = pos.m_7918_(dx, 0, dz);
                BlockState checkState = level.m_8055_(checkPos);
                if (!(checkState.m_60734_() instanceof LaunchPadBlock)) continue;
                level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    public static boolean tryFormLaunchPad(Level level, BlockPos pos) {
        for (int dx = 0; dx >= -2; --dx) {
            for (int dz = 0; dz >= -2; --dz) {
                BlockPos corner = pos.m_7918_(dx, 0, dz);
                if (!LaunchPadBlock.checkAndForm3x3(level, corner)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkAndForm3x3(Level level, BlockPos corner) {
        int z;
        int x;
        for (x = 0; x < 3; ++x) {
            for (z = 0; z < 3; ++z) {
                BlockPos checkPos = corner.m_7918_(x, 0, z);
                BlockState checkState = level.m_8055_(checkPos);
                if (checkState.m_60713_(Blocks.f_50327_)) continue;
                return false;
            }
        }
        for (x = 0; x < 3; ++x) {
            for (z = 0; z < 3; ++z) {
                BlockPos replacePos = corner.m_7918_(x, 0, z);
                int part = x + z * 3;
                BlockState padState = (BlockState)((Block)ModBlocks.LAUNCH_PAD.get()).m_49966_().m_61124_((Property)PART, (Comparable)Integer.valueOf(part));
                level.m_7731_(replacePos, padState, 3);
            }
        }
        BlockPos center = corner.m_7918_(1, 0, 1);
        level.m_5594_(null, center, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_5594_(null, center, SoundEvents.f_11739_, SoundSource.BLOCKS, 1.0f, 1.2f);
        return true;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return LaunchPadBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.LAUNCH_PAD.get()), (level1, pos, state1, blockEntity) -> blockEntity.tick());
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            if (NuclearExplosionManager.isNuclearExplosion(explosion)) {
                super.onBlockExploded(state, level, pos, explosion);
                return;
            }
            BlockPos center = this.findPadCenter(level, pos);
            if (center != null) {
                BlockEntity blockEntity = level.m_7702_(center);
                boolean hasActiveMissile = false;
                String missileType = "nuclear";
                if (blockEntity instanceof LaunchPadBlockEntity) {
                    LaunchPadBlockEntity launchPad = (LaunchPadBlockEntity)blockEntity;
                    hasActiveMissile = launchPad.hasMissile();
                    missileType = launchPad.getMissileType();
                    System.out.println("Launch pad hit by explosion at " + pos);
                    System.out.println("Has active missile: " + hasActiveMissile + " of type: " + missileType);
                }
                if (hasActiveMissile) {
                    if ("chemical".equals(missileType)) {
                        NuclearExplosionManager.triggerChemicalExplosion(level, center);
                    } else {
                        NuclearExplosionManager.triggerNuclearExplosion(level, center, true);
                    }
                }
            }
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        LaunchPadBlockEntity launchPad;
        BlockEntity blockEntity;
        BlockPos center;
        if (!level.f_46443_ && (center = this.findPadCenter(level, pos)) != null && (blockEntity = level.m_7702_(center)) instanceof LaunchPadBlockEntity && (launchPad = (LaunchPadBlockEntity)blockEntity).hasMissile()) {
            player.m_213846_((Component)Component.m_237113_((String)"Cannot break Launch Pad with armed missile! Remove or launch the missile first.").m_130940_(ChatFormatting.RED));
            return;
        }
        super.m_5707_(level, pos, state, player);
    }
}

