/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block;

import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.util.ReactorMultiblock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class NuclearControllerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public NuclearControllerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(3.5f).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            this.checkAndFormMultiblock(level, pos, state);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof NuclearControllerBlockEntity) {
                NuclearControllerBlockEntity controller = (NuclearControllerBlockEntity)blockEntity;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)controller, (BlockPos)pos);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void checkAndFormMultiblock(Level level, BlockPos pos, BlockState state) {
        this.checkAndFormMultiblock(level, pos, state, null);
    }

    public void checkAndFormMultiblock(Level level, BlockPos pos, BlockState state, Player player) {
        boolean isFormed;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean currentlyActive = (Boolean)state.m_61143_((Property)ACTIVE);
        boolean bl = isFormed = player != null ? ReactorMultiblock.isFormedWithDebug(level, pos, facing, player) : ReactorMultiblock.isFormed(level, pos, facing);
        if (!isFormed && currentlyActive) {
            ReactorMultiblock.deactivate(level, pos, facing);
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"Reactor deactivated!").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_) {
            this.checkAndFormMultiblock(level, pos, state);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_) {
            this.checkAndFormMultiblock(level, pos, state);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                ReactorMultiblock.deactivate(level, pos, (Direction)state.m_61143_((Property)FACING));
            }
            if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof NuclearControllerBlockEntity) {
                NuclearControllerBlockEntity controller = (NuclearControllerBlockEntity)blockEntity;
                controller.drops();
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ACTIVE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new NuclearControllerBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : NuclearControllerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.NUCLEAR_CONTROLLER.get()), NuclearControllerBlockEntity::serverTick);
    }
}

