/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block;

import com.modernmissions.config.CommonConfig;
import com.modernmissions.init.ModFluids;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PurifiedWaterSourceBlock
extends LiquidBlock {
    public PurifiedWaterSourceBlock() {
        super(() -> (FlowingFluid)ModFluids.PURIFIED_WATER_SOURCE.get(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60913_(-1.0f, 3600000.0f).m_222994_().m_278166_(PushReaction.BLOCK).m_60977_().m_60910_().m_60955_());
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return player.m_7500_() ? super.m_5880_(state, player, level, pos) : 0.0f;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(2) == 0) {
            this.createBubblingEffect(level, pos, random);
        }
        int interval = Math.max(1, (Integer)CommonConfig.PURIFIED_WATER_GROWTH_RATE.get());
        level.m_186460_(pos, (Block)this, interval);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.m_5776_()) {
            int interval = Math.max(1, (Integer)CommonConfig.PURIFIED_WATER_GROWTH_RATE.get());
            level.m_186460_(pos, (Block)this, interval);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188501_() < 0.3f) {
            this.spawnWaterNearby(level, pos, random);
        }
        int interval = Math.max(1, (Integer)CommonConfig.PURIFIED_WATER_GROWTH_RATE.get());
        level.m_186460_(pos, (Block)this, interval);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(8) == 0) {
            double x = (double)pos.m_123341_() + 0.2 + random.m_188500_() * 0.6;
            double y = (double)pos.m_123342_() + 0.9 + random.m_188500_() * 0.1;
            double z = (double)pos.m_123343_() + 0.2 + random.m_188500_() * 0.6;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 0.0, 0.03, 0.0);
            if (random.m_188503_(4) == 0) {
                level.m_7785_(x, y, z, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.1f, 1.0f + random.m_188501_() * 0.2f, false);
            }
        }
    }

    private void spawnWaterNearby(ServerLevel level, BlockPos sourcePos, RandomSource random) {
        int blocksToSpawn = 1;
        ArrayList<BlockPos> eligible = new ArrayList<BlockPos>();
        ForgeFlowingFluid.Source waterSource = (ForgeFlowingFluid.Source)ModFluids.PURIFIED_WATER_SOURCE.get();
        ForgeFlowingFluid.Flowing waterFlowing = (ForgeFlowingFluid.Flowing)ModFluids.PURIFIED_WATER_FLOWING.get();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockState s;
                BlockPos p;
                Fluid existing;
                if (dx == 0 && dz == 0 || (existing = level.m_6425_(p = sourcePos.m_7918_(dx, 0, dz)).m_76152_()) == waterSource || existing == waterFlowing || !(s = level.m_8055_(p)).m_60795_() && !s.m_247087_() && !s.m_60713_(Blocks.f_50359_) && !s.m_60713_(Blocks.f_50034_) && !s.m_60713_(Blocks.f_50440_) && !s.m_60713_(Blocks.f_50493_) && !s.m_60713_(Blocks.f_50546_) && !s.m_60713_(Blocks.f_49992_) && !s.m_60713_(Blocks.f_49994_) && !s.m_60713_(Blocks.f_50129_)) continue;
                eligible.add(p);
            }
        }
        if (eligible.isEmpty()) {
            return;
        }
        ForgeFlowingFluid.Source fluid = waterSource;
        FluidState fluidState = waterSource.m_76145_();
        int toPlace = Math.min(blocksToSpawn, eligible.size());
        for (int i = 0; i < toPlace; ++i) {
            int idx = random.m_188503_(eligible.size());
            BlockPos targetPos = (BlockPos)eligible.remove(idx);
            level.m_7731_(targetPos, fluidState.m_76188_(), 3);
            level.m_186469_(targetPos, (Fluid)fluid, 1);
        }
    }

    private void createBubblingEffect(ServerLevel level, BlockPos pos, RandomSource random) {
        double x = (double)pos.m_123341_() + 0.3 + random.m_188500_() * 0.4;
        double y = (double)pos.m_123342_() + 0.95;
        double z = (double)pos.m_123343_() + 0.3 + random.m_188500_() * 0.4;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 1, 0.0, 0.02, 0.0, 0.0);
    }
}

