/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block;

import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.init.ModBlocks;
import com.modernmissions.util.ReactorMultiblock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class ReactorCasingBlock
extends Block {
    public ReactorCasingBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            BlockPos controllerPos = this.findNearbyController(level, pos);
            if (controllerPos != null) {
                BlockState controllerState = level.m_8055_(controllerPos);
                if (controllerState.m_61138_((Property)NuclearControllerBlock.FACING)) {
                    Direction controllerFacing = (Direction)controllerState.m_61143_((Property)NuclearControllerBlock.FACING);
                    boolean isFormed = ReactorMultiblock.isFormedWithDebug(level, controllerPos, controllerFacing, player);
                    if (isFormed) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u2713 Reactor structure is complete!").m_130940_(ChatFormatting.GREEN));
                    }
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Controller found but has no facing property").m_130940_(ChatFormatting.YELLOW));
                }
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"No Nuclear Controller found within 5 blocks").m_130940_(ChatFormatting.YELLOW));
                player.m_213846_((Component)Component.m_237113_((String)"Place a Nuclear Controller to start building the reactor").m_130940_(ChatFormatting.GRAY));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private BlockPos findNearbyController(Level level, BlockPos pos) {
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    if (!level.m_8055_(checkPos).m_60713_((Block)ModBlocks.NUCLEAR_CONTROLLER.get())) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }
}

