/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.block.LaunchControllerBlock;
import com.modernmissions.block.LaunchPadBlock;
import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.entity.LaunchPadBlockEntity;
import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModBlocks;
import com.modernmissions.init.ModSounds;
import com.modernmissions.menu.LaunchControllerMenu;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LaunchControllerBlockEntity
extends BlockEntity
implements MenuProvider {
    private int targetX = 0;
    private int targetZ = 0;
    private String launchCode = "";
    private boolean armed = false;
    private int cooldownTicks = 0;
    private String passcode = "";
    private UUID ownerId = null;
    private String ownerName = "";
    private boolean isLocked = false;
    private int failedAttempts = 0;
    private long lockoutEndTime = 0L;
    private boolean authenticated = false;
    private BlockPos linkedReactorPos = null;
    private boolean isPoweredByReactor = false;
    private static final int MAX_FAILED_ATTEMPTS = 3;
    private static final int LOCKOUT_DURATION = 1200;
    private static final int LAUNCH_COOLDOWN = 600;

    public LaunchControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LAUNCH_CONTROLLER.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Missile Launch Controller");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new LaunchControllerMenu(containerId, playerInventory, this);
    }

    public void setTargetCoordinates(int x, int z) {
        this.targetX = x;
        this.targetZ = z;
        this.m_6596_();
        this.syncToClient();
    }

    public void setLaunchCode(String code) {
        this.launchCode = code;
        this.armed = !this.passcode.isEmpty() && this.passcode.equals(code);
        this.m_6596_();
        this.syncToClient();
    }

    public boolean attemptLaunch(Player player) {
        if (this.cooldownTicks > 0) {
            player.m_213846_((Component)Component.m_237113_((String)("System cooling down. Please wait " + this.cooldownTicks / 20 + " seconds.")));
            return false;
        }
        if (!this.armed) {
            player.m_213846_((Component)Component.m_237113_((String)"Invalid launch code!"));
            return false;
        }
        if (!this.hasValidTarget()) {
            player.m_213846_((Component)Component.m_237113_((String)"Invalid target coordinates!"));
            return false;
        }
        boolean launchSuccess = this.launchMissile(player);
        if (launchSuccess) {
            this.armed = false;
            this.launchCode = "";
            this.cooldownTicks = 600;
            this.m_6596_();
            this.syncToClient();
        }
        return launchSuccess;
    }

    private boolean hasValidTarget() {
        int maxRange = 5000;
        double distance = Math.sqrt(Math.pow(this.targetX - this.f_58858_.m_123341_(), 2.0) + Math.pow(this.targetZ - this.f_58858_.m_123343_(), 2.0));
        return distance <= (double)maxRange;
    }

    private boolean launchMissile(Player player) {
        System.out.println("Attempting to find launch pad from controller at: " + this.f_58858_);
        BlockPos launchPadPos = this.findConnectedLaunchPad();
        if (launchPadPos != null) {
            System.out.println("Found launch pad at: " + launchPadPos);
            BlockEntity blockEntity = this.f_58857_.m_7702_(launchPadPos);
            System.out.println("Block entity at launch pad: " + (blockEntity != null ? blockEntity.getClass().getSimpleName() : "null"));
            if (blockEntity instanceof LaunchPadBlockEntity) {
                LaunchPadBlockEntity launchPad = (LaunchPadBlockEntity)blockEntity;
                System.out.println("Launch pad block entity found, has missile: " + launchPad.hasMissile());
                if (launchPad.hasMissile() && launchPad.canLaunch()) {
                    launchPad.launchMissile(this.targetX, this.targetZ);
                    this.setControllerActivated(true);
                    return true;
                }
                if (!launchPad.hasMissile()) {
                    player.m_213846_((Component)Component.m_237113_((String)"No missile loaded on launch pad!").m_130940_(ChatFormatting.RED));
                    return false;
                }
                player.m_213846_((Component)Component.m_237113_((String)"Launch pad must be linked to an active nuclear reactor!").m_130940_(ChatFormatting.RED));
                return false;
            }
            System.out.println("Block entity at launch pad position is not a LaunchPadBlockEntity");
            System.out.println("Expected: LaunchPadBlockEntity, Got: " + (blockEntity != null ? blockEntity.getClass().getName() : "null"));
            player.m_213846_((Component)Component.m_237113_((String)"Launch pad not found!").m_130940_(ChatFormatting.RED));
            return false;
        }
        System.out.println("No launch pad found in search area");
        player.m_213846_((Component)Component.m_237113_((String)"No connected launch pad found!").m_130940_(ChatFormatting.RED));
        return false;
    }

    private void setControllerActivated(boolean activated) {
        BlockState currentState;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (Boolean)(currentState = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)LaunchControllerBlock.ACTIVATED) != activated) {
            BlockState newState = (BlockState)currentState.m_61124_((Property)LaunchControllerBlock.ACTIVATED, (Comparable)Boolean.valueOf(activated));
            this.f_58857_.m_7731_(this.f_58858_, newState, 3);
        }
    }

    public void onLaunchComplete() {
        this.setControllerActivated(false);
    }

    private BlockPos findConnectedLaunchPad() {
        for (int dy = -2; dy <= 2; ++dy) {
            for (int dx = -3; dx <= 3; ++dx) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockPos checkPos;
                    BlockState blockState;
                    if (dx == 0 && dz == 0 && dy == 0 || !(blockState = this.f_58857_.m_8055_(checkPos = this.f_58858_.m_7918_(dx, dy, dz))).m_60713_((Block)ModBlocks.LAUNCH_PAD.get())) continue;
                    Integer part = (Integer)blockState.m_61143_((Property)LaunchPadBlock.PART);
                    System.out.println("Found launch pad at: " + checkPos + " (controller at: " + this.f_58858_ + ") - Part: " + part);
                    if (part != 4) continue;
                    return checkPos;
                }
            }
        }
        System.out.println("No launch pad found near controller at: " + this.f_58858_);
        return null;
    }

    public int getTargetX() {
        return this.targetX;
    }

    public int getTargetZ() {
        return this.targetZ;
    }

    public String getLaunchCode() {
        return this.launchCode;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public void setOwner(Player player) {
        this.ownerId = player.m_20148_();
        this.ownerName = player.m_7755_().getString();
        this.m_6596_();
    }

    public boolean isOwner(Player player) {
        return this.ownerId != null && this.ownerId.equals(player.m_20148_());
    }

    public boolean hasPasscode() {
        return !this.passcode.isEmpty();
    }

    public void setPasscode(String newPasscode) {
        this.passcode = newPasscode;
        this.m_6596_();
    }

    public boolean verifyPasscode(String attemptedPasscode) {
        if (this.isLockedOut()) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.NUCLEAR_MISSILE_WARNING.get(), SoundSource.BLOCKS, 2.0f, 1.5f);
            }
            return false;
        }
        if (this.passcode.equals(attemptedPasscode)) {
            this.failedAttempts = 0;
            this.authenticated = true;
            this.m_6596_();
            return true;
        }
        ++this.failedAttempts;
        if (this.failedAttempts >= 3) {
            this.lockoutEndTime = this.f_58857_.m_46467_() + 1200L;
            this.isLocked = true;
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.NUCLEAR_MISSILE_WARNING.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            }
        }
        this.m_6596_();
        return false;
    }

    public boolean isLockedOut() {
        if (this.isLocked && this.f_58857_ != null) {
            if (this.f_58857_.m_46467_() >= this.lockoutEndTime) {
                this.isLocked = false;
                this.failedAttempts = 0;
                this.m_6596_();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        this.m_6596_();
    }

    public void clearAuthentication() {
        this.authenticated = false;
        this.m_6596_();
    }

    public int getFailedAttempts() {
        return this.failedAttempts;
    }

    public long getRemainingLockoutTime() {
        if (this.isLocked && this.f_58857_ != null) {
            long remaining = this.lockoutEndTime - this.f_58857_.m_46467_();
            return remaining > 0L ? remaining : 0L;
        }
        return 0L;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("TargetX", this.targetX);
        tag.m_128405_("TargetZ", this.targetZ);
        tag.m_128359_("LaunchCode", this.launchCode);
        tag.m_128379_("Armed", this.armed);
        tag.m_128405_("Cooldown", this.cooldownTicks);
        tag.m_128359_("Passcode", this.passcode);
        if (this.ownerId != null) {
            tag.m_128362_("OwnerId", this.ownerId);
        }
        tag.m_128359_("OwnerName", this.ownerName);
        tag.m_128379_("IsLocked", this.isLocked);
        tag.m_128405_("FailedAttempts", this.failedAttempts);
        tag.m_128356_("LockoutEndTime", this.lockoutEndTime);
        tag.m_128379_("Authenticated", this.authenticated);
        if (this.linkedReactorPos != null) {
            tag.m_128405_("ReactorX", this.linkedReactorPos.m_123341_());
            tag.m_128405_("ReactorY", this.linkedReactorPos.m_123342_());
            tag.m_128405_("ReactorZ", this.linkedReactorPos.m_123343_());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.targetX = tag.m_128451_("TargetX");
        this.targetZ = tag.m_128451_("TargetZ");
        this.launchCode = tag.m_128461_("LaunchCode");
        this.armed = tag.m_128471_("Armed");
        this.cooldownTicks = tag.m_128451_("Cooldown");
        this.passcode = tag.m_128461_("Passcode");
        if (tag.m_128403_("OwnerId")) {
            this.ownerId = tag.m_128342_("OwnerId");
        }
        this.ownerName = tag.m_128461_("OwnerName");
        this.isLocked = tag.m_128471_("IsLocked");
        this.failedAttempts = tag.m_128451_("FailedAttempts");
        this.lockoutEndTime = tag.m_128454_("LockoutEndTime");
        this.authenticated = tag.m_128471_("Authenticated");
        if (tag.m_128441_("ReactorX") && tag.m_128441_("ReactorY") && tag.m_128441_("ReactorZ")) {
            this.linkedReactorPos = new BlockPos(tag.m_128451_("ReactorX"), tag.m_128451_("ReactorY"), tag.m_128451_("ReactorZ"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void linkToReactor(BlockPos reactorPos) {
        this.linkedReactorPos = reactorPos;
        this.m_6596_();
    }

    public void unlinkReactor() {
        this.linkedReactorPos = null;
        this.isPoweredByReactor = false;
        this.m_6596_();
    }

    private void updateReactorLink(Level level) {
        if (this.linkedReactorPos == null) {
            this.isPoweredByReactor = false;
            return;
        }
        double distance = this.f_58858_.m_123331_((Vec3i)this.linkedReactorPos);
        if (distance > 10000.0) {
            this.unlinkReactor();
            return;
        }
        BlockEntity blockEntity = level.m_7702_(this.linkedReactorPos);
        if (blockEntity instanceof NuclearControllerBlockEntity) {
            BlockState reactorState = level.m_8055_(this.linkedReactorPos);
            this.isPoweredByReactor = reactorState.m_61138_((Property)NuclearControllerBlock.ACTIVE) ? (Boolean)reactorState.m_61143_((Property)NuclearControllerBlock.ACTIVE) : false;
        } else {
            this.unlinkReactor();
        }
    }

    public boolean isPoweredByReactor() {
        return this.isPoweredByReactor;
    }

    public BlockPos getLinkedReactorPos() {
        return this.linkedReactorPos;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.updateReactorLink(this.f_58857_);
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
            if (this.cooldownTicks % 20 == 0) {
                this.m_6596_();
                this.syncToClient();
            }
        }
    }
}

