/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.block.LaunchPadBlock;
import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.entity.LaunchControllerBlockEntity;
import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import com.modernmissions.client.CameraShakeHandler;
import com.modernmissions.entity.ChemicalGasBombEntity;
import com.modernmissions.entity.NuclearMissileEntity;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModBlocks;
import com.modernmissions.init.ModEntities;
import com.modernmissions.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaunchPadBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean hasMissile = false;
    private String missileType = "nuclear";
    private int countdownTicks = -1;
    private static final int COUNTDOWN_DURATION = 200;
    private int targetX = 0;
    private int targetZ = 0;
    private BlockPos linkedReactorPos = null;
    private boolean isPoweredByReactor = false;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.nuclear_launch_pad.idle");

    public LaunchPadBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LAUNCH_PAD.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<LaunchPadBlockEntity> animationState) {
        animationState.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean hasMissile() {
        return this.hasMissile;
    }

    public void setHasMissile(boolean hasMissile) {
        this.hasMissile = hasMissile;
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState currentState = this.f_58857_.m_8055_(this.m_58899_());
            if (currentState.m_61138_((Property)LaunchPadBlock.HAS_MISSILE)) {
                BlockState newState = (BlockState)currentState.m_61124_((Property)LaunchPadBlock.HAS_MISSILE, (Comparable)Boolean.valueOf(hasMissile));
                this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
            } else {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public String getMissileType() {
        return this.missileType;
    }

    public void setMissileType(String type) {
        this.missileType = type;
        this.m_6596_();
    }

    public int getCountdownTicks() {
        return this.countdownTicks;
    }

    public boolean isCountingDown() {
        return this.countdownTicks > 0;
    }

    public void startCountdown(int targetX, int targetZ) {
        System.out.println("startCountdown called at " + this.m_58899_() + " - current countdownTicks: " + this.countdownTicks + ", targetX: " + targetX + ", targetZ: " + targetZ);
        if (this.countdownTicks <= 0) {
            this.targetX = targetX;
            this.targetZ = targetZ;
            this.countdownTicks = 200;
            this.m_6596_();
            System.out.println("Countdown started! Set countdownTicks to: " + this.countdownTicks);
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        } else {
            System.out.println("Countdown NOT started - already counting down: " + this.countdownTicks);
        }
    }

    public void launchMissile(int targetX, int targetZ) {
        if (this.hasMissile && this.f_58857_ != null && !this.f_58857_.f_46443_ && this.countdownTicks <= 0 && this.canLaunch()) {
            this.startCountdown(targetX, targetZ);
        }
    }

    public boolean canLaunch() {
        return this.isPoweredByReactor;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.updateReactorLink(this.f_58857_);
        }
        if (this.countdownTicks > 0) {
            Object object;
            if (this.countdownTicks % 20 == 0) {
                System.out.println("Launch pad ticking - countdownTicks: " + this.countdownTicks + " at " + this.m_58899_());
            }
            --this.countdownTicks;
            if (this.f_58857_.f_46443_) {
                CameraShakeHandler.addMissileShake(this.m_58899_(), this.countdownTicks);
            }
            if (this.countdownTicks % 20 == 0) {
                int secondsLeft = this.countdownTicks / 20;
                if (!this.f_58857_.f_46443_) {
                    object = this.f_58857_.m_45976_(Player.class, new AABB(this.m_58899_()).m_82400_(30.0)).iterator();
                    while (object.hasNext()) {
                        Player player = (Player)object.next();
                        if (secondsLeft <= 0) continue;
                        player.m_5661_((Component)Component.m_237113_((String)("T-" + secondsLeft + "...")), true);
                    }
                    if (secondsLeft == 9) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.NUCLEAR_MISSILE_WARNING.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.MISSILE_COUNTDOWN_RUMBLING.get(), SoundSource.BLOCKS, 4.0f, 1.0f);
                    }
                    if (secondsLeft <= 9 && secondsLeft > 0) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundEvents.f_12210_.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
                    } else if (secondsLeft > 9) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundEvents.f_12215_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (secondsLeft == 5) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11739_, SoundSource.BLOCKS, 2.0f, 0.5f);
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11767_, SoundSource.BLOCKS, 1.5f, 0.7f);
                    }
                }
            }
            if (!this.f_58857_.f_46443_ && (object = this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)object;
                if ("chemical".equals(this.missileType)) {
                    this.createChemicalCountdownEffects(serverLevel, this.countdownTicks);
                } else if ("nuclear".equals(this.missileType)) {
                    this.createNuclearCountdownEffects(serverLevel, this.countdownTicks);
                }
            }
            if (this.countdownTicks == 0 && !this.f_58857_.f_46443_) {
                this.performActualLaunch();
            }
            this.m_6596_();
            if (!this.f_58857_.f_46443_ && this.countdownTicks % 5 == 0) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public boolean instantLaunch() {
        if (!this.hasMissile || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        if (this.targetX == 0 && this.targetZ == 0) {
            return false;
        }
        this.countdownTicks = 0;
        this.performActualLaunch();
        return true;
    }

    public boolean forceInstantLaunch(int targetX, int targetZ) {
        if (!this.hasMissile || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        this.targetX = targetX;
        this.targetZ = targetZ;
        this.countdownTicks = 0;
        this.performActualLaunch();
        return true;
    }

    private void performActualLaunch() {
        Object object;
        if (this.hasMissile && this.f_58857_ != null && !this.f_58857_.f_46443_ && (object = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            for (Player player : this.f_58857_.m_45976_(Player.class, new AABB(this.m_58899_()).m_82400_(50.0))) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverLevel.m_7654_().m_129892_().m_230957_(serverLevel.m_7654_().m_129893_().m_81324_().m_81325_(4), "stopsound " + serverPlayer.m_7755_().getString() + " * modern_missions:missile_countdown_rumbling");
            }
            this.setHasMissile(false);
            double spawnX = (double)this.m_58899_().m_123341_() + 0.5;
            double spawnY = (double)this.m_58899_().m_123342_() + 1.5;
            double spawnZ = (double)this.m_58899_().m_123343_() + 0.5;
            Vec3 initialVelocity = new Vec3(0.0, 1.0, 0.0);
            if ("chemical".equals(this.missileType)) {
                ChemicalGasBombEntity missile = new ChemicalGasBombEntity((EntityType<? extends ChemicalGasBombEntity>)((EntityType)ModEntities.CHEMICAL_GAS_BOMB.get()), this.f_58857_);
                missile.m_6034_(spawnX, spawnY, spawnZ);
                missile.m_20256_(initialVelocity);
                missile.setTargetCoordinates(this.targetX, this.targetZ);
                this.f_58857_.m_7967_((Entity)missile);
            } else {
                NuclearMissileEntity missile = new NuclearMissileEntity((EntityType<? extends NuclearMissileEntity>)((EntityType)ModEntities.NUCLEAR_MISSILE.get()), this.f_58857_);
                missile.m_6034_(spawnX, spawnY, spawnZ);
                missile.m_20256_(initialVelocity);
                missile.setTargetCoordinates(this.targetX, this.targetZ);
                this.f_58857_.m_7967_((Entity)missile);
            }
            if ("chemical".equals(this.missileType)) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.CHEMICAL_GAS_BOMB_LAUNCH.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            } else {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.NUCLEAR_MISSILE_LAUNCH.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            }
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 2.0f, 0.5f);
            this.createLaunchParticles(serverLevel, this.m_58899_());
            this.countdownTicks = -1;
            this.m_6596_();
            this.notifyControllersLaunchComplete();
        }
    }

    private void notifyControllersLaunchComplete() {
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockEntity blockEntity;
                    BlockPos checkPos;
                    if (dx == 0 && dy == 0 && dz == 0 || !this.f_58857_.m_8055_(checkPos = this.m_58899_().m_7918_(dx, dy, dz)).m_60713_((Block)ModBlocks.LAUNCH_CONTROLLER.get()) || !((blockEntity = this.f_58857_.m_7702_(checkPos)) instanceof LaunchControllerBlockEntity)) continue;
                    LaunchControllerBlockEntity controller = (LaunchControllerBlockEntity)blockEntity;
                    controller.onLaunchComplete();
                }
            }
        }
    }

    private void createChemicalCountdownEffects(ServerLevel serverLevel, int countdown) {
        int i;
        BlockPos pos = this.m_58899_();
        int intensity = Math.max(1, 11 - countdown / 20);
        if (countdown % 2 == 0) {
            for (i = 0; i < intensity; ++i) {
                double angle = this.f_58857_.f_46441_.m_188500_() * Math.PI * 2.0;
                double distance = 0.3 + this.f_58857_.f_46441_.m_188500_() * 0.2;
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 0.5 + this.f_58857_.f_46441_.m_188500_() * 1.5, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.02, 0.0, 0.01);
                if (countdown % 10 != 0 || !((double)this.f_58857_.f_46441_.m_188501_() < 0.3)) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123803_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (countdown < 100) {
            int ventCount = (100 - countdown) / 20;
            for (int i2 = 0; i2 < ventCount; ++i2) {
                double angle = this.f_58857_.f_46441_.m_188500_() * Math.PI * 2.0;
                double ventSpeed = 0.1 + this.f_58857_.f_46441_.m_188500_() * 0.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.5, 2, Math.cos(angle) * ventSpeed, 0.1, Math.sin(angle) * ventSpeed, 0.05);
            }
        }
        if (countdown < 60 && countdown % 5 == 0) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, (double)pos.m_123341_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 0.5, (double)pos.m_123342_() + 1.0 + this.f_58857_.f_46441_.m_188500_() * 0.5, (double)pos.m_123343_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (countdown < 60) {
            for (i = 0; i < 3; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5), (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5), 1, 0.0, 0.05, 0.0, 0.02);
            }
        }
        if (countdown % 30 == 0 && countdown < 150) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.0f);
        }
        if (countdown < 80 && countdown % 20 == 0) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 0.7f, 1.2f);
        }
    }

    private void createNuclearCountdownEffects(ServerLevel serverLevel, int countdown) {
        BlockPos pos = this.m_58899_();
        double x = (double)pos.m_123341_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        for (ServerPlayer player : serverLevel.m_6907_()) {
            int i;
            double dz;
            double dy;
            double dx = player.m_20185_() - x;
            double distanceSq = dx * dx + (dy = player.m_20186_() - (double)pos.m_123342_()) * dy + (dz = player.m_20189_() - z) * dz;
            if (!(distanceSq < 262144.0)) continue;
            float progress = 1.0f - (float)countdown / 200.0f;
            if (countdown < 180 && countdown % 2 == 0) {
                int steamCount = (int)(3.0f + progress * 7.0f);
                for (int i2 = 0; i2 < steamCount; ++i2) {
                    double angle = serverLevel.f_46441_.m_188500_() * Math.PI * 2.0;
                    double radius = 0.8 + serverLevel.f_46441_.m_188500_() * 0.4;
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123796_, true, x + Math.cos(angle) * radius, (double)pos.m_123342_() + 0.1, z + Math.sin(angle) * radius, 1, 0.1, 0.05, 0.1, 0.02);
                }
            }
            if (countdown % 3 == 0) {
                for (i = 0; i < Math.max(1, 5 - countdown / 40); ++i) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123755_, true, x, (double)pos.m_123342_() + 0.2, z, 2, 0.15, 0.1, 0.15, 0.01);
                }
            }
            if (countdown < 100 && countdown % 5 == 0) {
                for (i = 0; i < 5; ++i) {
                    double angle = serverLevel.f_46441_.m_188500_() * Math.PI * 2.0;
                    double dist = 0.5 + serverLevel.f_46441_.m_188500_() * 2.0;
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123762_, true, x + Math.cos(angle) * dist, (double)pos.m_123342_() + 0.05, z + Math.sin(angle) * dist, 1, 0.1, 0.02, 0.1, 0.01);
                }
            }
            if (countdown < 60) {
                if (countdown % 4 == 0) {
                    for (i = 0; i < 3; ++i) {
                        serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123810_, true, x + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.4, (double)pos.m_123342_() + 0.3, z + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.4, 1, 0.05, 0.1, 0.05, 0.02);
                    }
                }
                if (countdown < 20) {
                    for (i = 0; i < 5; ++i) {
                        serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, x + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.2, (double)pos.m_123342_() + 0.1, z + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.2, 2, 0.1, 0.0, 0.1, 0.15);
                    }
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123810_, true, x, (double)pos.m_123342_() + 0.1, z, 3, 0.05, 0.0, 0.05, 0.1);
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123778_, true, x, (double)pos.m_123342_() + 0.5, z, 2, 0.2, 0.3, 0.2, 0.05);
                }
            }
            if (countdown >= 40 || countdown % 8 != 0) continue;
            for (i = 0; i < 8; ++i) {
                double angle = Math.PI * 2 * (double)i / 8.0;
                serverLevel.m_8624_(player, (ParticleOptions)new DustColorTransitionOptions(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.5f, 0.0f), 1.5f), true, x + Math.cos(angle) * 1.5, (double)pos.m_123342_() + 1.0, z + Math.sin(angle) * 1.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void createLaunchParticles(ServerLevel serverLevel, BlockPos pos) {
        for (int ring = 0; ring < 3; ++ring) {
            double radius = (double)(ring + 1) * 1.5;
            for (int i = 0; i < 20; ++i) {
                double angle = Math.PI * 2 * (double)i / 20.0;
                double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
                double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, (double)pos.m_123342_() + 0.1, z, 1, 0.0, 0.1, 0.0, 0.05);
                if (ring != 0) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123778_, x, (double)pos.m_123342_() + 0.5, z, 1, 0.0, 0.2, 0.0, 0.1);
            }
        }
        for (int i = 0; i < 30; ++i) {
            double offsetX = (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0;
            double offsetZ = (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.5, 0.0, 0.2);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.3, 0.0, 0.1);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.hasMissile = tag.m_128471_("HasMissile");
        this.missileType = tag.m_128461_("MissileType");
        if (this.missileType.isEmpty()) {
            this.missileType = "nuclear";
        }
        if (tag.m_128441_("CountdownTicks")) {
            this.countdownTicks = tag.m_128451_("CountdownTicks");
            if (this.countdownTicks <= 0 && this.countdownTicks != -1) {
                this.countdownTicks = -1;
            }
        } else {
            this.countdownTicks = -1;
        }
        this.targetX = tag.m_128451_("TargetX");
        this.targetZ = tag.m_128451_("TargetZ");
        if (tag.m_128441_("ReactorX") && tag.m_128441_("ReactorY") && tag.m_128441_("ReactorZ")) {
            this.linkedReactorPos = new BlockPos(tag.m_128451_("ReactorX"), tag.m_128451_("ReactorY"), tag.m_128451_("ReactorZ"));
        }
        System.out.println("Loading NuclearLaunchPadBlockEntity at " + this.m_58899_() + " - hasMissile: " + this.hasMissile + ", countdownTicks: " + this.countdownTicks + " (tag contained CountdownTicks: " + tag.m_128441_("CountdownTicks") + ")");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("HasMissile", this.hasMissile);
        tag.m_128359_("MissileType", this.missileType);
        tag.m_128405_("CountdownTicks", this.countdownTicks);
        tag.m_128405_("TargetX", this.targetX);
        tag.m_128405_("TargetZ", this.targetZ);
        if (this.linkedReactorPos != null) {
            tag.m_128405_("ReactorX", this.linkedReactorPos.m_123341_());
            tag.m_128405_("ReactorY", this.linkedReactorPos.m_123342_());
            tag.m_128405_("ReactorZ", this.linkedReactorPos.m_123343_());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("HasMissile", this.hasMissile);
        tag.m_128359_("MissileType", this.missileType);
        tag.m_128405_("CountdownTicks", this.countdownTicks);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB((double)pos.m_123341_() - 1.5, (double)pos.m_123342_() - 0.1, (double)pos.m_123343_() - 1.5, (double)pos.m_123341_() + 2.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 2.5);
    }

    public void linkToReactor(BlockPos reactorPos) {
        this.linkedReactorPos = reactorPos;
        this.m_6596_();
    }

    public void unlinkReactor() {
        this.linkedReactorPos = null;
        this.isPoweredByReactor = false;
        this.m_6596_();
    }

    private void updateReactorLink(Level level) {
        if (this.linkedReactorPos == null) {
            this.isPoweredByReactor = false;
            return;
        }
        double distance = this.f_58858_.m_123331_((Vec3i)this.linkedReactorPos);
        if (distance > 10000.0) {
            this.unlinkReactor();
            return;
        }
        BlockEntity blockEntity = level.m_7702_(this.linkedReactorPos);
        if (blockEntity instanceof NuclearControllerBlockEntity) {
            BlockState reactorState = level.m_8055_(this.linkedReactorPos);
            this.isPoweredByReactor = reactorState.m_61138_((Property)NuclearControllerBlock.ACTIVE) ? (Boolean)reactorState.m_61143_((Property)NuclearControllerBlock.ACTIVE) : false;
        } else {
            this.unlinkReactor();
        }
    }

    public boolean isPoweredByReactor() {
        return this.isPoweredByReactor;
    }

    public BlockPos getLinkedReactorPos() {
        return this.linkedReactorPos;
    }
}

