/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.ReactorLubricantTankBlock;
import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import com.modernmissions.config.CommonConfig;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ReactorLubricantTankBlockEntity
extends BlockEntity {
    private int fillLevel = 0;
    private int consumptionTimer = 0;

    public ReactorLubricantTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REACTOR_LUBRICANT_TANK.get(), pos, state);
    }

    public int getFillLevel() {
        return this.fillLevel;
    }

    public void setFillLevel(int newLevel) {
        this.fillLevel = Math.max(0, Math.min(10, newLevel));
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ReactorLubricantTankBlockEntity entity) {
        if (level == null || level.f_46443_) {
            return;
        }
        if (entity.fillLevel > 0 && ReactorLubricantTankBlockEntity.isReactorActive(level, pos)) {
            ++entity.consumptionTimer;
            if (entity.consumptionTimer >= (Integer)CommonConfig.REACTOR_LUBRICANT_CONSUMPTION_RATE.get()) {
                entity.consumeLubricant();
                entity.consumptionTimer = 0;
            }
        } else {
            entity.consumptionTimer = 0;
        }
    }

    private static boolean isReactorActive(Level level, BlockPos tankPos) {
        BlockPos controllerPos = tankPos.m_7495_();
        BlockEntity controller = level.m_7702_(controllerPos);
        if (controller instanceof NuclearControllerBlockEntity) {
            NuclearControllerBlockEntity controllerEntity = (NuclearControllerBlockEntity)controller;
            return (Boolean)controllerEntity.m_58900_().m_61143_((Property)NuclearControllerBlock.ACTIVE);
        }
        return false;
    }

    public void consumeLubricant() {
        if (this.fillLevel > 0) {
            BlockState state;
            int newLevel = this.fillLevel - 1;
            this.setFillLevel(newLevel);
            if (this.f_58857_ != null && (state = this.f_58857_.m_8055_(this.f_58858_)).m_61138_((Property)ReactorLubricantTankBlock.FILL_LEVEL)) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ReactorLubricantTankBlock.FILL_LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
            }
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("FillLevel", this.fillLevel);
        nbt.m_128405_("ConsumptionTimer", this.consumptionTimer);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fillLevel = nbt.m_128451_("FillLevel");
        this.consumptionTimer = nbt.m_128451_("ConsumptionTimer");
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void dropContents(Level level, BlockPos pos) {
        if (this.fillLevel > 0) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.REFINED_OIL_BUCKET.get(), this.fillLevel);
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }
}

