/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.screen;

import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.C2SMissileAuthPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class MissileAuthScreen
extends Screen {
    private static final int GUI_WIDTH = 200;
    private static final int GUI_HEIGHT = 150;
    private final BlockPos blockPos;
    private final boolean isFirstSetup;
    private final String ownerName;
    private EditBox passcodeField;
    private EditBox confirmField;
    private Button submitButton;
    private Button cancelButton;
    private String statusMessage = "";
    private int statusColor = 65280;
    private int failedAttempts = 0;
    private long lockoutTime = 0L;

    public MissileAuthScreen(BlockPos blockPos, boolean isFirstSetup, String ownerName, int failedAttempts, long lockoutTime) {
        super((Component)Component.m_237113_((String)"Launch Controller Authentication"));
        this.blockPos = blockPos;
        this.isFirstSetup = isFirstSetup;
        this.ownerName = ownerName;
        this.failedAttempts = failedAttempts;
        this.lockoutTime = lockoutTime;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - 200) / 2;
        int y = (this.f_96544_ - 150) / 2;
        this.passcodeField = new EditBox(this.f_96547_, x + 50, y + 50, 100, 20, (Component)Component.m_237113_((String)(this.isFirstSetup ? "New Passcode" : "Passcode"))){

            public boolean m_5534_(char character, int modifiers) {
                if (Character.isDigit(character)) {
                    return super.m_5534_(character, modifiers);
                }
                return false;
            }
        };
        this.passcodeField.m_94199_(8);
        this.passcodeField.m_94202_(65280);
        this.passcodeField.m_93692_(true);
        this.m_142416_((GuiEventListener)this.passcodeField);
        if (this.isFirstSetup) {
            this.confirmField = new EditBox(this.f_96547_, x + 50, y + 75, 100, 20, (Component)Component.m_237113_((String)"Confirm")){

                public boolean m_5534_(char character, int modifiers) {
                    if (Character.isDigit(character)) {
                        return super.m_5534_(character, modifiers);
                    }
                    return false;
                }
            };
            this.confirmField.m_94199_(8);
            this.confirmField.m_94202_(65280);
            this.m_142416_((GuiEventListener)this.confirmField);
        }
        this.submitButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.isFirstSetup ? "SET PASSCODE" : "AUTHENTICATE")), button -> this.submitPasscode()).m_252794_(x + 30, y + (this.isFirstSetup ? 105 : 80)).m_253046_(80, 20).m_253136_());
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"CANCEL"), button -> this.m_7379_()).m_252794_(x + 115, y + (this.isFirstSetup ? 105 : 80)).m_253046_(55, 20).m_253136_());
        this.updateButtonStates();
    }

    private void submitPasscode() {
        String passcode = this.passcodeField.m_94155_();
        if (this.isFirstSetup) {
            String confirm;
            String string = confirm = this.confirmField != null ? this.confirmField.m_94155_() : "";
            if (passcode.isEmpty()) {
                this.showStatus("Passcode cannot be empty", 0xFF0000);
                return;
            }
            if (passcode.length() < 4) {
                this.showStatus("Passcode must be at least 4 digits", 0xFF0000);
                return;
            }
            if (!passcode.equals(confirm)) {
                this.showStatus("Passcodes do not match", 0xFF0000);
                return;
            }
            ModNetworking.CHANNEL.sendToServer((Object)new C2SMissileAuthPacket(this.blockPos, passcode, true));
            this.showStatus("Passcode set successfully!", 65280);
            this.f_96541_.execute(() -> this.m_7379_());
        } else {
            if (passcode.isEmpty()) {
                this.showStatus("Enter passcode", 0xFF0000);
                return;
            }
            ModNetworking.CHANNEL.sendToServer((Object)new C2SMissileAuthPacket(this.blockPos, passcode, false));
        }
    }

    private void showStatus(String message, int color) {
        this.statusMessage = message;
        this.statusColor = color;
    }

    private void updateButtonStates() {
        if (this.lockoutTime > 0L) {
            long remainingSeconds = this.lockoutTime / 20L;
            this.submitButton.f_93623_ = false;
            this.submitButton.m_93666_((Component)Component.m_237113_((String)("LOCKED (" + remainingSeconds + "s)")));
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.lockoutTime > 0L) {
            --this.lockoutTime;
            if (this.lockoutTime % 20L == 0L) {
                this.updateButtonStates();
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int x = (this.f_96543_ - 200) / 2;
        int y = (this.f_96544_ - 150) / 2;
        graphics.m_280509_(x, y, x + 200, y + 150, -16777216);
        graphics.m_280637_(x, y, 200, 150, -16711936);
        graphics.m_280637_(x + 1, y + 1, 198, 148, -16742400);
        String title = this.isFirstSetup ? "PASSCODE SETUP" : "AUTHENTICATION REQUIRED";
        graphics.m_280137_(this.f_96547_, title, this.f_96543_ / 2, y + 10, 65280);
        if (!this.isFirstSetup && !this.ownerName.isEmpty()) {
            graphics.m_280137_(this.f_96547_, "Owner: " + this.ownerName, this.f_96543_ / 2, y + 25, 0x888888);
        }
        if (this.isFirstSetup) {
            graphics.m_280137_(this.f_96547_, "Set a security passcode", this.f_96543_ / 2, y + 35, 0xFFFF00);
            graphics.m_280056_(this.f_96547_, "Code:", x + 10, y + 55, 65280, false);
            graphics.m_280056_(this.f_96547_, "Confirm:", x + 10, y + 80, 65280, false);
        } else {
            graphics.m_280137_(this.f_96547_, "Enter passcode to access", this.f_96543_ / 2, y + 35, 0xFFFF00);
            graphics.m_280056_(this.f_96547_, "Code:", x + 10, y + 55, 65280, false);
            if (this.failedAttempts > 0) {
                String attempts = "Failed attempts: " + this.failedAttempts + "/3";
                graphics.m_280056_(this.f_96547_, attempts, x + 10, y + 100, 0xFF8800, false);
            }
        }
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, y + 130, this.statusColor);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public void handleAuthResponse(boolean success, String message, int newFailedAttempts, long newLockoutTime) {
        if (success) {
            this.m_7379_();
        } else {
            this.showStatus(message, 0xFF0000);
            this.failedAttempts = newFailedAttempts;
            this.lockoutTime = newLockoutTime;
            this.updateButtonStates();
            this.passcodeField.m_94144_("");
        }
    }
}

