/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.screen;

import com.modernmissions.menu.NuclearReactorScreenMenu;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.C2SReactorCodePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class NuclearReactorScreenScreen
extends AbstractContainerScreen<NuclearReactorScreenMenu> {
    private static final Component TITLE = Component.m_237115_((String)"gui.modern_missions.reactor_screen.title");
    private static final Component CODE_LABEL = Component.m_237115_((String)"gui.modern_missions.reactor_screen.code_label");
    private static final Component REQUIRED_CODE = Component.m_237113_((String)"Required Code: 684-253-958");
    private static final Component SUBMIT_BUTTON = Component.m_237115_((String)"gui.modern_missions.reactor_screen.submit");
    private EditBox codeInput;
    private Button submitButton;
    private String errorMessage = "";
    private int errorMessageTimer = 0;

    public NuclearReactorScreenScreen(NuclearReactorScreenMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 200;
        this.f_97727_ = 120;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = (this.f_96543_ - this.f_97726_) / 2;
        int centerY = (this.f_96544_ - this.f_97727_) / 2;
        this.codeInput = new EditBox(this.f_96547_, centerX + 40, centerY + 50, 120, 20, (Component)Component.m_237113_((String)"Code"));
        this.codeInput.m_94199_(11);
        this.codeInput.m_94144_("");
        this.m_142416_((GuiEventListener)this.codeInput);
        this.submitButton = Button.m_253074_((Component)SUBMIT_BUTTON, button -> this.submitCode()).m_252987_(centerX + 65, centerY + 80, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.submitButton);
    }

    private void submitCode() {
        String code = this.codeInput.m_94155_().trim();
        if (code.isEmpty()) {
            this.showError("Please enter a code!");
            return;
        }
        ModNetworking.sendToServer(new C2SReactorCodePacket(((NuclearReactorScreenMenu)this.f_97732_).getBlockEntity().m_58899_(), code));
        if ("684-253-958".equals(code)) {
            this.f_96541_.f_91074_.m_6915_();
        } else {
            this.showError("Invalid code!");
            this.codeInput.m_94144_("");
        }
    }

    private void showError(String message) {
        this.errorMessage = message;
        this.errorMessageTimer = 60;
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.errorMessageTimer > 0) {
            --this.errorMessageTimer;
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280509_(x, y, x + this.f_97726_, y + this.f_97727_, -13948117);
        guiGraphics.m_280509_(x - 2, y - 2, x + this.f_97726_ + 2, y, -16777216);
        guiGraphics.m_280509_(x - 2, y + this.f_97727_, x + this.f_97726_ + 2, y + this.f_97727_ + 2, -16777216);
        guiGraphics.m_280509_(x - 2, y, x, y + this.f_97727_, -16777216);
        guiGraphics.m_280509_(x + this.f_97726_, y, x + this.f_97726_ + 2, y + this.f_97727_, -16777216);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280653_(this.f_96547_, TITLE, x + this.f_97726_ / 2, y + 6, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, REQUIRED_CODE, x + this.f_97726_ / 2, y + 20, 65280);
        guiGraphics.m_280430_(this.f_96547_, CODE_LABEL, x + 40, y + 38, 0xA0A0A0);
        if (this.errorMessageTimer > 0 && !this.errorMessage.isEmpty()) {
            int alpha = Math.min(255, this.errorMessageTimer * 8);
            int color = alpha << 24 | 0xFF0000;
            guiGraphics.m_280137_(this.f_96547_, this.errorMessage, x + this.f_97726_ / 2, y + 105, color);
        }
        if (((NuclearReactorScreenMenu)this.f_97732_).getBlockEntity().isAlarmActive()) {
            int countdown = ((NuclearReactorScreenMenu)this.f_97732_).getBlockEntity().getAlarmCountdown() / 20;
            MutableComponent warning = Component.m_237113_((String)("\u26a0 WARNING: " + countdown + " seconds remaining! \u26a0")).m_130938_(style -> style.m_178520_(0xFF0000).m_131136_(Boolean.valueOf(true)));
            guiGraphics.m_280653_(this.f_96547_, (Component)warning, this.f_96543_ / 2, y - 15, 0xFF0000);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        if (this.codeInput.m_93696_()) {
            if (keyCode == 257) {
                this.submitCode();
                return true;
            }
            return this.codeInput.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

