/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.entity;

import com.modernmissions.init.ModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NuclearMushroomCloudEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(NuclearMushroomCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> OPACITY = SynchedEntityData.m_135353_(NuclearMushroomCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int lifeTime = 0;
    private static final int MAX_LIFETIME = 200;
    private static final float ANIMATION_DURATION = 164.0f;
    private static final float FADE_START = 120.0f;

    public NuclearMushroomCloudEntity(EntityType<? extends NuclearMushroomCloudEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public NuclearMushroomCloudEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends NuclearMushroomCloudEntity>)((EntityType)ModEntities.NUCLEAR_MUSHROOM_CLOUD.get()), level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(OPACITY, (Object)Float.valueOf(1.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTime;
        if (this.lifeTime >= 200) {
            this.m_146870_();
            return;
        }
        if ((float)this.lifeTime >= 120.0f) {
            float fadeProgress = ((float)this.lifeTime - 120.0f) / 80.0f;
            float newOpacity = Math.max(0.0f, 1.0f - fadeProgress);
            this.f_19804_.m_135381_(OPACITY, (Object)Float.valueOf(newOpacity));
            if (newOpacity <= 0.05f) {
                this.m_146870_();
                return;
            }
        }
        if ((float)this.lifeTime < 164.0f) {
            float animProgress = (float)this.lifeTime / 164.0f;
            float scale = 0.5f + animProgress * 3.0f;
            this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
        }
        float opacity = ((Float)this.f_19804_.m_135370_(OPACITY)).floatValue();
        if (!this.m_9236_().f_46443_ && this.lifeTime % 2 == 0 && opacity > 0.3f) {
            this.spawnCloudParticles();
        }
    }

    private void spawnCloudParticles() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float scale = ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
        int particleCount = (int)(scale * 5.0f);
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.random() * Math.PI * 2.0;
            double radius = Math.random() * (double)scale * 4.0;
            double height = Math.random() * (double)scale * 8.0 - (double)(scale * 4.0f);
            double x = this.m_20185_() + Math.cos(angle) * radius;
            double y = this.m_20186_() + height;
            double z = this.m_20189_() + Math.sin(angle) * radius;
            if (this.lifeTime < 100) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, 0.1, 0.1, 0.1, 0.02);
                if (i % 2 == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123778_, x, y, z, 1, 0.05, 0.05, 0.05, 0.01);
                }
            } else {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 1, 0.2, 0.2, 0.2, 0.01);
            }
            if (this.lifeTime >= 60 || i % 3 != 0) continue;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (Math.random() - 0.5) * (double)scale * 2.0, this.m_20186_() - (double)(scale * 2.0f), this.m_20189_() + (Math.random() - 0.5) * (double)scale * 2.0, 1, 0.1, 0.1, 0.1, 0.05);
        }
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public float getOpacity() {
        return ((Float)this.f_19804_.m_135370_(OPACITY)).floatValue();
    }

    protected void m_7378_(CompoundTag tag) {
        this.lifeTime = tag.m_128451_("LifeTime");
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(tag.m_128457_("Scale")));
        this.f_19804_.m_135381_(OPACITY, (Object)Float.valueOf(tag.m_128457_("Opacity")));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("LifeTime", this.lifeTime);
        tag.m_128350_("Scale", ((Float)this.f_19804_.m_135370_(SCALE)).floatValue());
        tag.m_128350_("Opacity", ((Float)this.f_19804_.m_135370_(OPACITY)).floatValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<NuclearMushroomCloudEntity> animationState) {
        if ((float)this.lifeTime < 164.0f) {
            animationState.getController().setAnimation(RawAnimation.begin().thenPlay("animation.nuclear_mushroom_cloud.explosion"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6783_(double distance) {
        return distance < 65536.0;
    }
}

