/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.explosion;

import com.modernmissions.entity.PoisonGasCloudEntity;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.S2CNuclearExplosionPacket;
import com.modernmissions.util.ExtendedParticleUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NuclearExplosionManager {
    private static final Map<UUID, Long> activeExplosions = new HashMap<UUID, Long>();
    private static final WeakHashMap<Explosion, Boolean> nuclearExplosions = new WeakHashMap();
    private static final Set<BlockPos> recentExplosionSites = new HashSet<BlockPos>();
    private static final int EXPLOSION_RADIUS = 30;
    private static final int RADIATION_RADIUS = 80;
    private static final int FLASH_RADIUS = 200;
    private static final int CHEMICAL_RADIUS = 30;

    public static boolean isNuclearExplosion(Explosion explosion) {
        return nuclearExplosions.containsKey(explosion);
    }

    public static void triggerNuclearExplosion(Level level, BlockPos pos, boolean hasActiveMissile) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (recentExplosionSites.contains(pos)) {
            return;
        }
        recentExplosionSites.add(pos);
        UUID explosionId = UUID.randomUUID();
        activeExplosions.put(explosionId, System.currentTimeMillis());
        NuclearExplosionManager.sendFlashToNearbyPlayers(serverLevel, pos);
        float basePower = hasActiveMissile ? 18.0f : 12.0f;
        Explosion mainExplosion = level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, basePower, true, Level.ExplosionInteraction.TNT);
        nuclearExplosions.put(mainExplosion, true);
        for (int i = 0; i < 6; ++i) {
            double angle = Math.PI * 2 * (double)i / 6.0;
            double radius = 5.0;
            double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
            double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
            Explosion secondaryExplosion = level.m_255391_(null, x, (double)pos.m_123342_() + 0.5, z, basePower * 0.6f, true, Level.ExplosionInteraction.TNT);
            nuclearExplosions.put(secondaryExplosion, true);
        }
        for (int delay = 5; delay <= 15; delay += 5) {
            int currentDelay = delay;
            float delayedPower = basePower * (0.8f - (float)currentDelay / 30.0f);
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_() + currentDelay, () -> {
                int explosionCount = 3 + serverLevel.f_46441_.m_188503_(2);
                double expandingRadius = 8.0 + (double)currentDelay * 1.0;
                for (int j = 0; j < explosionCount; ++j) {
                    double angle = serverLevel.f_46441_.m_188500_() * Math.PI * 2.0;
                    double distance = expandingRadius * (0.8 + serverLevel.f_46441_.m_188500_() * 0.2);
                    double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * distance;
                    double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * distance;
                    double y = (double)pos.m_123342_() + serverLevel.f_46441_.m_188500_() * 3.0 - 1.0;
                    Explosion delayedExplosion = serverLevel.m_255391_(null, x, y, z, delayedPower, true, Level.ExplosionInteraction.TNT);
                    nuclearExplosions.put(delayedExplosion, true);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x, y, z, 2, 0.5, 0.5, 0.5, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 20, 2.0, 2.0, 2.0, 0.0);
                }
                serverLevel.m_5594_(null, pos, SoundEvents.f_12090_, SoundSource.NEUTRAL, 4.0f, 0.7f + serverLevel.f_46441_.m_188501_() * 0.3f);
            }));
        }
        serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_() + 5, () -> NuclearExplosionManager.startMushroomCloud(serverLevel, pos, explosionId)));
        NuclearExplosionManager.applyRadiationEffects(serverLevel, pos);
        NuclearExplosionManager.createGroundZeroBatched(serverLevel, pos, (int)basePower);
        NuclearExplosionManager.playNuclearSounds(serverLevel, pos);
        serverLevel.m_7654_().execute(() -> serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_() + 600, () -> NuclearExplosionManager.cleanupExplosion(explosionId))));
    }

    private static void sendFlashToNearbyPlayers(ServerLevel level, BlockPos pos) {
        AABB flashArea = new AABB(pos).m_82400_(200.0);
        for (ServerPlayer player : level.m_45976_(ServerPlayer.class, flashArea)) {
            double distance = player.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)pos));
            float intensity = (float)Math.max(0.0, 1.0 - distance / 200.0);
            ModNetworking.sendToPlayer(new S2CNuclearExplosionPacket(pos, intensity, (int)(intensity * 120.0f)), player);
        }
    }

    private static void startMushroomCloud(ServerLevel level, BlockPos pos, UUID explosionId) {
        NuclearExplosionManager.scheduleMushroomCloudUpdate(level, pos, explosionId, 0, 300);
    }

    private static void scheduleMushroomCloudUpdate(ServerLevel level, BlockPos pos, UUID explosionId, int startTick, int endTick) {
        if (startTick >= endTick || !activeExplosions.containsKey(explosionId)) {
            return;
        }
        int batchSize = 15;
        for (int i = 0; i < batchSize && startTick + i < endTick; ++i) {
            int currentTick = startTick + i * 3;
            if (currentTick >= endTick) continue;
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + i, () -> NuclearExplosionManager.updateMushroomCloud(level, pos, currentTick, explosionId)));
        }
        int nextStart = startTick + batchSize * 3;
        if (nextStart < endTick) {
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + batchSize, () -> NuclearExplosionManager.scheduleMushroomCloudUpdate(level, pos, explosionId, nextStart, endTick)));
        }
    }

    private static void updateMushroomCloud(ServerLevel level, BlockPos pos, int tick, UUID explosionId) {
        int i;
        double z;
        if (!activeExplosions.containsKey(explosionId)) {
            return;
        }
        double progress = (double)tick / 300.0;
        boolean isEarlyPhase = progress < 0.3;
        boolean isMidPhase = progress >= 0.3 && progress < 0.7;
        boolean isLatePhase = progress >= 0.7;
        double riseSpeed = Math.max(0.0, 1.0 - progress * 0.8);
        double columnHeight = 60.0 * (1.0 - Math.exp(-progress * 3.0)) * riseSpeed;
        double columnRadius = 4.0 + Math.sin(progress * Math.PI * 2.0) * 2.0;
        double turbulence = progress * 360.0;
        double wobble = Math.sin((double)tick * 0.1) * 2.0;
        if (tick % 6 == 0) {
            int y = 0;
            while ((double)y < columnHeight) {
                int particleCount = 3;
                double layerRadius = columnRadius * (1.0 + (double)y / columnHeight * 0.4);
                for (int i2 = 0; i2 < particleCount; ++i2) {
                    double angle = Math.PI * 2 * (double)i2 / (double)particleCount + Math.toRadians(turbulence + (double)(y * 2));
                    double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * layerRadius + wobble;
                    double z2 = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * layerRadius;
                    if (isEarlyPhase && (double)y < columnHeight * 0.6) {
                        ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123744_, x, pos.m_123342_() + y, z2, 2, 0.2, 0.2, 0.2, 0.03);
                        if (!((double)level.f_46441_.m_188501_() < 0.3)) continue;
                        ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123756_, x, pos.m_123342_() + y, z2, 1, 0.0, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (isMidPhase) {
                        ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123755_, x, pos.m_123342_() + y, z2, 3, 0.3, 0.2, 0.3, 0.01);
                        if (!((double)level.f_46441_.m_188501_() < 0.1)) continue;
                        ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123762_, x, pos.m_123342_() + y, z2, 1, 0.2, 0.1, 0.2, 0.02);
                        continue;
                    }
                    if (!isLatePhase) continue;
                    ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123778_, x, pos.m_123342_() + y, z2, 2, 0.4, 0.1, 0.4, 0.005);
                }
                y += 8;
            }
        }
        if (columnHeight > 25.0) {
            double capProgress = Math.min(1.0, (columnHeight - 25.0) / 35.0);
            double capRadius = capProgress * 25.0;
            double capY = (double)pos.m_123342_() + columnHeight;
            double capThickness = 8.0 + capProgress * 10.0;
            int ringCount = Math.min(2, (int)(capProgress * 2.0));
            for (int ring = 0; ring < ringCount; ++ring) {
                double ringProgress = (double)ring / (double)Math.max(1, ringCount);
                double ringRadius = capRadius * Math.sin(ringProgress * Math.PI);
                int particleCount = Math.min(6, (int)(ringRadius * 1.5));
                double ringY = capY - ringProgress * capThickness;
                for (int i3 = 0; i3 < particleCount; ++i3) {
                    double angle = Math.PI * 2 * (double)i3 / (double)particleCount + Math.toRadians(turbulence * 2.0);
                    double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * ringRadius;
                    double z3 = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * ringRadius;
                    double y = ringY;
                    if (isEarlyPhase) {
                        if (ringProgress < 0.3) {
                            ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123744_, x, y, z3, 2, 0.5, 0.2, 0.5, 0.02);
                            if ((double)level.f_46441_.m_188501_() < 0.3) {
                                ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123745_, x, y, z3, 1, 0.3, 0.2, 0.3, 0.03);
                            }
                        }
                        ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123755_, x, y, z3, 2, 0.6, 0.3, 0.6, 0.02);
                        continue;
                    }
                    if (isMidPhase) {
                        ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123755_, x, y, z3, 3, 0.7, 0.3, 0.7, 0.015);
                        if (!(ringProgress < 0.2) || !((double)level.f_46441_.m_188501_() < 0.1)) continue;
                        ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123762_, x, y, z3, 1, 0.2, 0.1, 0.2, 0.01);
                        continue;
                    }
                    if (!isLatePhase) continue;
                    ExtendedParticleUtil.sendExplosionParticles(level, pos, (ParticleOptions)ParticleTypes.f_123778_, x, y + level.f_46441_.m_188500_() * 3.0, z3, 2, 0.8, 0.4, 0.8, 0.01);
                }
            }
            if (capProgress > 0.3 && tick % 4 == 0) {
                for (int i4 = 0; i4 < 10; ++i4) {
                    double theta = level.f_46441_.m_188500_() * Math.PI;
                    double phi = level.f_46441_.m_188500_() * Math.PI * 2.0;
                    double r = capRadius * 0.7;
                    double x = (double)pos.m_123341_() + 0.5 + r * Math.sin(theta) * Math.cos(phi);
                    double y = capY + r * Math.cos(theta) * 0.4;
                    double z4 = (double)pos.m_123343_() + 0.5 + r * Math.sin(theta) * Math.sin(phi);
                    if (isEarlyPhase && i4 < 3) {
                        level.m_8767_((ParticleOptions)ParticleTypes.f_175827_, x * 0.3 + (double)pos.m_123341_() * 0.7, y, z4 * 0.3 + (double)pos.m_123343_() * 0.7, 1, 0.1, 0.1, 0.1, 0.01);
                        continue;
                    }
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z4, 1, 0.2, 0.2, 0.2, 0.005);
                }
            }
        }
        if (tick < 20 && tick % 4 == 0) {
            double shockwaveRadius = (double)tick * 2.5;
            double shockwaveHeight = Math.max(0.0, 4.0 - (double)tick * 0.2);
            int particleCount = Math.min(15, (int)(shockwaveRadius * 0.8));
            for (int i5 = 0; i5 < particleCount; ++i5) {
                double angle = Math.PI * 2 * (double)i5 / (double)particleCount;
                double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * shockwaveRadius;
                z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * shockwaveRadius;
                BlockPos groundPos = new BlockPos((int)x, pos.m_123342_() + 5, (int)z);
                while (level.m_46859_(groundPos) && groundPos.m_123342_() > level.m_141937_()) {
                    groundPos = groundPos.m_7495_();
                }
                int h = 0;
                while ((double)h < shockwaveHeight) {
                    if ((double)level.f_46441_.m_188501_() < 0.8) {
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x + level.f_46441_.m_188583_() * 0.5, (double)(groundPos.m_123342_() + h + 1), z + level.f_46441_.m_188583_() * 0.5, 1, 0.3, 0.1, 0.3, 0.02);
                    }
                    ++h;
                }
                level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, (double)groundPos.m_123342_() + shockwaveHeight / 2.0, z, 2, 0.5, shockwaveHeight / 4.0, 0.5, 0.01);
                if (i5 % 3 != 0) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, (double)groundPos.m_123342_() + 0.5, z, 3, 0.3, 0.2, 0.3, 0.08);
            }
            if (tick < 30) {
                double secondaryRadius = tick * 5;
                int secondaryCount = (int)(secondaryRadius * 2.0);
                for (int i6 = 0; i6 < secondaryCount; ++i6) {
                    double angle = Math.PI * 2 * (double)i6 / (double)secondaryCount;
                    double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * secondaryRadius;
                    double z5 = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * secondaryRadius;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, (double)(pos.m_123342_() + 10), z5, 1, 0.1, 5.0, 0.1, 0.0);
                }
            }
        }
        if (tick > 80 && tick % 5 == 0) {
            int debrisCount = Math.min(30, 20 + (int)(progress * 15.0));
            double debrisRadius = 60.0 + progress * 40.0;
            for (i = 0; i < debrisCount; ++i) {
                double x = (double)pos.m_123341_() + (level.f_46441_.m_188500_() - 0.5) * debrisRadius * 2.0;
                double z6 = (double)pos.m_123343_() + (level.f_46441_.m_188500_() - 0.5) * debrisRadius * 2.0;
                double y = (double)(pos.m_123342_() + 50) + level.f_46441_.m_188500_() * 30.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y, z6, 3, 0.5, -0.8, 0.5, 0.15);
                if (tick > 150) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123790_, x, y - 10.0, z6, 2, 0.3, -0.3, 0.3, 0.1);
                }
                if ((double)level.f_46441_.m_188501_() < 0.15) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123801_, x, y, z6, 1, 0.0, -0.5, 0.0, 0.0);
                }
                if (!((double)level.f_46441_.m_188501_() < 0.2)) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_175827_, x, y - 5.0, z6, 1, 0.2, -0.2, 0.2, 0.05);
            }
            if (tick > 200 && tick < 350) {
                int rainCount = 30;
                double rainRadius = 80.0;
                for (int i7 = 0; i7 < rainCount; ++i7) {
                    double x = (double)pos.m_123341_() + (level.f_46441_.m_188500_() - 0.5) * rainRadius * 2.0;
                    double z7 = (double)pos.m_123343_() + (level.f_46441_.m_188500_() - 0.5) * rainRadius * 2.0;
                    double y = pos.m_123342_() + 70;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123765_, x, y, z7, 1, 0.0, -2.0, 0.0, 0.0);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123787_, x, y + 5.0, z7, 1, 0.1, -1.0, 0.1, 0.0);
                }
            }
        }
        if (tick < 200) {
            double heatRadius = 30.0 + (double)tick * 0.5;
            int shimmerCount = 15;
            for (i = 0; i < shimmerCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)shimmerCount;
                double r = heatRadius * (0.8 + level.f_46441_.m_188500_() * 0.4);
                double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * r;
                z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * r;
                double y = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 20.0;
                if ((double)level.f_46441_.m_188501_() < 0.3) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 1, 0.0, 0.5, 0.0, 0.1);
                }
                if (tick >= 40 || !((double)level.f_46441_.m_188501_() < 0.1)) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y + 10.0, z, 2, 1.0, 1.0, 1.0, 0.5);
            }
        }
    }

    private static void applyRadiationEffects(ServerLevel level, BlockPos pos) {
        AABB radiationArea = new AABB(pos).m_82400_(80.0);
        for (LivingEntity entity : level.m_45976_(LivingEntity.class, radiationArea)) {
            double distance = entity.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)pos));
            if (distance < 30.0) {
                entity.m_6469_(level.m_269111_().m_269549_(), 100.0f);
                continue;
            }
            int duration = (int)(600.0 * (1.0 - distance / 80.0));
            int amplifier = distance < 45.0 ? 2 : 1;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, duration, amplifier));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, duration / 2, amplifier - 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, duration, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration * 2, amplifier));
        }
    }

    private static void createGroundZeroBatched(ServerLevel level, BlockPos center, int radius) {
        int maxDelayPerBatch = 40;
        boolean step = true;
        int batchIndex = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                double horizontalDistance = Math.sqrt(x * x + z * z);
                if (horizontalDistance > (double)radius) continue;
                int fx = x;
                int fz = z;
                int delay = Math.min(batchIndex / 8, 40);
                level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + delay, () -> NuclearExplosionManager.processGroundZeroColumn(level, center, radius, fx, fz)));
                ++batchIndex;
            }
        }
    }

    private static void processGroundZeroColumn(ServerLevel level, BlockPos center, int radius, int x, int z) {
        for (int y = -radius / 2; y <= radius / 2; ++y) {
            BlockPos pos = center.m_7918_(x, y, z);
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (!(distance <= (double)radius)) continue;
            if (level.f_46441_.m_188501_() < 0.2f && distance < (double)radius * 0.5 && level.m_8055_(pos).m_204336_(BlockTags.f_13029_)) {
                level.m_7731_(pos, Blocks.f_50058_.m_49966_(), 2);
            }
            if (!(level.f_46441_.m_188501_() < 0.02f) || !level.m_46859_(pos)) continue;
            level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 2);
        }
    }

    private static void playNuclearSounds(ServerLevel level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 10.0f, 0.5f);
        level.m_5594_(null, pos, SoundEvents.f_12563_, SoundSource.BLOCKS, 8.0f, 0.3f);
        int i = 1;
        while (i <= 5) {
            int delay = i++;
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + delay * 20, () -> level.m_5594_(null, pos, SoundEvents.f_11894_, SoundSource.BLOCKS, 5.0f - (float)delay, 0.5f)));
        }
    }

    private static void cleanupExplosion(UUID explosionId) {
        activeExplosions.remove(explosionId);
    }

    public static void triggerChemicalExplosion(Level level, BlockPos pos) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (recentExplosionSites.contains(pos)) {
            return;
        }
        recentExplosionSites.add(pos);
        System.out.println("Triggering chemical explosion at " + pos);
        float explosionPower = 10.0f;
        Explosion explosion = level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, explosionPower, true, Level.ExplosionInteraction.TNT);
        nuclearExplosions.put(explosion, true);
        NuclearExplosionManager.createToxicCloud(serverLevel, pos);
        NuclearExplosionManager.applyChemicalEffects(serverLevel, pos);
        NuclearExplosionManager.playChemicalSounds(serverLevel, pos);
        serverLevel.m_7654_().execute(() -> serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_() + 100, () -> recentExplosionSites.remove(pos))));
    }

    private static void createToxicCloud(ServerLevel level, BlockPos pos) {
        PoisonGasCloudEntity gasCloud = new PoisonGasCloudEntity((Level)level, (double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
        level.m_7967_((Entity)gasCloud);
        for (int tick = 0; tick < 60; ++tick) {
            int currentTick = tick;
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + tick, () -> NuclearExplosionManager.updateToxicCloud(level, pos, currentTick)));
        }
    }

    private static void updateToxicCloud(ServerLevel level, BlockPos pos, int tick) {
        int i;
        double progress = (double)tick / 60.0;
        double radius = 30.0 * (1.0 - progress * 0.3);
        int particleCount = (int)(radius * 3.0);
        for (i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double distance = level.f_46441_.m_188500_() * radius;
            double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * distance;
            double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * distance;
            double y = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 5.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 2, 0.2, 0.2, 0.2, 0.02);
            if ((double)level.f_46441_.m_188501_() < 0.5) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123749_, x, y + 0.5, z, 3, 0.1, 0.1, 0.1, 0.02);
            }
            if ((double)level.f_46441_.m_188501_() < 0.3) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, 0.1, 0.1, 0.1, 0.01);
            }
            if (!((double)level.f_46441_.m_188501_() < 0.2)) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_175833_, x, y + 1.0, z, 1, 0.3, 0.3, 0.3, 0.0);
        }
        for (i = 0; i < 10; ++i) {
            double x = (double)pos.m_123341_() + (level.f_46441_.m_188500_() - 0.5) * radius * 2.0;
            double z = (double)pos.m_123343_() + (level.f_46441_.m_188500_() - 0.5) * radius * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123757_, x, (double)pos.m_123342_() + 0.1, z, 3, 0.5, 0.1, 0.5, 0.0);
        }
    }

    private static void applyChemicalEffects(ServerLevel level, BlockPos pos) {
        AABB poisonArea = new AABB(pos).m_82400_(30.0);
        for (LivingEntity entity : level.m_45976_(LivingEntity.class, poisonArea)) {
            double distance = entity.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)pos));
            if (!(distance < 30.0)) continue;
            if (distance < 5.0) {
                entity.m_6469_(level.m_269111_().m_269425_(), 20.0f);
            }
            int duration = (int)(400.0 * (1.0 - distance / 30.0));
            int amplifier = distance < 10.0 ? 2 : (distance < 20.0 ? 1 : 0);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, duration, amplifier));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, duration * 2, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, amplifier));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, duration, 1));
        }
    }

    private static void playChemicalSounds(ServerLevel level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 5.0f, 1.2f);
        level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 4.0f, 0.5f);
        int i = 0;
        while (i < 5) {
            int delay = i++;
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + delay * 20, () -> level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 3.0f - (float)delay * 0.5f, 1.5f)));
        }
    }

    static {
        new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    recentExplosionSites.clear();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }).start();
    }
}

