/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.item;

import com.modernmissions.block.LaunchPadBlock;
import com.modernmissions.client.renderer.LaunchPadItemRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaunchPadItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public LaunchPadItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237113_((String)"Multiblock Construction:").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 Place 9 Iron Pressure Plates in a 3x3 grid").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 Right-click center plate to form Launch Pad").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 Requires Launch Controller to operate").m_130940_(ChatFormatting.YELLOW));
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!level.f_46443_) {
            int z;
            int x;
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, 0, z);
                    if (level.m_8055_(checkPos).m_60629_(context)) continue;
                    return InteractionResult.FAIL;
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    BlockPos placePos = pos.m_7918_(x, 0, z);
                    int part = x + 1 + (z + 1) * 3;
                    BlockState padState = (BlockState)this.m_40614_().m_49966_().m_61124_((Property)LaunchPadBlock.PART, (Comparable)Integer.valueOf(part));
                    level.m_7731_(placePos, padState, 3);
                }
            }
            BlockState centerState = level.m_8055_(pos);
            if ((Integer)centerState.m_61143_((Property)LaunchPadBlock.PART) == 4) {
                level.m_7731_(pos, centerState, 3);
            }
            level.m_5594_(null, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 0.9f);
            level.m_5594_(null, pos, SoundEvents.f_11739_, SoundSource.BLOCKS, 0.8f, 1.1f);
            context.m_43722_().m_41774_(1);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private LaunchPadItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new LaunchPadItemRenderer();
                }
                return this.renderer;
            }
        });
    }
}

