/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.item;

import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.entity.LaunchControllerBlockEntity;
import com.modernmissions.block.entity.LaunchPadBlockEntity;
import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import com.modernmissions.block.entity.PoweredFurnaceBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class UplinkRemoteItem
extends Item {
    public UplinkRemoteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player == null || !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NuclearControllerBlockEntity) {
            NuclearControllerBlockEntity controller = (NuclearControllerBlockEntity)blockEntity;
            BlockState state = level.m_8055_(pos);
            if (state.m_61138_((Property)NuclearControllerBlock.ACTIVE) && ((Boolean)state.m_61143_((Property)NuclearControllerBlock.ACTIVE)).booleanValue()) {
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("ReactorX", pos.m_123341_());
                tag.m_128405_("ReactorY", pos.m_123342_());
                tag.m_128405_("ReactorZ", pos.m_123343_());
                tag.m_128359_("ReactorDimension", level.m_46472_().m_135782_().toString());
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)("Uplink bound to reactor at " + pos.m_123344_())).m_130940_(ChatFormatting.GREEN), true);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)"Reactor must be active to bind").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResult.FAIL;
        }
        if (blockEntity instanceof PoweredFurnaceBlockEntity) {
            PoweredFurnaceBlockEntity furnace = (PoweredFurnaceBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_("ReactorX")) {
                BlockPos reactorPos = new BlockPos(tag.m_128451_("ReactorX"), tag.m_128451_("ReactorY"), tag.m_128451_("ReactorZ"));
                double distance = pos.m_123331_((Vec3i)reactorPos);
                if (distance > 10000.0) {
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237113_((String)"Furnace is too far from reactor (max 100 blocks)").m_130940_(ChatFormatting.RED), true);
                    }
                    return InteractionResult.FAIL;
                }
                BlockEntity reactor = level.m_7702_(reactorPos);
                if (reactor instanceof NuclearControllerBlockEntity) {
                    BlockState reactorState = level.m_8055_(reactorPos);
                    if (reactorState.m_61138_((Property)NuclearControllerBlock.ACTIVE) && ((Boolean)reactorState.m_61143_((Property)NuclearControllerBlock.ACTIVE)).booleanValue()) {
                        furnace.linkToReactor(reactorPos);
                        if (!level.f_46443_) {
                            player.m_5661_((Component)Component.m_237113_((String)"Furnace linked to reactor!").m_130940_(ChatFormatting.GREEN), true);
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237113_((String)"Reactor is no longer active").m_130940_(ChatFormatting.RED), true);
                    }
                    return InteractionResult.FAIL;
                }
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)"Reactor not found").m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)"Uplink not bound to a reactor").m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResult.FAIL;
        }
        if (blockEntity instanceof LaunchPadBlockEntity) {
            LaunchPadBlockEntity launchPad = (LaunchPadBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_("ReactorX")) {
                BlockPos reactorPos = new BlockPos(tag.m_128451_("ReactorX"), tag.m_128451_("ReactorY"), tag.m_128451_("ReactorZ"));
                double distance = pos.m_123331_((Vec3i)reactorPos);
                if (distance > 10000.0) {
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237113_((String)"Launch pad is too far from reactor (max 100 blocks)").m_130940_(ChatFormatting.RED), true);
                    }
                    return InteractionResult.FAIL;
                }
                BlockEntity reactor = level.m_7702_(reactorPos);
                if (reactor instanceof NuclearControllerBlockEntity) {
                    BlockState reactorState = level.m_8055_(reactorPos);
                    if (reactorState.m_61138_((Property)NuclearControllerBlock.ACTIVE) && ((Boolean)reactorState.m_61143_((Property)NuclearControllerBlock.ACTIVE)).booleanValue()) {
                        launchPad.linkToReactor(reactorPos);
                        if (!level.f_46443_) {
                            player.m_5661_((Component)Component.m_237113_((String)"Launch pad linked to reactor!").m_130940_(ChatFormatting.GREEN), true);
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237113_((String)"Reactor is no longer active").m_130940_(ChatFormatting.RED), true);
                    }
                    return InteractionResult.FAIL;
                }
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)"Reactor not found").m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)"Uplink not bound to a reactor").m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResult.FAIL;
        }
        if (blockEntity instanceof LaunchControllerBlockEntity) {
            LaunchControllerBlockEntity controller = (LaunchControllerBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_("ReactorX")) {
                BlockPos reactorPos = new BlockPos(tag.m_128451_("ReactorX"), tag.m_128451_("ReactorY"), tag.m_128451_("ReactorZ"));
                double distance = pos.m_123331_((Vec3i)reactorPos);
                if (distance > 10000.0) {
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237113_((String)"Launch controller is too far from reactor (max 100 blocks)").m_130940_(ChatFormatting.RED), true);
                    }
                    return InteractionResult.FAIL;
                }
                BlockEntity reactor = level.m_7702_(reactorPos);
                if (reactor instanceof NuclearControllerBlockEntity) {
                    BlockState reactorState = level.m_8055_(reactorPos);
                    if (reactorState.m_61138_((Property)NuclearControllerBlock.ACTIVE) && ((Boolean)reactorState.m_61143_((Property)NuclearControllerBlock.ACTIVE)).booleanValue()) {
                        controller.linkToReactor(reactorPos);
                        if (!level.f_46443_) {
                            player.m_5661_((Component)Component.m_237113_((String)"Launch controller linked to reactor!").m_130940_(ChatFormatting.GREEN), true);
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237113_((String)"Reactor is no longer active").m_130940_(ChatFormatting.RED), true);
                    }
                    return InteractionResult.FAIL;
                }
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)"Reactor not found").m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)"Uplink not bound to a reactor").m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("ReactorX")) {
            BlockPos reactorPos = new BlockPos(tag.m_128451_("ReactorX"), tag.m_128451_("ReactorY"), tag.m_128451_("ReactorZ"));
            tooltip.add((Component)Component.m_237113_((String)("Bound to: " + reactorPos.m_123344_())).m_130940_(ChatFormatting.AQUA));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Not bound").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237113_((String)"Shift-right-click reactor to bind").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.m_237113_((String)"Shift-right-click furnace/launch systems to link").m_130940_(ChatFormatting.DARK_GRAY));
    }
}

