/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.loot;

import com.google.common.base.Suppliers;
import com.modernmissions.config.CommonConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)Codec.INT.fieldOf("count").forGetter(m -> m.count), (App)Codec.STRING.fieldOf("config_key").forGetter(m -> m.configKey))).apply((Applicative)inst, AddItemModifier::new)));
    private final Item item;
    private final int count;
    private final String configKey;

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item item, int count, String configKey) {
        super(conditionsIn);
        this.item = item;
        this.count = count;
        this.configKey = configKey;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        float chance = this.getChanceFromConfig();
        if (context.m_230907_().m_188501_() < chance) {
            if (this.configKey.startsWith("sand_") || this.configKey.startsWith("gravel_")) {
                generatedLoot.clear();
            }
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item, this.count));
        }
        return generatedLoot;
    }

    private float getChanceFromConfig() {
        return switch (this.configKey) {
            case "sand_saltpeter" -> ((Double)CommonConfig.SAND_SALTPETER_CHANCE.get()).floatValue();
            case "sand_sulfur" -> ((Double)CommonConfig.SAND_SULFUR_CHANCE.get()).floatValue();
            case "gravel_sulfur" -> ((Double)CommonConfig.GRAVEL_SULFUR_CHANCE.get()).floatValue();
            default -> 0.0f;
        };
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

