/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.menu;

import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import com.modernmissions.init.ModBlocks;
import com.modernmissions.init.ModMenuTypes;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ReactorControllerMenu
extends AbstractContainerMenu {
    private final NuclearControllerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int PLAYER_INV_SIZE = 27;
    private static final int HOTBAR_SIZE = 9;
    private static final int PLAYER_INV_START = 0;
    private static final int PLAYER_INV_END = 27;
    private static final int HOTBAR_START = 27;
    private static final int HOTBAR_END = 36;

    public ReactorControllerMenu(int id, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(id, playerInventory, ReactorControllerMenu.getBlockEntity(playerInventory, extraData));
    }

    public ReactorControllerMenu(int id, Inventory playerInventory, NuclearControllerBlockEntity blockEntity) {
        this(id, playerInventory, blockEntity, blockEntity.getData());
    }

    public ReactorControllerMenu(int id, Inventory playerInventory, NuclearControllerBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.REACTOR_CONTROLLER.get(), id);
        this.blockEntity = blockEntity;
        this.level = playerInventory.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.m_38884_(data);
    }

    private static NuclearControllerBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory");
        Objects.requireNonNull(data, "data");
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(pos);
        if (blockEntity instanceof NuclearControllerBlockEntity) {
            NuclearControllerBlockEntity controller = (NuclearControllerBlockEntity)blockEntity;
            return controller;
        }
        throw new IllegalStateException("Missing reactor controller block entity at " + pos);
    }

    public boolean m_6875_(Player player) {
        return ReactorControllerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.NUCLEAR_CONTROLLER.get()));
    }

    public int getFuelCount() {
        return this.data.m_6413_(0);
    }

    public int getMaxFuel() {
        return 16;
    }

    public int getCoolantBlocks() {
        return this.data.m_6413_(1);
    }

    public int getMaxCoolantBlocks() {
        return 25;
    }

    public int getLubricantLevel() {
        return this.data.m_6413_(2);
    }

    public int getMaxLubricantLevel() {
        return 10;
    }

    public boolean isActive() {
        return this.data.m_6413_(3) == 1;
    }

    public int getControlRodCount() {
        return this.data.m_6413_(4);
    }

    public int getControlRodProgressPct() {
        return this.data.m_6413_(5);
    }

    public NuclearControllerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 95 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, 8 + column * 18, 153));
        }
    }
}

