/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network;

import com.modernmissions.network.packet.C2SMissileAuthPacket;
import com.modernmissions.network.packet.C2SMissileControlPacket;
import com.modernmissions.network.packet.C2SOrbitalStrikeRequestPacket;
import com.modernmissions.network.packet.C2SReactorCodePacket;
import com.modernmissions.network.packet.C2SRequestLoadedChunksPacket;
import com.modernmissions.network.packet.C2SToggleReactorPacket;
import com.modernmissions.network.packet.S2CCameraShakePacket;
import com.modernmissions.network.packet.S2CLoadedChunksPacket;
import com.modernmissions.network.packet.S2CNuclearExplosionPacket;
import com.modernmissions.network.packet.S2COpenAuthScreenPacket;
import com.modernmissions.network.packet.S2CReactorStatePacket;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModNetworking {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("modern_missions", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int id = 0;

    public static void register() {
        CHANNEL.messageBuilder(C2SOrbitalStrikeRequestPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(C2SOrbitalStrikeRequestPacket::encode).decoder(C2SOrbitalStrikeRequestPacket::decode).consumerMainThread(C2SOrbitalStrikeRequestPacket::handle).add();
        CHANNEL.messageBuilder(C2SRequestLoadedChunksPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(C2SRequestLoadedChunksPacket::encode).decoder(C2SRequestLoadedChunksPacket::decode).consumerMainThread(C2SRequestLoadedChunksPacket::handle).add();
        CHANNEL.messageBuilder(S2CLoadedChunksPacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(S2CLoadedChunksPacket::encode).decoder(S2CLoadedChunksPacket::decode).consumerMainThread(S2CLoadedChunksPacket::handle).add();
        CHANNEL.messageBuilder(C2SMissileAuthPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(C2SMissileAuthPacket::encode).decoder(C2SMissileAuthPacket::new).consumerMainThread(C2SMissileAuthPacket::handle).add();
        CHANNEL.messageBuilder(C2SMissileControlPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(C2SMissileControlPacket::encode).decoder(C2SMissileControlPacket::new).consumerMainThread(C2SMissileControlPacket::handle).add();
        CHANNEL.messageBuilder(S2COpenAuthScreenPacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(S2COpenAuthScreenPacket::encode).decoder(S2COpenAuthScreenPacket::new).consumerMainThread(S2COpenAuthScreenPacket::handle).add();
        CHANNEL.messageBuilder(S2CNuclearExplosionPacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(S2CNuclearExplosionPacket::toBytes).decoder(S2CNuclearExplosionPacket::new).consumerMainThread((msg, ctx) -> msg.handle((Supplier<NetworkEvent.Context>)ctx)).add();
        CHANNEL.messageBuilder(S2CCameraShakePacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(S2CCameraShakePacket::toBytes).decoder(S2CCameraShakePacket::new).consumerMainThread((msg, ctx) -> msg.handle((Supplier<NetworkEvent.Context>)ctx)).add();
        CHANNEL.messageBuilder(C2SReactorCodePacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(C2SReactorCodePacket::toBytes).decoder(C2SReactorCodePacket::new).consumerMainThread((msg, ctx) -> msg.handle((Supplier<NetworkEvent.Context>)ctx)).add();
        CHANNEL.messageBuilder(C2SToggleReactorPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(C2SToggleReactorPacket::encode).decoder(C2SToggleReactorPacket::decode).consumerMainThread(C2SToggleReactorPacket::handle).add();
        CHANNEL.messageBuilder(S2CReactorStatePacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(S2CReactorStatePacket::toBytes).decoder(S2CReactorStatePacket::new).consumerMainThread(S2CReactorStatePacket::handle).add();
    }

    public static void sendToServer(Object msg) {
        CHANNEL.sendToServer(msg);
    }

    public static void sendToPlayer(S2CNuclearExplosionPacket packet, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendCameraShakeToNearbyPlayers(S2CCameraShakePacket packet, ServerLevel level, BlockPos pos, double radius) {
        CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), radius, level.m_46472_())), (Object)packet);
    }
}

