/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.block.entity.LaunchControllerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SMissileControlPacket {
    private final BlockPos controllerPos;
    private final int targetX;
    private final int targetZ;
    private final String launchCode;
    private final boolean launch;

    public C2SMissileControlPacket(BlockPos controllerPos, int targetX, int targetZ, String launchCode, boolean launch) {
        this.controllerPos = controllerPos;
        this.targetX = targetX;
        this.targetZ = targetZ;
        this.launchCode = launchCode;
        this.launch = launch;
    }

    public C2SMissileControlPacket(FriendlyByteBuf buf) {
        this.controllerPos = buf.m_130135_();
        this.targetX = buf.readInt();
        this.targetZ = buf.readInt();
        this.launchCode = buf.m_130277_();
        this.launch = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.controllerPos);
        buf.writeInt(this.targetX);
        buf.writeInt(this.targetZ);
        buf.m_130070_(this.launchCode);
        buf.writeBoolean(this.launch);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!level.m_46749_(this.controllerPos)) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.controllerPos);
            if (!(blockEntity instanceof LaunchControllerBlockEntity)) {
                return;
            }
            LaunchControllerBlockEntity controller = (LaunchControllerBlockEntity)blockEntity;
            controller.setTargetCoordinates(this.targetX, this.targetZ);
            controller.setLaunchCode(this.launchCode);
            if (this.launch) {
                controller.attemptLaunch((Player)player);
            }
        });
        context.get().setPacketHandled(true);
    }
}

