/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.S2CLoadedChunksPacket;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class C2SRequestLoadedChunksPacket {
    public final int minChunkX;
    public final int maxChunkX;
    public final int minChunkZ;
    public final int maxChunkZ;

    public C2SRequestLoadedChunksPacket(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ) {
        this.minChunkX = minChunkX;
        this.maxChunkX = maxChunkX;
        this.minChunkZ = minChunkZ;
        this.maxChunkZ = maxChunkZ;
    }

    public static void encode(C2SRequestLoadedChunksPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.minChunkX);
        buf.writeInt(msg.maxChunkX);
        buf.writeInt(msg.minChunkZ);
        buf.writeInt(msg.maxChunkZ);
    }

    public static C2SRequestLoadedChunksPacket decode(FriendlyByteBuf buf) {
        int minX = buf.readInt();
        int maxX = buf.readInt();
        int minZ = buf.readInt();
        int maxZ = buf.readInt();
        return new C2SRequestLoadedChunksPacket(minX, maxX, minZ, maxZ);
    }

    public static void handle(C2SRequestLoadedChunksPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            int spanX = Math.min(512, Math.max(0, pkt.maxChunkX - pkt.minChunkX + 1));
            int spanZ = Math.min(512, Math.max(0, pkt.maxChunkZ - pkt.minChunkZ + 1));
            int minX = pkt.minChunkX;
            int minZ = pkt.minChunkZ;
            int maxX = minX + spanX - 1;
            int maxZ = minZ + spanZ - 1;
            ArrayList<int[]> coords = new ArrayList<int[]>();
            for (int cx = minX; cx <= maxX; ++cx) {
                for (int cz = minZ; cz <= maxZ; ++cz) {
                    LevelChunk lc = level.m_7726_().m_7131_(cx, cz);
                    if (lc == null || !lc.m_6415_().m_62427_(ChunkStatus.f_62326_)) continue;
                    coords.add(new int[]{cx, cz});
                }
            }
            String dim = level.m_46472_().m_135782_().toString();
            ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CLoadedChunksPacket(dim, coords));
        });
        ctx.get().setPacketHandled(true);
    }
}

