/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.client.CameraShakeHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2CCameraShakePacket {
    private final BlockPos source;
    private final float intensity;
    private final float maxDistance;
    private final int durationTicks;

    public S2CCameraShakePacket(BlockPos source, float intensity, float maxDistance, int durationTicks) {
        this.source = source;
        this.intensity = intensity;
        this.maxDistance = maxDistance;
        this.durationTicks = durationTicks;
    }

    public S2CCameraShakePacket(FriendlyByteBuf buf) {
        this.source = buf.m_130135_();
        this.intensity = buf.readFloat();
        this.maxDistance = buf.readFloat();
        this.durationTicks = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.source);
        buf.writeFloat(this.intensity);
        buf.writeFloat(this.maxDistance);
        buf.writeInt(this.durationTicks);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CameraShakeHandler.addShake(this.source, this.intensity, this.maxDistance, this.durationTicks)));
        context.setPacketHandled(true);
        return true;
    }
}

