/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.client.orbital.OrbitalTargetingScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class S2CLoadedChunksPacket {
    public final String dimensionId;
    public final List<int[]> coords;

    public S2CLoadedChunksPacket(String dimensionId, List<int[]> coords) {
        this.dimensionId = dimensionId;
        this.coords = coords;
    }

    public static void encode(S2CLoadedChunksPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.dimensionId);
        buf.m_130130_(msg.coords.size());
        for (int[] pair : msg.coords) {
            buf.m_130130_(pair[0]);
            buf.m_130130_(pair[1]);
        }
    }

    public static S2CLoadedChunksPacket decode(FriendlyByteBuf buf) {
        String dim = buf.m_130277_();
        int n = buf.m_130242_();
        ArrayList<int[]> coords = new ArrayList<int[]>(n);
        for (int i = 0; i < n; ++i) {
            int cx = buf.m_130242_();
            int cz = buf.m_130242_();
            coords.add(new int[]{cx, cz});
        }
        return new S2CLoadedChunksPacket(dim, coords);
    }

    public static void handle(S2CLoadedChunksPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> S2CLoadedChunksPacket.handleClient(pkt));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2CLoadedChunksPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        String currentDim = mc.f_91073_.m_46472_().m_135782_().toString();
        if (currentDim.equals(pkt.dimensionId)) {
            OrbitalTargetingScreen.receiveLoadedChunks(pkt.dimensionId, pkt.coords);
        }
    }
}

