/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.client.NuclearExplosionRenderer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2CNuclearExplosionPacket {
    private final BlockPos explosionPos;
    private final float intensity;
    private final int duration;

    public S2CNuclearExplosionPacket(BlockPos explosionPos, float intensity, int duration) {
        this.explosionPos = explosionPos;
        this.intensity = intensity;
        this.duration = duration;
    }

    public S2CNuclearExplosionPacket(FriendlyByteBuf buf) {
        this.explosionPos = buf.m_130135_();
        this.intensity = buf.readFloat();
        this.duration = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.explosionPos);
        buf.writeFloat(this.intensity);
        buf.writeInt(this.duration);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> NuclearExplosionRenderer.triggerFlash(this.explosionPos, this.intensity, this.duration)));
        context.setPacketHandled(true);
        return true;
    }
}

