/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.client.screen.MissileAuthScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class S2COpenAuthScreenPacket {
    private final BlockPos pos;
    private final boolean isFirstSetup;
    private final String ownerName;
    private final int failedAttempts;
    private final long lockoutTime;

    public S2COpenAuthScreenPacket(BlockPos pos, boolean isFirstSetup, String ownerName, int failedAttempts, long lockoutTime) {
        this.pos = pos;
        this.isFirstSetup = isFirstSetup;
        this.ownerName = ownerName;
        this.failedAttempts = failedAttempts;
        this.lockoutTime = lockoutTime;
    }

    public S2COpenAuthScreenPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.isFirstSetup = buf.readBoolean();
        this.ownerName = buf.m_130277_();
        this.failedAttempts = buf.readInt();
        this.lockoutTime = buf.readLong();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.isFirstSetup);
        buf.m_130070_(this.ownerName);
        buf.writeInt(this.failedAttempts);
        buf.writeLong(this.lockoutTime);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> this.handleOnClient());
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleOnClient() {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.execute(() -> minecraft.m_91152_((Screen)new MissileAuthScreen(this.pos, this.isFirstSetup, this.ownerName, this.failedAttempts, this.lockoutTime)));
    }
}

