/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.ModernMissions;
import com.modernmissions.client.event.ReactorSoundHandler;
import com.modernmissions.client.sound.ReactorSoundManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2CReactorStatePacket {
    private final BlockPos pos;
    private final boolean active;

    public S2CReactorStatePacket(BlockPos pos, boolean active) {
        this.pos = pos;
        this.active = active;
    }

    public S2CReactorStatePacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.active = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.active);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.active) {
                ReactorSoundManager.startReactorSound(this.pos);
                ReactorSoundHandler.addActiveReactor(this.pos);
                ModernMissions.LOGGER.debug("Received reactor START packet for {}", (Object)this.pos);
            } else {
                ReactorSoundManager.stopReactorSound(this.pos);
                ReactorSoundHandler.removeActiveReactor(this.pos);
                ModernMissions.LOGGER.debug("Received reactor STOP packet for {}", (Object)this.pos);
            }
        }));
        return true;
    }
}

