/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class ExtendedParticleUtil {
    private static final int MAX_PARTICLE_DISTANCE = 512;
    private static final int MAX_PARTICLE_DISTANCE_SQ = 262144;

    public static void sendExtendedRangeParticles(ServerLevel level, ParticleOptions particleType, double x, double y, double z, int count, double xSpeed, double ySpeed, double zSpeed, double speed) {
        for (ServerPlayer player : level.m_6907_()) {
            double dz;
            double dy;
            double dx = player.m_20185_() - x;
            double distanceSq = dx * dx + (dy = player.m_20186_() - y) * dy + (dz = player.m_20189_() - z) * dz;
            if (!(distanceSq < 262144.0)) continue;
            int adjustedCount = count;
            if (distanceSq > 65536.0) {
                double distanceFactor = 1.0 - (Math.sqrt(distanceSq) - 256.0) / 256.0;
                adjustedCount = Math.max(1, (int)((double)count * distanceFactor));
            }
            level.m_8624_(player, particleType, true, x, y, z, adjustedCount, xSpeed, ySpeed, zSpeed, speed);
        }
    }

    public static void sendExplosionParticles(ServerLevel level, BlockPos pos, ParticleOptions particleType, double x, double y, double z, int baseCount, double xSpeed, double ySpeed, double zSpeed, double speed) {
        Vec3 explosionCenter = Vec3.m_82512_((Vec3i)pos);
        for (ServerPlayer player : level.m_6907_()) {
            double distance = player.m_20182_().m_82554_(explosionCenter);
            if (!(distance < 512.0)) continue;
            int particleCount = distance < 64.0 ? baseCount : (distance < 128.0 ? Math.max(1, (int)((double)baseCount * 0.75)) : (distance < 256.0 ? Math.max(1, (int)((double)baseCount * 0.5)) : Math.max(1, (int)((double)baseCount * 0.25))));
            level.m_8624_(player, particleType, true, x, y, z, particleCount, xSpeed, ySpeed, zSpeed, speed);
        }
    }
}

