/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.entity.engine;

import com.github.bonndan.blimpy.blimp.entity.engine.Emissions;
import com.github.bonndan.blimpy.blimp.entity.engine.SaveStateCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 02\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\tJ\b\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tH\u0002J\u000e\u0010%\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ&\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*J\b\u0010-\u001a\u00020.H$J\u0018\u0010/\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/github/bonndan/blimpy/blimp/entity/engine/Engine;", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "saveStateCallback", "Lcom/github/bonndan/blimpy/blimp/entity/engine/SaveStateCallback;", "<init>", "(Lcom/github/bonndan/blimpy/blimp/entity/engine/SaveStateCallback;)V", "engineOn", "", "remainingBurnTime", "", "totalBurnTime", "setStackInSlot", "", "slot", "stack", "Lnet/minecraft/world/item/ItemStack;", "getBurnProgressPct", "isLit", "setEngineOn", "state", "isOn", "tickFuel", "tryConsumeFuel", "load", "burnTime", "readAdditionalSaveData", "valueInput", "Lnet/minecraft/world/level/storage/ValueInput;", "registryAccess", "Lnet/minecraft/core/RegistryAccess;", "addAdditionalSaveData", "valueOutput", "Lnet/minecraft/world/level/storage/ValueOutput;", "isItemValid", "calculateBurnTimeOfNextItem", "setBurnTime", "setTotalBurnTime", "setRemainingBurnTime", "makeEmissions", "level", "Lnet/minecraft/world/level/Level;", "emitterPos", "Lnet/minecraft/world/phys/Vec3;", "entityPos", "oldEntityPos", "getEmissions", "Lcom/github/bonndan/blimpy/blimp/entity/engine/Emissions;", "saveState", "Companion", "blimpy"})
public abstract class Engine
extends ItemStackHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SaveStateCallback saveStateCallback;
    private boolean engineOn;
    private int remainingBurnTime;
    private int totalBurnTime;
    @NotNull
    public static final String BURN = "burn";
    @NotNull
    public static final String TOTAL_BURN_CAPACITY = "burn_capacity";
    @NotNull
    public static final String ENGINE_ON = "eo";
    @NotNull
    public static final String FUEL_ITEMS = "fuelItems";

    public Engine(@NotNull SaveStateCallback saveStateCallback2) {
        Intrinsics.checkNotNullParameter((Object)saveStateCallback2, (String)"saveStateCallback");
        super(1);
        this.saveStateCallback = saveStateCallback2;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.setStackInSlot(slot, stack);
        int burnTime = this.calculateBurnTimeOfNextItem(stack);
        this.load(burnTime);
        this.saveState(this.engineOn, this.remainingBurnTime);
    }

    public final int getBurnProgressPct() {
        return (int)((float)this.remainingBurnTime / (float)this.totalBurnTime * (float)100);
    }

    public final boolean isLit() {
        return this.remainingBurnTime > 0 && this.isOn();
    }

    public final void setEngineOn(boolean state) {
        this.engineOn = state;
        this.saveState(this.engineOn, this.remainingBurnTime);
    }

    public final boolean isOn() {
        return this.engineOn;
    }

    public final int tickFuel() {
        if (!this.isOn()) {
            return 0;
        }
        if (this.remainingBurnTime > 0) {
            int n = this.remainingBurnTime;
            this.remainingBurnTime = n + -1;
        } else {
            this.tryConsumeFuel();
        }
        this.saveState(this.engineOn, this.remainingBurnTime);
        return this.remainingBurnTime;
    }

    private final int tryConsumeFuel() {
        ItemStack stack = this.getStackInSlot(0);
        Intrinsics.checkNotNull((Object)stack);
        int burnTime = this.calculateBurnTimeOfNextItem(stack);
        if (burnTime > 0) {
            stack.shrink(1);
            this.load(burnTime);
        }
        return burnTime;
    }

    private final void load(int burnTime) {
        this.totalBurnTime = burnTime;
        this.remainingBurnTime = burnTime;
    }

    public final void readAdditionalSaveData(@NotNull ValueInput valueInput, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)valueInput, (String)"valueInput");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Integer n = valueInput.getInt(BURN).orElse(0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"orElse(...)");
        this.setBurnTime(((Number)n).intValue());
        Integer n2 = valueInput.getInt(TOTAL_BURN_CAPACITY).orElse(0);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"orElse(...)");
        this.setTotalBurnTime(((Number)n2).intValue());
        this.setEngineOn(valueInput.getBooleanOr(ENGINE_ON, false));
        valueInput.childOrEmpty(FUEL_ITEMS);
    }

    public final void addAdditionalSaveData(@NotNull ValueOutput valueOutput) {
        Intrinsics.checkNotNullParameter((Object)valueOutput, (String)"valueOutput");
        valueOutput.putInt(BURN, this.remainingBurnTime);
        valueOutput.putInt(TOTAL_BURN_CAPACITY, this.totalBurnTime);
        valueOutput.putBoolean(ENGINE_ON, this.engineOn);
        valueOutput.putChild(FUEL_ITEMS, (ValueIOSerializable)this);
    }

    public abstract boolean isItemValid(int var1, @NotNull ItemStack var2);

    public abstract int calculateBurnTimeOfNextItem(@NotNull ItemStack var1);

    private final void setBurnTime(int burnTime) {
        this.remainingBurnTime = burnTime;
    }

    private final void setTotalBurnTime(int totalBurnTime) {
        this.totalBurnTime = totalBurnTime;
    }

    public final void setRemainingBurnTime(int remainingBurnTime) {
        this.remainingBurnTime = remainingBurnTime;
    }

    public final void makeEmissions(@NotNull Level level, @NotNull Vec3 emitterPos, @NotNull Vec3 entityPos, @NotNull Vec3 oldEntityPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)emitterPos, (String)"emitterPos");
        Intrinsics.checkNotNullParameter((Object)entityPos, (String)"entityPos");
        Intrinsics.checkNotNullParameter((Object)oldEntityPos, (String)"oldEntityPos");
        if (!level.isClientSide) {
            return;
        }
        if (!this.isLit()) {
            return;
        }
        this.getEmissions().makeEmissions(level, emitterPos, entityPos, oldEntityPos);
    }

    @NotNull
    protected abstract Emissions getEmissions();

    private final void saveState(boolean engineOn, int remainingBurnTime) {
        this.saveStateCallback.saveState(engineOn, remainingBurnTime);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/bonndan/blimpy/blimp/entity/engine/Engine$Companion;", "", "<init>", "()V", "BURN", "", "TOTAL_BURN_CAPACITY", "ENGINE_ON", "FUEL_ITEMS", "blimpy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

