/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.entity.engine;

import com.github.bonndan.blimpy.blimp.entity.engine.Emissions;
import com.github.bonndan.blimpy.blimp.entity.engine.Engine;
import com.github.bonndan.blimpy.blimp.entity.engine.SaveStateCallback;
import com.github.bonndan.blimpy.blimp.entity.engine.SmokeGenerator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FuelValues;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/github/bonndan/blimpy/blimp/entity/engine/FueledEngine;", "Lcom/github/bonndan/blimpy/blimp/entity/engine/Engine;", "saveStateCallback", "Lcom/github/bonndan/blimpy/blimp/entity/engine/SaveStateCallback;", "fuelValues", "Lnet/minecraft/world/level/block/entity/FuelValues;", "<init>", "(Lcom/github/bonndan/blimpy/blimp/entity/engine/SaveStateCallback;Lnet/minecraft/world/level/block/entity/FuelValues;)V", "getFuelValues", "()Lnet/minecraft/world/level/block/entity/FuelValues;", "calculateBurnTimeOfNextItem", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "getEmissions", "Lcom/github/bonndan/blimpy/blimp/entity/engine/Emissions;", "isItemValid", "", "slot", "blimpy"})
public final class FueledEngine
extends Engine {
    @NotNull
    private final FuelValues fuelValues;

    public FueledEngine(@NotNull SaveStateCallback saveStateCallback2, @NotNull FuelValues fuelValues) {
        Intrinsics.checkNotNullParameter((Object)saveStateCallback2, (String)"saveStateCallback");
        Intrinsics.checkNotNullParameter((Object)fuelValues, (String)"fuelValues");
        super(saveStateCallback2);
        this.fuelValues = fuelValues;
    }

    @NotNull
    public final FuelValues getFuelValues() {
        return this.fuelValues;
    }

    @Override
    public int calculateBurnTimeOfNextItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.isEmpty()) {
            return 0;
        }
        return stack.getItem().getBurnTime(stack, null, this.fuelValues);
    }

    @Override
    @NotNull
    protected Emissions getEmissions() {
        return SmokeGenerator.INSTANCE;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.fuelValues.isFuel(stack);
    }
}

