/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.item;

import com.github.bonndan.blimpy.blimp.entity.BlimpEntity;
import com.github.bonndan.blimpy.setup.ModEntityTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/github/bonndan/blimpy/blimp/item/BlimpItem;", "Lnet/minecraft/world/item/Item;", "props", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResult;", "world", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "getEntity", "Lcom/github/bonndan/blimpy/blimp/entity/BlimpEntity;", "stack", "Lnet/minecraft/world/item/ItemStack;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "blimpy"})
public final class BlimpItem
extends Item {
    public BlimpItem(@NotNull Item.Properties props) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        super(props);
    }

    @NotNull
    public InteractionResult use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitResult = Item.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            InteractionResult.Pass pass = InteractionResult.PASS;
            Intrinsics.checkNotNullExpressionValue((Object)pass, (String)"PASS");
            return (InteractionResult)pass;
        }
        Vec3 vector3d = player.getViewVector(1.0f);
        List entities = world.getEntities((Entity)player, player.getBoundingBox().expandTowards(vector3d.scale(5.0)).inflate(1.0), EntitySelector.NO_SPECTATORS.and(arg_0 -> BlimpItem.use$lambda$1(BlimpItem::use$lambda$0, arg_0)));
        Intrinsics.checkNotNull((Object)entities);
        if (!((Collection)entities).isEmpty()) {
            Vec3 vector3d1 = player.getEyePosition(1.0f);
            for (Entity entity : entities) {
                AABB axisalignedBox = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!axisalignedBox.contains(vector3d1)) continue;
                InteractionResult.Pass pass = InteractionResult.PASS;
                Intrinsics.checkNotNullExpressionValue((Object)pass, (String)"PASS");
                return (InteractionResult)pass;
            }
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            InteractionResult interactionResult;
            Intrinsics.checkNotNull((Object)itemstack);
            Intrinsics.checkNotNull((Object)hitResult);
            BlimpEntity entity = this.getEntity(world, itemstack, hitResult, player);
            if (entity == null) {
                InteractionResult.Fail fail = InteractionResult.FAIL;
                Intrinsics.checkNotNullExpressionValue((Object)fail, (String)"FAIL");
                return (InteractionResult)fail;
            }
            entity.setYRot(player.getYRot());
            if (!world.noCollision((Entity)entity, entity.getBoundingBox().inflate(-0.1))) {
                var9_9 = InteractionResult.FAIL;
                Intrinsics.checkNotNull((Object)var9_9);
                interactionResult = (InteractionResult)var9_9;
            } else {
                if (!world.isClientSide) {
                    world.addFreshEntity((Entity)entity);
                    if (!player.getAbilities().instabuild) {
                        itemstack.shrink(1);
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                var9_9 = InteractionResult.SUCCESS;
                Intrinsics.checkNotNull((Object)var9_9);
                interactionResult = (InteractionResult)var9_9;
            }
            return interactionResult;
        }
        InteractionResult.Pass pass = InteractionResult.PASS;
        Intrinsics.checkNotNullExpressionValue((Object)pass, (String)"PASS");
        return (InteractionResult)pass;
    }

    private final BlimpEntity getEntity(Level world, ItemStack stack, BlockHitResult hitResult, Player player) {
        EntityType<BlimpEntity> entityType = ModEntityTypes.INSTANCE.getBLIMP().get();
        Intrinsics.checkNotNullExpressionValue(entityType, (String)"get(...)");
        EntityType<BlimpEntity> entityType2 = entityType;
        BlimpEntity blimp = (BlimpEntity)entityType2.create(world, EntitySpawnReason.SPAWN_ITEM_USE);
        if (blimp != null) {
            Vec3 vec3 = hitResult.getLocation();
            blimp.setInitialPos(vec3.x, vec3.y, vec3.z);
            if (world instanceof ServerLevel) {
                EntityType.createDefaultStackConfig((Level)world, (ItemStack)stack, (LivingEntity)((LivingEntity)player)).accept(blimp);
            }
        }
        return blimp;
    }

    private static final boolean use$lambda$0(Entity obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.isPickable();
    }

    private static final boolean use$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

